/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.component.AttributeConstants;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.MenuRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SelectManyCheckboxListRenderer
extends MenuRenderer {
    private static final String[] selectManyCheckboxPassThruAttributes = AttributeConstants.getAttributes(18);

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element rootNode;
        SelectManyCheckboxListRenderer.validateParameters(facesContext, uiComponent, null);
        String componentName = uiComponent.getClass().getName();
        if (componentName.equals("com.icesoft.faces.component.ext.HtmlRadio") || componentName.equals("com.icesoft.faces.component.ext.HtmlCheckbox")) {
            this.renderOption(facesContext, uiComponent);
            return;
        }
        int counter = 0;
        boolean renderVertically = false;
        String layout = (String)uiComponent.getAttributes().get("layout");
        if (layout != null && layout.equals("spread")) {
            return;
        }
        if (layout != null) {
            renderVertically = layout.equalsIgnoreCase("pageDirection");
        }
        int border = this.getBorderSize(uiComponent);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        Element rootTR = null;
        if (!domContext.isInitialized()) {
            rootNode = this.createRootNode(domContext);
            SelectManyCheckboxListRenderer.setRootElementId(facesContext, rootNode, uiComponent);
            this.addJavaScript(facesContext, uiComponent, rootNode, new HashSet());
        }
        rootNode = (Element)domContext.getRootNode();
        Element rootTable = this.getTableElement(domContext);
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (styleClass != null) {
            rootNode.setAttribute("class", styleClass);
            rootTable.setAttribute("class", styleClass);
        }
        rootTable.setAttribute("border", new Integer(border).toString());
        if (!renderVertically) {
            rootTR = domContext.createElement("tr");
            rootTable.appendChild(rootTR);
        }
        Iterator options = this.getSelectItems(uiComponent);
        Object[] submittedValue = null;
        Object componentValue = null;
        if (options.hasNext() && (submittedValue = this.getSubmittedSelectedValues(uiComponent)) == null) {
            componentValue = this.getCurrentSelectedValues(uiComponent);
        }
        while (options.hasNext()) {
            SelectItem nextSelectItem = (SelectItem)options.next();
            ++counter;
            if (nextSelectItem instanceof SelectItemGroup) {
                Element nextTR = domContext.createElement("tr");
                Element nextTD = null;
                if (nextSelectItem.getLabel() != null) {
                    if (renderVertically) {
                        rootTable.appendChild(nextTR);
                    }
                    nextTD = domContext.createElement("td");
                    nextTR.appendChild(nextTD);
                    Text label = domContext.createTextNode(nextSelectItem.getLabel());
                    nextTD.appendChild(label);
                }
                if (renderVertically) {
                    nextTR = domContext.createElement("tr");
                    rootTable.appendChild(nextTR);
                } else {
                    rootTable.appendChild(nextTR);
                }
                nextTD = domContext.createElement("td");
                nextTR.appendChild(nextTD);
                SelectItem[] selectItemsArray = ((SelectItemGroup)nextSelectItem).getSelectItems();
                for (int i = 0; i < selectItemsArray.length; ++i) {
                    this.renderOption(facesContext, uiComponent, selectItemsArray[i], renderVertically, rootTable, nextTR, counter, submittedValue, componentValue);
                }
                continue;
            }
            this.renderOption(facesContext, uiComponent, nextSelectItem, renderVertically, rootTable, rootTR, counter, submittedValue, componentValue);
        }
        if (uiComponent.getClass().getName().equals("com.icesoft.faces.component.ext.HtmlSelectOneRadio")) {
            rootNode.removeAttribute("tabindex");
            rootNode.removeAttribute("onclick");
            String legend = (String)uiComponent.getAttributes().get("legend");
            if (legend != null) {
                Element legendElement = domContext.createElement("legend");
                legendElement.appendChild(domContext.createTextNode(legend));
                rootNode.insertBefore(legendElement, rootTable);
            }
        }
        domContext.stepOver();
    }

    private int getBorderSize(UIComponent uiComponent) {
        int border = 0;
        Object borderAttribute = uiComponent.getAttributes().get("border");
        if (borderAttribute instanceof Integer) {
            if ((Integer)borderAttribute != Integer.MIN_VALUE) {
                border = (Integer)borderAttribute;
            }
        } else {
            try {
                border = Integer.valueOf(borderAttribute.toString());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return border;
    }

    protected void renderOption(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, boolean renderVertically, Element rootTable, Element rootTR, int counter, Object[] submittedValue, Object componentValue) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        boolean disabled = false;
        if (uiComponent.getAttributes().get("disabled") != null && uiComponent.getAttributes().get("disabled").equals(Boolean.TRUE)) {
            disabled = true;
        }
        if (selectItem.isDisabled()) {
            disabled = true;
        }
        if (renderVertically) {
            rootTR = domContext.createElement("tr");
            rootTable.appendChild(rootTR);
        }
        Element td = domContext.createElement("td");
        rootTR.appendChild(td);
        String clientId = uiComponent.getClientId(facesContext);
        String itemId = ClientIdPool.get(clientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + "_" + counter);
        Element inputElement = domContext.createElement("input");
        inputElement.setAttribute("name", clientId);
        inputElement.setAttribute("id", itemId);
        td.appendChild(inputElement);
        if (selectItem.getLabel() != null) {
            Element label = domContext.createElement("label");
            label.setAttribute("for", itemId);
            Text textNode = domContext.createTextNode(selectItem.getLabel());
            label.appendChild(textNode);
            td.appendChild(label);
        }
        HashSet<String> excludes = new HashSet<String>();
        String accesskey = (String)uiComponent.getAttributes().get("accesskey");
        if (accesskey != null) {
            inputElement.setAttribute("accesskey", accesskey);
            excludes.add("accesskey");
        }
        String formattedOptionValue = this.formatComponentValue(facesContext, uiComponent, selectItem.getValue());
        inputElement.setAttribute("value", formattedOptionValue);
        inputElement.setAttribute("type", "checkbox");
        if (this.isValueSelected(facesContext, selectItem, uiComponent, submittedValue, componentValue)) {
            inputElement.setAttribute("checked", Boolean.TRUE.toString());
        }
        if (disabled) {
            inputElement.setAttribute("disabled", "disabled");
        }
        boolean readonly = false;
        if (uiComponent.getAttributes().get("readonly") != null && uiComponent.getAttributes().get("readonly").equals(Boolean.TRUE)) {
            readonly = true;
        }
        if (readonly) {
            inputElement.setAttribute("readonly", "readonly");
        }
        excludes.add("style");
        excludes.add("border");
        String[] excludesStringArray = new String[excludes.size()];
        excludesStringArray = excludes.toArray(excludesStringArray);
        PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, inputElement, rootTable, selectManyCheckboxPassThruAttributes);
        inputElement.setAttribute("onkeypress", SelectManyCheckboxListRenderer.combinedPassThru((String)uiComponent.getAttributes().get("onkeypress"), "Ice.util.radioCheckboxEnter(form,this,event);"));
    }

    protected void renderOption(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        SelectManyCheckboxListRenderer.validateParameters(facesContext, uiComponent, null);
        UIComponent forComponent = SelectManyCheckboxListRenderer.findForComponent(facesContext, uiComponent);
        if (!(forComponent instanceof UISelectMany)) {
            throw new IllegalStateException("Could not find UISelectMany component for checkbox.");
        }
        String layout = (String)forComponent.getAttributes().get("layout");
        if (layout == null || !layout.equals("spread")) {
            return;
        }
        List selectItemList = this.getSelectItemList(forComponent);
        if (selectItemList.isEmpty()) {
            throw new IllegalStateException("Could not find select items for UISelectMany component.");
        }
        Object[] submittedValue = this.getSubmittedSelectedValues(forComponent);
        Object componentValue = submittedValue != null ? null : this.getCurrentSelectedValues(forComponent);
        UISelectMany selectMany = (UISelectMany)forComponent;
        int checkboxIndex = (Integer)uiComponent.getAttributes().get("index");
        if (checkboxIndex < 0) {
            checkboxIndex = 0;
        }
        if (checkboxIndex >= selectItemList.size()) {
            checkboxIndex = selectItemList.size() - 1;
        }
        String title = (String)uiComponent.getAttributes().get("title");
        SelectItem selectItem = (SelectItem)selectItemList.get(checkboxIndex);
        String selectManyClientId = selectMany.getClientId(facesContext);
        String checkboxClientId = ClientIdPool.get(selectManyClientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + "_" + checkboxIndex);
        String selectItemValue = this.formatComponentValue(facesContext, (UIComponent)selectMany, selectItem.getValue());
        String selectItemLabel = selectItem.getLabel();
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (domContext.isInitialized()) {
            DOMContext.removeChildren(domContext.getRootNode());
        } else {
            domContext.createRootElement("span");
        }
        Node rootNode = domContext.getRootNode();
        HashSet excludes = new HashSet();
        Element input = domContext.createElement("input");
        input.setAttribute("type", "checkbox");
        input.setAttribute("id", checkboxClientId);
        input.setAttribute("name", selectManyClientId);
        input.setAttribute("value", selectItemValue);
        if (selectItem.isDisabled()) {
            input.setAttribute("disabled", "disabled");
        }
        if (this.isValueSelected(facesContext, selectItem, (UIComponent)selectMany, submittedValue, componentValue)) {
            input.setAttribute("checked", "checked");
        }
        if (title != null) {
            input.setAttribute("title", title);
        }
        this.addJavaScript(facesContext, (UIComponent)selectMany, input, excludes);
        Element label = domContext.createElement("label");
        label.setAttribute("for", checkboxClientId);
        if (selectItemLabel != null) {
            label.appendChild(domContext.createTextNode(selectItemLabel));
        }
        PassThruAttributeRenderer.renderHtmlAttributes(facesContext, (UIComponent)selectMany, input, label, selectManyCheckboxPassThruAttributes);
        PassThruAttributeRenderer.renderBooleanAttributes(facesContext, uiComponent, input, PassThruAttributeRenderer.EMPTY_STRING_ARRAY);
        input.setAttribute("onkeypress", SelectManyCheckboxListRenderer.combinedPassThru((String)selectMany.getAttributes().get("onkeypress"), "Ice.util.radioCheckboxEnter(form,this,event);"));
        rootNode.appendChild(input);
        rootNode.appendChild(label);
        domContext.stepOver();
    }

    protected void addJavaScript(FacesContext facesContext, UIComponent uiComponent, Element root, Set excludes) {
    }

    protected List getSelectItemList(UIComponent uiComponent) {
        ArrayList list = new ArrayList();
        Iterator iter = this.getSelectItems(uiComponent);
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof SelectItemGroup) {
                this.addSelectItemGroupToList((SelectItemGroup)o, list);
                continue;
            }
            list.add(o);
        }
        return list;
    }

    private void addSelectItemGroupToList(SelectItemGroup selectItemGroup, List list) {
        SelectItem[] selectItems = selectItemGroup.getSelectItems();
        if (selectItems == null || selectItems.length == 0) {
            list.add(selectItemGroup);
            return;
        }
        for (int i = 0; i < selectItems.length; ++i) {
            SelectItem selectItem = selectItems[i];
            if (selectItem instanceof SelectItemGroup) {
                this.addSelectItemGroupToList((SelectItemGroup)selectItem, list);
                continue;
            }
            list.add(selectItem);
        }
    }

    protected Element getTableElement(DOMContext domContext) {
        return (Element)domContext.getRootNode();
    }

    protected Element createRootNode(DOMContext domContext) {
        return domContext.createRootElement("table");
    }
}

