/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.selectinputtext;

import com.icesoft.faces.component.selectinputtext.SelectInputText;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.DOMUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SelectInputTextRenderer
extends DomBasicInputRenderer {
    private final String AUTOCOMPLETE_DIV = "autoCompleteDiv";
    private static final Log log = LogFactory.getLog((Class)SelectInputTextRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        if (log.isTraceEnabled()) {
            log.trace((Object)"encodeBegin");
        }
        SelectInputText component = (SelectInputText)uiComponent;
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        String divId = clientId + "autoCompleteDiv";
        String call = " new Ice.Autocompleter('" + clientId + "','" + divId + "', " + component.getOptions() + " ,'" + component.getRowClass() + "','" + component.getSelectedRowClass() + "');";
        if (!domContext.isInitialized()) {
            Element root = domContext.createRootElement("div");
            Element input = domContext.createElement("input");
            input.setAttribute("type", "text");
            SelectInputTextRenderer.setRootElementId((FacesContext)facesContext, (Element)input, (UIComponent)uiComponent);
            root.appendChild(input);
            input.setAttribute("name", clientId);
            input.setAttribute("class", component.getInputTextClass());
            String inputStyle = component.getWidthAsStyle();
            if (inputStyle != null && inputStyle.length() > 0) {
                input.setAttribute("style", inputStyle);
            } else {
                input.removeAttribute("style");
            }
            input.setAttribute("autocomplete", "off");
            Element div = domContext.createElement("div");
            String listClass = component.getListClass();
            div.setAttribute("id", divId);
            if (listClass == null) {
                div.setAttribute("style", "display:none;border:1px solid black;background-color:white;z-index:500;");
            } else {
                div.setAttribute("class", listClass);
            }
            root.appendChild(div);
            String rootStyle = component.getStyle();
            if (rootStyle != null && rootStyle.length() > 0) {
                root.setAttribute("style", rootStyle);
            } else {
                root.removeAttribute("style");
            }
            root.setAttribute("class", component.getStyleClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("SelectInputText:encodeBegin():component created with the following id : " + clientId));
            }
        }
        HashSet<String> excludes = new HashSet<String>();
        excludes.add("onkeydown");
        excludes.add("onkeyup");
        excludes.add("onfocus");
        excludes.add("onblur");
        PassThruAttributeRenderer.renderAttributes((FacesContext)facesContext, (UIComponent)uiComponent, (String[])SelectInputTextRenderer.getExcludesArray(excludes));
        JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)call);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        SelectInputText component = (SelectInputText)uiComponent;
        Element input = (Element)domContext.getRootNode().getFirstChild();
        input.setAttribute("onfocus", "setFocus(this.id);");
        input.setAttribute("onblur", "setFocus('');");
        Object value = component.getValue();
        if (value != null) {
            input.setAttribute("value", value.toString());
            if (component.hasChanged() && value.toString().length() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SelectInputText:encodeChildren(): component's value have been changed, start populating list : ");
                }
                this.populateList(facesContext, uiComponent);
                component.setChangedComponentId(null);
            }
        }
        SelectInputTextRenderer.renderAttribute((UIComponent)uiComponent, (Element)input, (String)"disabled", (String)"disabled");
        SelectInputTextRenderer.renderAttribute((UIComponent)uiComponent, (Element)input, (String)"readonly", (String)"readonly");
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    public void populateList(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (uiComponent instanceof UIInput) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"populateList");
            }
            SelectInputText component = (SelectInputText)uiComponent;
            Iterator matchs = component.getItemList();
            if (component.getSelectFacet() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SelectInputText:populateList(): \"selectInputText\" facet found, generate generic html for list");
                }
                UIComponent facet = component.getSelectFacet();
                DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
                Element listDiv = domContext.createElement("div");
                Map requestMap = facesContext.getExternalContext().getRequestMap();
                component.setIndex(0);
                while (matchs.hasNext()) {
                    Element div = domContext.createElement("div");
                    SelectItem item = (SelectItem)matchs.next();
                    requestMap.put(component.getListVar(), item.getValue());
                    listDiv.appendChild(div);
                    Element spanToDisplay = domContext.createElement("span");
                    spanToDisplay.setAttribute("class", "informal");
                    div.appendChild(spanToDisplay);
                    domContext.setCursorParent((Node)spanToDisplay);
                    SelectInputTextRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)facet);
                    Element spanToSelect = domContext.createElement("span");
                    spanToSelect.setAttribute("style", "visibility:hidden;display:none;");
                    Text label = domContext.createTextNode(DOMUtils.escapeAnsi((String)item.getLabel()));
                    spanToSelect.appendChild(label);
                    div.appendChild(spanToSelect);
                    component.resetId(facet);
                }
                component.setIndex(-1);
                String nodeValue = DOMUtils.nodeToString((Node)listDiv).replaceAll("\n", "");
                String call = "Autocompleter.Finder.find('" + component.getClientId(facesContext) + "').updateNOW('" + nodeValue + "');";
                JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)call);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SelectInputText:populateList(): \"selectItem(s)\" found, generate plain-text for list");
                }
                if (matchs.hasNext()) {
                    StringBuffer sb = new StringBuffer("<div>");
                    SelectItem item = null;
                    while (matchs.hasNext()) {
                        item = (SelectItem)matchs.next();
                        sb.append("<div>").append(DOMUtils.escapeAnsi((String)item.getLabel())).append("</div>");
                    }
                    sb.append("</div>");
                    String call = "Autocompleter.Finder.find('" + component.getClientId(facesContext) + "').updateNOW('" + sb.toString() + "');";
                    JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)call);
                }
            }
        }
    }
}

