/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.accordion;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.ValueChangeEvent;
import org.icefaces.mobi.api.ContentPaneController;
import org.icefaces.mobi.component.accordion.AccordionBase;
import org.icefaces.mobi.renderkit.InlineScriptEventListener;
import org.icefaces.mobi.utils.JSFUtils;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.component.IAccordion;
import org.icemobile.util.ClientDescriptor;

public class Accordion
extends AccordionBase
implements ContentPaneController,
IAccordion {
    public static final String JS_LIBRARY = "org.icefaces.component.accordion";
    private static Logger logger = Logger.getLogger(Accordion.class.getName());
    private String hashVal;

    public void setHashVal(String hashVal) {
        this.hashVal = hashVal;
    }

    public String getHashVal() {
        return this.hashVal;
    }

    public void queueEvent(FacesEvent event) {
        if (event.getComponent() == this) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("invoked event for Accordion with selectedId= " + this.getSelectedId());
            }
            event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        }
        super.queueEvent(event);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        MethodExpression me = this.getPaneChangeListener();
        if (me != null && event instanceof ValueChangeEvent) {
            me.invoke(facesContext.getELContext(), new Object[]{event});
        }
    }

    public ClientDescriptor getClient() {
        return MobiJSFUtils.getClientDescriptor();
    }

    public boolean isProductionProjectStage() {
        return FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Production);
    }

    public String getJavascriptFileRequestPath() {
        String jsFname = "accordion.js";
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Production)) {
            jsFname = "accordion-min.js";
        }
        Resource jsFile = facesContext.getApplication().getResourceHandler().createResource(jsFname, JS_LIBRARY);
        return jsFile.getRequestPath();
    }

    public boolean isScriptLoaded() {
        return InlineScriptEventListener.isScriptLoaded(FacesContext.getCurrentInstance(), "accordion.js");
    }

    public void setScriptLoaded() {
        InlineScriptEventListener.setScriptLoaded(FacesContext.getCurrentInstance(), "accordion.js");
    }

    public String getOpenedPaneClientId() {
        UIComponent openPane = null;
        String currentId = this.getSelectedId();
        if (this.getChildCount() <= 0) {
            logger.finer("this component must have panels defined as children. Please read DOCS.");
            return null;
        }
        openPane = JSFUtils.getChildById((UIComponent)this, currentId);
        String clId = null;
        if (openPane != null) {
            clId = openPane.getClientId(FacesContext.getCurrentInstance());
        }
        return clId;
    }
}

