/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.augmentedreality;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.impl.application.AuxUploadResourceHandler;
import org.icefaces.mobi.component.augmentedreality.AugmentedReality;
import org.icefaces.mobi.component.augmentedreality.AugmentedRealityLocations;
import org.icefaces.mobi.component.augmentedreality.AugmentedRealityMarkers;
import org.icefaces.mobi.renderkit.BaseInputRenderer;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icefaces.util.EnvUtils;
import org.icemobile.util.ClientDescriptor;

public class AugmentedRealityRenderer
extends BaseInputRenderer {
    private static final String LOC_LABEL = "locationLabel";
    private static final String LOC_LAT = "locationLat";
    private static final String LOC_LON = "locationLon";
    private static final String LOC_ALT = "locationAlt";
    private static final String LOC_DIR = "locationDir";
    private static final String LOC_ICON = "locationIcon";
    private static final String MARK_MODEL = "markerModel";
    private static final String MARK_LABEL = "markerLabel";

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String script;
        String style;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        AugmentedReality ag = (AugmentedReality)uiComponent;
        ClientDescriptor clientDescriptor = MobiJSFUtils.getClientDescriptor();
        boolean isEnhanced = clientDescriptor.isICEmobileContainer();
        boolean isAuxUpload = EnvUtils.isAuxUploadBrowser((FacesContext)facesContext);
        if (!isEnhanced && !isAuxUpload) {
            String myparams = ag.getParams();
            writer.startElement("input", uiComponent);
            writer.writeAttribute("data-params", (Object)myparams, null);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("name", (Object)clientId, null);
            writer.endElement("input");
            return;
        }
        writer.startElement("button", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        String buttonValue = ag.getButtonLabel();
        if (MobiJSFUtils.uploadInProgress((UIComponent)ag)) {
            buttonValue = ag.getCaptureMessageLabel();
        }
        if (null != ag.getStyle() && (style = ag.getStyle()).trim().length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        StringBuilder defaultClass = new StringBuilder("mobi-button ui-btn-up-c");
        if (null != ag.getStyleClass()) {
            String styleClass = ag.getStyleClass();
            defaultClass.append(" ").append(styleClass);
        }
        writer.writeAttribute("class", (Object)defaultClass, "class");
        String arParams = "";
        String urlBase = ag.getUrlBase();
        if (null != urlBase) {
            arParams = "ub=" + URLEncoder.encode(urlBase) + "&";
        }
        for (UIComponent child : ag.getChildren()) {
            if (child instanceof AugmentedRealityLocations) {
                AugmentedRealityLocations locations = (AugmentedRealityLocations)child;
                arParams = arParams + this.iterateLocations(facesContext, locations);
            }
            if (!(child instanceof AugmentedRealityMarkers)) continue;
            AugmentedRealityMarkers markers = (AugmentedRealityMarkers)child;
            arParams = arParams + this.iterateMarkers(facesContext, markers);
            arParams = arParams + "v=vuforia&";
        }
        if ("".equals(arParams)) {
            arParams = ag.getParams();
        }
        if (isAuxUpload) {
            writer.writeAttribute("data-params", (Object)arParams, null);
            writer.writeAttribute("data-command", (Object)"aug", null);
            String sessionId = MobiJSFUtils.getSessionIdCookie();
            writer.writeAttribute("data-jsessionid", (Object)sessionId, null);
            writer.writeAttribute("data-postURL", (Object)MobiJSFUtils.getPostURL(), null);
            script = "ice.mobi.sx(this);";
        } else {
            script = "ice.aug( '" + clientId + "', '" + arParams + "' );return false;";
        }
        writer.writeAttribute("onclick", (Object)script, null);
        writer.writeText((Object)buttonValue, null);
        writer.endElement("button");
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        String submittedString;
        Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
        AugmentedReality aug = (AugmentedReality)component;
        String clientId = component.getClientId();
        Object submitted = parameterMap.get(clientId);
        if (null == submitted) {
            Map auxMap = AuxUploadResourceHandler.getAuxRequestMap();
            submitted = auxMap.get(clientId);
        }
        if (null != submitted && (submittedString = String.valueOf(submitted)) != null) {
            Object convertedValue = this.getConvertedValue(facesContext, component, submittedString);
            this.setSubmittedValue((UIComponent)aug, convertedValue);
        }
    }

    String iterateLocations(FacesContext facesContext, AugmentedRealityLocations locations) {
        String var = locations.getVar();
        if (null == var) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Collection items = (Collection)locations.getValue();
        for (Object item : items) {
            Object oldVar = requestMap.put(var, item);
            Map attrs = locations.getAttributes();
            String itemLabel = (String)attrs.get(LOC_LABEL);
            result.append(URLEncoder.encode(itemLabel)).append("=");
            result.append(attrs.get(LOC_LAT)).append(",");
            result.append(attrs.get(LOC_LON)).append(",");
            Object itemAlt = attrs.get(LOC_ALT);
            if (null != itemAlt) {
                result.append(itemAlt);
            }
            result.append(",");
            Object itemDir = attrs.get(LOC_DIR);
            if (null != itemDir) {
                result.append(itemDir);
            }
            result.append(",");
            String itemIcon = (String)attrs.get(LOC_ICON);
            if (null != itemIcon) {
                result.append(URLEncoder.encode(itemIcon));
            }
            result.append("&");
            requestMap.put(var, oldVar);
        }
        return result.toString();
    }

    String iterateMarkers(FacesContext facesContext, AugmentedRealityMarkers markers) {
        String var = markers.getVar();
        if (null == var) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Collection items = (Collection)markers.getValue();
        int index = 0;
        for (Object item : items) {
            Object oldVar = requestMap.put(var, item);
            Map attrs = markers.getAttributes();
            String markerLabel = (String)attrs.get(MARK_LABEL);
            String itemID = "_" + index;
            result.append(markerLabel + itemID).append("=");
            String markerModel = (String)attrs.get(MARK_MODEL);
            if (null != markerModel) {
                result.append(URLEncoder.encode(markerModel));
            }
            result.append("&");
            requestMap.put(var, oldVar);
            ++index;
        }
        return result.toString();
    }
}

