/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.button;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.icefaces.mobi.component.button.CommandButton;
import org.icefaces.mobi.component.button.CommandButtonGroup;
import org.icefaces.mobi.component.contentpane.ContentPane;
import org.icefaces.mobi.component.contentstack.ContentStack;
import org.icefaces.mobi.component.panelconfirmation.PanelConfirmation;
import org.icefaces.mobi.component.submitnotification.SubmitNotification;
import org.icefaces.mobi.renderkit.CoreRenderer;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.utils.JSFUtils;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.component.IButton;
import org.icemobile.component.IButtonGroup;
import org.icemobile.renderkit.ButtonCoreRenderer;

public class CommandButtonRenderer
extends CoreRenderer {
    private static Logger logger = Logger.getLogger(CommandButtonRenderer.class.getName());
    List<UIParameter> uiParamChildren;

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        CommandButton commandButton = (CommandButton)uiComponent;
        String source = String.valueOf(requestParameterMap.get("ice.event.captured"));
        String clientId = commandButton.getClientId();
        if (clientId.equals(source)) {
            CommandButtonGroup cbg;
            UIComponent parent = uiComponent.getParent();
            if (parent instanceof CommandButtonGroup && !(cbg = (CommandButtonGroup)parent).isDisabled()) {
                cbg.setSelectedId(clientId);
            }
            try {
                if (!commandButton.isDisabled()) {
                    uiComponent.queueEvent((FacesEvent)new ActionEvent(uiComponent));
                    this.decodeBehaviors(facesContext, uiComponent);
                }
            }
            catch (Exception e) {
                logger.warning("Error queuing CommandButton event");
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIComponent comp;
        String searchId;
        ClientBehaviorHolder cbh;
        boolean hasBehaviors;
        UIComponent stack;
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        IButton button = (IButton)uiComponent;
        ButtonCoreRenderer renderer = new ButtonCoreRenderer();
        String clientId = button.getClientId();
        UIComponent parent = uiComponent.getParent();
        if (parent instanceof IButtonGroup) {
            String selectedId;
            IButtonGroup cbg = (IButtonGroup)parent;
            button.setGroupId(cbg.getClientId());
            if (cbg.isDisabled()) {
                button.setParentDisabled(true);
            }
            if (null != (selectedId = cbg.getSelectedId())) {
                if (selectedId.equals(clientId)) {
                    button.setSelectedButton(true);
                } else {
                    button.setSelectedButton(false);
                }
            }
        }
        if (button.getOpenContentPane() != null && (stack = CommandButtonRenderer.findParentContentStack(uiComponent)) != null) {
            StringBuilder noPanelConf = new StringBuilder("mobi.layoutMenu.showContent('").append(stack.getClientId());
            noPanelConf.append("', event");
            noPanelConf.append(",{ selectedId: '").append(button.getOpenContentPane()).append("'");
            noPanelConf.append(",singleSubmit: ").append(button.isSingleSubmit());
            noPanelConf.append(", item: '").append(uiComponent.getClientId(facesContext)).append("'");
            UIComponent pane = stack.findComponent(button.getOpenContentPane());
            if (pane != null) {
                String paneId = pane.getClientId(facesContext);
                noPanelConf.append(",selClientId: '").append(paneId).append("'");
                ContentPane cp = (ContentPane)pane;
                noPanelConf.append(",client: ").append(cp.isClient());
            }
            noPanelConf.append("});");
            button.setJsCall(noPanelConf);
            renderer.encodeEnd(button, writer);
            return;
        }
        this.uiParamChildren = JSFUtils.captureParameters(uiComponent);
        if (null != this.uiParamChildren) {
            String paramsAsString = MobiJSFUtils.asParameterStringForMobiAjax(this.uiParamChildren);
            button.setParams(paramsAsString);
        }
        boolean bl = hasBehaviors = !(cbh = (ClientBehaviorHolder)uiComponent).getClientBehaviors().isEmpty();
        if (hasBehaviors) {
            String behaviors = this.encodeClientBehaviors(facesContext, cbh, "click").toString();
            behaviors = behaviors.replace("\"", "'");
            button.setBehaviors(behaviors);
        }
        if (null != button.getPanelConfirmation()) {
            searchId = button.getPanelConfirmation();
            comp = this.findClientId(facesContext, uiComponent, searchId);
            if (null != comp) {
                PanelConfirmation pc = (PanelConfirmation)comp;
                button.setPanelConfirmationId(pc.getClientId(facesContext));
            } else {
                logger.log(Level.WARNING, "PanelConfirmation with id=" + searchId + " not found for button id=" + button.getClientId());
            }
        } else {
            button.setPanelConfirmationId(null);
        }
        if (null != button.getSubmitNotification()) {
            searchId = button.getSubmitNotification();
            comp = this.findClientId(facesContext, uiComponent, searchId);
            if (null != comp) {
                SubmitNotification submitNot = (SubmitNotification)comp;
                if (!submitNot.isDisabled()) {
                    button.setSubmitNotificationId(submitNot.getClientId(facesContext));
                } else {
                    button.setSubmitNotificationId(null);
                    logger.log(Level.FINE, "submit notification is found but disabled");
                }
            } else {
                logger.log(Level.WARNING, "SubmitNotification with id=" + searchId + " not found for button id=" + button.getClientId());
            }
        } else {
            button.setSubmitNotificationId(null);
        }
        renderer.encodeEnd(button, writer);
    }

    protected static UIComponent findParentContentStack(UIComponent component) {
        UIComponent parent;
        for (parent = component; parent != null && !(parent instanceof ContentStack); parent = parent.getParent()) {
        }
        return parent;
    }

    private UIComponent findClientId(FacesContext facesContext, UIComponent button, String id) {
        UIComponent uiForm = JSFUtils.findParentForm(button);
        if (null != uiForm) {
            UIComponent component = uiForm.findComponent(id);
            if (null != component) {
                return component;
            }
            UIViewRoot root = facesContext.getViewRoot();
            component = root.findComponent(id);
            if (null != component) {
                return component;
            }
        }
        logger.warning("Cannot find component linked to commandButton with id=" + id);
        return null;
    }
}

