/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.carousel;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.application.Resource;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.ValueChangeEvent;
import org.icefaces.mobi.component.carousel.CarouselBase;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.component.ICarousel;
import org.icemobile.util.ClientDescriptor;

public class Carousel
extends CarouselBase
implements ICarousel {
    private static Logger logger = Logger.getLogger(Carousel.class.getName());
    private String behaviors;

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ValueChangeEvent) {
            MethodExpression method;
            if (event != null) {
                int tempInt = (Integer)((ValueChangeEvent)event).getNewValue();
                this.setSelectedItem(tempInt);
            }
            if ((method = this.getValueChangeListener()) != null) {
                method.invoke(this.getFacesContext().getELContext(), new Object[]{event});
            }
        } else {
            super.broadcast(event);
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event.getComponent() == this) {
            boolean isImmediate = this.isImmediate();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("invoked event for immediate " + isImmediate);
            }
            if (isImmediate) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public String getIScrollSrc() {
        Resource jsFile = this.getFacesContext().getApplication().getResourceHandler().createResource("iscroll.js", "org.icefaces.component.util");
        String src = jsFile.getRequestPath();
        return src;
    }

    public StringBuilder getJSConfigOptions() {
        boolean hasBehaviors;
        StringBuilder builder = new StringBuilder(255);
        String clientId = this.getClientId(this.getFacesContext());
        builder.append(",{ singleSubmit: ").append(this.isSingleSubmit());
        builder.append(", key: ").append(this.getSelectedItem());
        int hashcode = MobiJSFUtils.generateHashCode(this.getSelectedItem() + this.getRowCount());
        builder.append(", hash: ").append(hashcode);
        boolean bl = hasBehaviors = this.getBehaviors() != null;
        if (hasBehaviors) {
            builder.append(this.behaviors);
        }
        builder.append("}");
        return builder;
    }

    public ClientDescriptor getClient() {
        return MobiJSFUtils.getClientDescriptor();
    }

    public String getBehaviors() {
        return this.behaviors;
    }

    public void setBehaviors(String behaviors) {
        this.behaviors = behaviors;
    }

    public String getName() {
        return this.getClientId() + "_hidden";
    }
}

