/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.contentnavbar;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.component.contentnavbar.ContentNavBar;
import org.icefaces.mobi.component.contentpane.ContentPane;
import org.icefaces.mobi.renderkit.BaseLayoutRenderer;

public class ContentNavBarRenderer
extends BaseLayoutRenderer {
    private static Logger logger = Logger.getLogger(ContentNavBarRenderer.class.getName());

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIComponent parent = ContentNavBarRenderer.findParentContentPane(uiComponent);
        if (!(parent instanceof ContentPane) && logger.isLoggable(Level.FINER)) {
            logger.finer("this component must be a child of ContentPane");
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        ContentNavBar navbar = (ContentNavBar)uiComponent;
        ContentPane cp = (ContentPane)parent;
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        StringBuilder styleClass = new StringBuilder("mobi-contentnavbar-header");
        StringBuilder buttonClass = new StringBuilder("mobi-contentnavbar-button");
        String userDefinedClass = navbar.getStyleClass();
        if (userDefinedClass != null && userDefinedClass.length() > 0) {
            styleClass.append(" ").append(userDefinedClass);
            buttonClass.append(" ").append(userDefinedClass);
        }
        writer.writeAttribute("class", (Object)styleClass.toString(), "styleClass");
        if (navbar.getStyle() != null) {
            writer.writeAttribute("style", (Object)navbar.getStyle(), "style");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.renderChildren(facesContext, uiComponent);
    }
}

