/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.contentpane;

import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import org.icefaces.mobi.api.ContentPaneController;

public class ContentPaneHandler
extends ComponentHandler {
    private static final String SKIP_CONSTRUCTION_KEY = "org.icefaces.mobi.contentPane.SKIP_CONSTRUCTION";
    private final TagAttribute facelet;
    private final TagAttribute client;

    public ContentPaneHandler(ComponentConfig componentConfig) {
        super(componentConfig);
        Tag tag = componentConfig.getTag();
        this.facelet = tag.getAttributes().get("facelet");
        this.client = tag.getAttributes().get("client");
    }

    public void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        this.updateFlagShouldOptimiseSkipChildConstruction(ctx, c, parent);
    }

    public void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        Boolean skip;
        UIComponent parent = c.getParent();
        if (parent != null) {
            this.updateFlagShouldOptimiseSkipChildConstruction(ctx, c, parent);
        }
        if ((skip = (Boolean)c.getAttributes().get(SKIP_CONSTRUCTION_KEY)) == null || !skip.booleanValue()) {
            super.applyNextHandler(ctx, c);
        }
    }

    protected boolean updateFlagShouldOptimiseSkipChildConstruction(FaceletContext ctx, UIComponent c, UIComponent parent) {
        boolean skip = this.shouldOptimiseSkipChildConstruction(ctx, c, parent);
        if (skip) {
            c.getAttributes().put(SKIP_CONSTRUCTION_KEY, Boolean.TRUE);
        } else {
            c.getAttributes().remove(SKIP_CONSTRUCTION_KEY);
        }
        return skip;
    }

    protected boolean shouldOptimiseSkipChildConstruction(FaceletContext ctx, UIComponent c, UIComponent parent) {
        boolean overridden = false;
        if (this.client != null && this.client.getBoolean(ctx)) {
            overridden = true;
        }
        if (this.facelet == null || !this.facelet.getBoolean(ctx) || overridden) {
            return false;
        }
        if (!(parent instanceof ContentPaneController)) {
            return false;
        }
        String selectedId = ((ContentPaneController)parent).getSelectedId();
        if (selectedId == null || selectedId.length() == 0) {
            return false;
        }
        return !selectedId.equals(c.getId());
    }
}

