/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.graphicimage;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.icefaces.application.ResourceRegistry;
import org.icefaces.mobi.component.graphicimage.GraphicImageBase;
import org.icefaces.mobi.utils.Attribute;
import org.icefaces.mobi.utils.IceOutputResource;

public class GraphicImage
extends GraphicImageBase {
    private static final Logger logger = Logger.getLogger(GraphicImage.class.toString());
    private Attribute[] attributesNames = new Attribute[]{new Attribute("alt", null), new Attribute("height", null), new Attribute("width", null), new Attribute("style", null), new Attribute("lang", null), new Attribute("usemap", null), new Attribute("longdesc", null), new Attribute("title", null), new Attribute("onclick", "click"), new Attribute("onkeypress", "keypress")};
    private Attribute[] booleanAttNames = new Attribute[]{new Attribute("readonly", null), new Attribute("disabled", null)};

    public String processSrcAttribute(FacesContext facesContext, Object o, String name, String mimeType, String scope) {
        if (o instanceof IceOutputResource) {
            IceOutputResource iceResource = (IceOutputResource)o;
            return this.registerAndGetPath(scope, iceResource);
        }
        if (o instanceof byte[]) {
            IceOutputResource ior = new IceOutputResource(name, o, mimeType);
            String registeredPath = this.registerAndGetPath(scope, ior);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Returning path=" + registeredPath + " FOR SCOPE+" + scope);
            }
            return registeredPath;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("just getting the string representation");
        }
        return this.processStaticImage(facesContext);
    }

    private String registerAndGetPath(String scope, IceOutputResource iceResource) {
        String registeredPath = "";
        if (scope.equals("flash")) {
            registeredPath = ResourceRegistry.addFlashResource((Resource)iceResource);
        } else if (scope.equals("application")) {
            registeredPath = ResourceRegistry.addApplicationResource((Resource)iceResource);
        } else if (scope.equals("window")) {
            registeredPath = ResourceRegistry.addWindowResource((Resource)iceResource);
        } else if (scope.equals("view")) {
            registeredPath = ResourceRegistry.addViewResource((Resource)iceResource);
        } else if (scope.equals("session")) {
            registeredPath = ResourceRegistry.addSessionResource((Resource)iceResource);
        }
        return registeredPath;
    }

    protected String processStaticImage(FacesContext facesContext) {
        String value = (String)super.getValue();
        if (value == null) {
            value = super.getUrl();
        }
        if (value != null) {
            return facesContext.getApplication().getViewHandler().getResourceURL(facesContext, value);
        }
        return "";
    }

    private ResourceRegistry lookupRegistry(FacesContext facesContext) {
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        if (applicationMap.containsKey(ResourceRegistry.class.getName())) {
            ResourceRegistry rr = (ResourceRegistry)applicationMap.get(ResourceRegistry.class.getName());
            return rr;
        }
        return null;
    }

    public Attribute[] getAttributesNames() {
        return this.attributesNames;
    }

    public void setAttributesNames(Attribute[] attributesNames) {
        this.attributesNames = attributesNames;
    }

    public Attribute[] getBooleanAttNames() {
        return this.booleanAttNames;
    }

    public void setBooleanAttNames(Attribute[] booleanAttNames) {
        this.booleanAttNames = booleanAttNames;
    }

    private static String getImageSource(FacesContext context, UIComponent component, String attrName) {
        String resourceName = (String)component.getAttributes().get("name");
        if (resourceName != null) {
            String libName = (String)component.getAttributes().get("library");
            ResourceHandler handler = context.getApplication().getResourceHandler();
            Resource res = handler.createResource(resourceName, libName);
            if (res == null) {
                if (context.isProjectStage(ProjectStage.Development)) {
                    String msg = "Unable to find resource " + resourceName;
                    context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
                }
                return "RES_NOT_FOUND";
            }
            String requestPath = res.getRequestPath();
            return context.getExternalContext().encodeResourceURL(requestPath);
        }
        String value = (String)component.getAttributes().get(attrName);
        if (value == null || value.length() == 0) {
            return "";
        }
        if (value.contains("/javax.faces.resource")) {
            return value;
        }
        value = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(value);
    }
}

