/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.menubutton;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.icefaces.mobi.component.menubutton.MenuButtonItem;
import org.icefaces.mobi.component.menubutton.MenuButtonRenderer;
import org.icefaces.mobi.component.panelconfirmation.PanelConfirmation;
import org.icefaces.mobi.component.submitnotification.SubmitNotificationRenderer;
import org.icefaces.mobi.renderkit.BaseLayoutRenderer;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.utils.JSFUtils;
import org.icemobile.component.IMenuButton;
import org.icemobile.component.IMenuButtonGroup;
import org.icemobile.component.IMenuButtonItem;
import org.icemobile.renderkit.MenuButtonItemCoreRenderer;

public class MenuButtonItemRenderer
extends BaseLayoutRenderer {
    private static Logger logger = Logger.getLogger(MenuButtonRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        MenuButtonItem item = (MenuButtonItem)uiComponent;
        String source = String.valueOf(facesContext.getExternalContext().getRequestParameterMap().get("ice.event.captured"));
        String clientId = item.getClientId();
        String parentId = item.getParent().getClientId();
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (clientId.equals(source) || parentId.equals(source)) {
            try {
                if (!item.isDisabled()) {
                    uiComponent.queueEvent((FacesEvent)new ActionEvent(uiComponent));
                    this.decodeBehaviors(facesContext, uiComponent);
                }
            }
            catch (Exception e) {
                logger.warning("Error queuing CommandButton event");
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIComponent parent = uiComponent.getParent();
        if (!(parent instanceof IMenuButton) && !(parent instanceof IMenuButtonGroup)) {
            logger.warning("MenuButtonItem must have parent of MenuButton");
            return;
        }
        UIComponent uiForm = JSFUtils.findParentForm(parent);
        this.setValuesForCoreRendering(facesContext, uiComponent, uiForm);
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        MenuButtonItemCoreRenderer renderer = new MenuButtonItemCoreRenderer();
        IMenuButtonItem item = (IMenuButtonItem)uiComponent;
        renderer.encodeEnd(item, writer);
    }

    private void setValuesForCoreRendering(FacesContext facesContext, UIComponent uiComponent, UIComponent form) throws IOException {
        boolean hasBehaviors;
        MenuButtonItem mbi = (MenuButtonItem)uiComponent;
        String clientId = uiComponent.getClientId(facesContext);
        String subNotId = mbi.getSubmitNotification();
        String panelConfId = mbi.getPanelConfirmation();
        String submitNotificationId = null;
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        boolean bl = hasBehaviors = !cbh.getClientBehaviors().isEmpty();
        if (hasBehaviors) {
            String behaviors = this.encodeClientBehaviors(facesContext, cbh, "change").toString();
            behaviors = behaviors.replace("\"", "'");
            mbi.setBehaviors(behaviors);
        }
        if (null != subNotId && subNotId.length() > 0) {
            UIComponent subObj;
            submitNotificationId = SubmitNotificationRenderer.findSubmitNotificationId(uiComponent, subNotId);
            if (null == submitNotificationId && form != null && null != (subObj = form.findComponent(subNotId))) {
                submitNotificationId = subObj.getClientId();
            }
            if (null != submitNotificationId) {
                mbi.setSubmitNotificationId(submitNotificationId);
            } else {
                logger.warning("no submitNotification id found for id=" + clientId);
            }
        }
        PanelConfirmation pc = null;
        if (null != panelConfId && panelConfId.length() > 1 && null != (pc = (PanelConfirmation)form.findComponent(panelConfId))) {
            String panelConfirmationId = pc.getClientId(facesContext);
            mbi.setPanelConfirmationId(panelConfirmationId);
        }
    }
}

