/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.pagepanel;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.component.pagepanel.PagePanel;
import org.icefaces.mobi.renderkit.BaseLayoutRenderer;
import org.icefaces.mobi.utils.JSFUtils;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icefaces.mobi.utils.PassThruAttributeWriter;

public class PagePanelRenderer
extends BaseLayoutRenderer {
    private static Logger logger = Logger.getLogger(PagePanelRenderer.class.getName());

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String userDefStyle;
        PagePanel pagePanel = (PagePanel)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        writer.startElement("div", (UIComponent)pagePanel);
        writer.writeAttribute("class", (Object)"mobi-pagePanel", null);
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, (UIComponent)pagePanel, pagePanel.getCommonAttributeNames());
        writer.writeAttribute("id", (Object)(clientId + "_pgPnl"), "id");
        if (pagePanel.getStyle() != null) {
            writer.writeAttribute("style", (Object)pagePanel.getStyle(), "style");
        }
        StringBuilder headerClass = new StringBuilder("mobi-pagePanel-header ui-header " + (MobiJSFUtils.getClientDescriptor().isSupportsFixedPosition() ? "ui-header-fixed " : "") + " ui-bar-" + component.getAttributes().get("headerSwatch"));
        StringBuilder bodyClass = new StringBuilder("mobi-pagePanel-body ui-body-" + component.getAttributes().get("bodySwatch"));
        StringBuilder footerClass = new StringBuilder("mobi-pagePanel-footer ui-footer " + (MobiJSFUtils.getClientDescriptor().isSupportsFixedPosition() ? "ui-footer-fixed " : "") + "ui-bar-" + component.getAttributes().get("footerSwatch"));
        StringBuilder headerFooterContentsClass = new StringBuilder("mobi-pagePanel-ctr");
        UIComponent headerFacet = pagePanel.getFacet("header");
        UIComponent bodyFacet = pagePanel.getFacet("body");
        UIComponent footerFacet = pagePanel.getFacet("footer");
        if (headerFacet == null && bodyFacet == null && footerFacet == null) {
            logger.warning("PagePanel header, body and footer were not defined, no content will be rendered by this component.");
        }
        if (headerFacet == null) {
            bodyClass.append(" ").append("mobi-pagePanel-body-noheader");
        }
        if (footerFacet == null) {
            bodyClass.append(" ").append("mobi-pagePanel-body-nofooter");
        }
        if ((userDefStyle = pagePanel.getStyleClass()) != null) {
            headerClass.append(" ").append(userDefStyle);
            bodyClass.append(" ").append(userDefStyle);
            footerClass.append(" ").append(userDefStyle);
            headerFooterContentsClass.append(" ").append(userDefStyle);
        }
        if (headerFacet != null) {
            writer.startElement("div", (UIComponent)pagePanel);
            writer.writeAttribute("class", (Object)headerClass.toString(), "class");
            writer.writeAttribute("id", (Object)(clientId + "_pgPnlHdr"), "id");
            writer.startElement("div", component);
            writer.writeAttribute("class", (Object)headerFooterContentsClass.toString(), "styleClass");
            JSFUtils.renderLayoutChild(facesContext, headerFacet);
            writer.endElement("div");
            writer.endElement("div");
        }
        if (bodyFacet != null) {
            writer.startElement("div", (UIComponent)pagePanel);
            writer.writeAttribute("class", (Object)bodyClass.toString(), "class");
            writer.writeAttribute("id", (Object)(clientId + "_pgPnlBdy"), "id");
            JSFUtils.renderLayoutChild(facesContext, bodyFacet);
            writer.endElement("div");
        }
        if (footerFacet != null) {
            writer.startElement("div", (UIComponent)pagePanel);
            writer.writeAttribute("class", (Object)footerClass.toString(), "class");
            writer.writeAttribute("id", (Object)(clientId + "_pgPnlFtr"), "id");
            writer.startElement("div", component);
            writer.writeAttribute("class", (Object)headerFooterContentsClass, "styleClass");
            JSFUtils.renderLayoutChild(facesContext, footerFacet);
            writer.endElement("div");
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

