/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.scan;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.icefaces.impl.application.AuxUploadResourceHandler;
import org.icefaces.mobi.component.scan.Scan;
import org.icefaces.mobi.renderkit.BaseInputRenderer;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.renderkit.DeviceCoreRenderer;

public class ScanRenderer
extends BaseInputRenderer {
    private static Logger logger = Logger.getLogger(ScanRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String submittedString;
        String valueId;
        Scan scan = (Scan)uiComponent;
        String clientId = scan.getClientId();
        if (scan.isDisabled()) {
            return;
        }
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        Object submitted = requestParameterMap.get(valueId = clientId);
        if (null == submitted) {
            Map auxMap = AuxUploadResourceHandler.getAuxRequestMap();
            submitted = auxMap.get(valueId);
        }
        if (null != submitted && (submittedString = String.valueOf(submitted)) != null) {
            Object convertedValue = this.getConvertedValue(facesContext, uiComponent, submittedString);
            this.setSubmittedValue((UIComponent)scan, convertedValue);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Scan scan = (Scan)uiComponent;
        String oldLabel = scan.getButtonLabel();
        if (MobiJSFUtils.uploadInProgress((UIComponent)scan)) {
            scan.setButtonLabel(scan.getCaptureMessageLabel());
        }
        DeviceCoreRenderer renderer = new DeviceCoreRenderer();
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        renderer.encode(scan, writer, false);
        scan.setButtonLabel(oldLabel);
    }
}

