/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.stylesheet;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.Renderer;
import org.icefaces.mobi.component.stylesheet.DeviceStyleSheet;
import org.icefaces.mobi.utils.JSFUtils;
import org.icefaces.mobi.utils.PassThruAttributeWriter;
import org.icemobile.util.CSSUtils;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class DeviceStyleSheetRenderer
extends Renderer
implements ComponentSystemEventListener {
    private static Logger log = Logger.getLogger(DeviceStyleSheetRenderer.class.getName());
    public static final String EMPTY_STRING = "";
    private static final String CSS_EXT = ".css";
    public static final String CSS_COMPRESSION_POSTFIX = "-min";
    public static final String IPHONE_CSS = "iphone.css";
    public static final String IPAD_CSS = "ipad.css";
    public static final String BBERRY_CSS = "bberry.css";
    public static final String VIEW_TYPE = "view";
    public static final String VIEW_TYPE_SMALL = "small";
    public static final String VIEW_TYPE_LARGE = "large";
    public static final String RESOURCE_URL_ERROR = "RES_NOT_FOUND";
    public static final String MOBILE_DEVICE_TYPE_KEY = "mobile_device_type";

    protected void startElement(ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("style", component);
        writer.writeAttribute("type", (Object)"text/css", "type");
    }

    public void encodeEnd(FacesContext context, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map contextMap = context.getAttributes();
        Map attributes = uiComponent.getAttributes();
        DeviceStyleSheet stylesheet = (DeviceStyleSheet)uiComponent;
        String name = (String)uiComponent.getAttributes().get("name");
        String view = (String)uiComponent.getAttributes().get(VIEW_TYPE);
        if (name == null || EMPTY_STRING.equals(name)) {
            name = CSSUtils.deriveTheme(view, JSFUtils.getRequest()).fileName();
        }
        if (name != null) {
            contextMap.put(MOBILE_DEVICE_TYPE_KEY, name);
            String css = name;
            if (context.isProjectStage(ProjectStage.Production)) {
                css = name.concat(CSS_COMPRESSION_POSTFIX);
            }
            css = css.concat(CSS_EXT);
            String library = this.deriveLibrary(attributes);
            Resource resource = context.getApplication().getResourceHandler().createResource(css, library);
            String resourceUrl = RESOURCE_URL_ERROR;
            if (resource != null) {
                resourceUrl = context.getExternalContext().encodeResourceURL(resource.getRequestPath());
            } else if (log.isLoggable(Level.WARNING)) {
                log.warning("Warning could not load resource " + library + "/" + name);
            }
            writer.startElement("link", uiComponent);
            writer.writeAttribute("type", (Object)"text/css", "type");
            writer.writeAttribute("rel", (Object)"stylesheet", "rel");
            PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, stylesheet.getPASS_THOUGH_ATTRIBUTES());
            writer.writeURIAttribute("href", (Object)resourceUrl, "href");
            writer.endElement("link");
            this.encodeScript(writer, name);
        }
    }

    private String deriveLibrary(Map attributes) {
        String library = (String)attributes.get("library");
        if (library == null) {
            library = "org.icefaces.component.skins";
        }
        return library;
    }

    public void encodeScript(ResponseWriter writer, String name) throws IOException {
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)String.format("document.documentElement.className == '' ? document.documentElement.className = '%1$s' : document.documentElement.className = document.documentElement.className+' %1$s';", name), null);
        writer.endElement("script");
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        FacesContext context = FacesContext.getCurrentInstance();
        if (log.isLoggable(Level.FINER)) {
            log.finer("processEvent for component = " + component.getClass().getName());
        }
        context.getViewRoot().addComponentResource(context, component, "head");
    }
}

