/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.tabset;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import org.icefaces.mobi.component.contentpane.ContentPane;
import org.icefaces.mobi.component.tabset.TabSet;
import org.icefaces.mobi.renderkit.BaseLayoutRenderer;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.utils.JSFUtils;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.component.ITabSet;
import org.icemobile.renderkit.TabSetCoreRenderer;

public class TabSetRenderer
extends BaseLayoutRenderer {
    private static Logger logger = Logger.getLogger(TabSetRenderer.class.getName());
    private static final String JS_NAME = "tabset.js";
    private static final String JS_MIN_NAME = "tabset-min.js";
    private static final String JS_LIBRARY = "org.icefaces.component.tabset";

    public void decode(FacesContext context, UIComponent component) {
        block6: {
            TabSet tabset = (TabSet)component;
            String clientId = tabset.getClientId(context);
            Map params = context.getExternalContext().getRequestParameterMap();
            String indexStr = (String)params.get(clientId + "_hidden");
            if (null != indexStr) {
                try {
                    String submittedStr = indexStr;
                    int ind = indexStr.indexOf(",");
                    if (ind > -1) {
                        String[] split = indexStr.split(",");
                        submittedStr = split[0];
                        tabset.setHashVal(String.valueOf(MobiJSFUtils.generateHashCode(indexStr)));
                        int index = Integer.parseInt(submittedStr);
                        TabSet.IdIndex oldIdIndex = tabset.resolveCurrentIdAndIndex();
                        int oldIndex = oldIdIndex.getIndex();
                        if (oldIndex != index) {
                            String oldId = tabset.getSelectedId();
                            String newId = ((UIComponent)component.getChildren().get(index)).getId();
                            tabset.setSelectedId(newId);
                            component.queueEvent((FacesEvent)new ValueChangeEvent(component, (Object)oldId, (Object)newId));
                        }
                    } else {
                        tabset.setHashVal(null);
                    }
                }
                catch (NumberFormatException nfe) {
                    if (!logger.isLoggable(Level.FINER)) break block6;
                    logger.finer("problem decoding tabIndex from client");
                }
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        TabSet tabset = (TabSet)uiComponent;
        String clientId = tabset.getClientId();
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        TabSetCoreRenderer renderer = new TabSetCoreRenderer();
        if (tabset.getSelectedId() == null && tabset.getDefaultId() != null) {
            tabset.setSelectedId(tabset.getDefaultId());
        }
        String orientation2 = tabset.getOrientation();
        boolean top = tabset.setIsTop(orientation2);
        tabset.setParentHeaderFooter();
        renderer.encodeBegin(tabset, writer, false, top);
        if (top) {
            this.encodeTabs(facesContext, uiComponent);
        }
        renderer.writeStartOfTabContents(tabset, writer, clientId);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        JSFUtils.renderChildren(facesContext, uiComponent);
    }

    public void encodeTabs(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        TabSet controller = (TabSet)uiComponent;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = controller.getClientId(facesContext);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_tabs"), "id");
        String baseTabsClass = ITabSet.TABSET_TABS_CLASS.toString();
        if (!controller.isFixedPosition() || !MobiJSFUtils.getClientDescriptor().isSupportsFixedPosition()) {
            baseTabsClass = baseTabsClass + " mobi-tabset-tabs-nonfixed";
        }
        writer.writeAttribute("class", (Object)baseTabsClass, "class");
        int tabsNum = uiComponent.getChildCount();
        if (tabsNum <= 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(" no contentPane children for this component. Please read DOCS");
            }
            writer.endElement("div");
            return;
        }
        TabSet.IdIndex idIndex = controller.resolveCurrentIdAndIndex();
        boolean autoWidth = controller.isAutoWidth();
        int percent = 100 / tabsNum;
        String percentWidth = "width:" + percent + "%;";
        String lastPercentWidth = null;
        lastPercentWidth = percent * tabsNum != 100 ? "width:" + (percent + (100 - percent * tabsNum)) + "%;" : percentWidth;
        writer.startElement("ul", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_dc"), "id");
        for (int i = 0; i < tabsNum; ++i) {
            UIComponent child = (UIComponent)controller.getChildren().get(i);
            if (!(child instanceof ContentPane)) continue;
            ContentPane cp = (ContentPane)child;
            boolean client = cp.isClient();
            writer.startElement("li", uiComponent);
            writer.writeAttribute("id", (Object)(clientId + "tab_" + i), "id");
            StringBuilder sb = new StringBuilder("ice.mobi.tabsetController.showContent('").append(clientId);
            sb.append("', this, ").append("{");
            sb.append("singleSubmit: true, tIndex: ").append(i);
            sb.append(",client: ").append(client);
            sb.append("});");
            writer.writeAttribute("onclick", (Object)sb.toString(), "onclick");
            if (autoWidth) {
                String width = null;
                width = i < tabsNum - 1 ? percentWidth : lastPercentWidth;
                writer.writeAttribute("style", (Object)width, "style");
            }
            String title = cp.getTitle();
            writer.write(title);
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        TabSetCoreRenderer renderer = new TabSetCoreRenderer();
        ITabSet tabSet = (ITabSet)uiComponent;
        this.encodeHidden(facesContext, uiComponent, String.valueOf(tabSet.getIndex()));
        writer.endElement("div");
        boolean parentFooter = tabSet.isParentFooter();
        String orientation2 = tabSet.getOrientation();
        int idIndex = tabSet.getIndex();
        boolean bottom = TabSet.OrientationType.bottom.name().equals(orientation2);
        StringBuilder styleClass = new StringBuilder(TabSet.TABSET_CONTAINER_CLASS);
        if (bottom) {
            this.encodeTabs(facesContext, uiComponent);
        }
        renderer.encodeScript(tabSet, writer, false);
        writer.endElement("div");
    }
}

