/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.thumbnail;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.icefaces.mobi.api.ThumbnailProvider;
import org.icefaces.mobi.component.thumbnail.Thumbnail;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.renderkit.ThumbnailCoreRenderer;

public class ThumbnailRenderer
extends Renderer {
    private static final Logger logger = Logger.getLogger(ThumbnailRenderer.class.toString());

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Thumbnail thumbnail = (Thumbnail)uiComponent;
        String compId = thumbnail.getFor();
        if (compId == null && (facesContext.isProjectStage(ProjectStage.Development) || logger.isLoggable(Level.FINER))) {
            logger.warning("'for' attribute cannot be null");
        }
        UIComponent comp = thumbnail.findComponent(compId);
        String mFor = comp.getId();
        if (null != comp) {
            ThumbnailProvider tp;
            if (comp instanceof ThumbnailProvider && (tp = (ThumbnailProvider)comp).isUseNative()) {
                return;
            }
            mFor = comp.getClientId(facesContext);
            if (MobiJSFUtils.uploadInProgress(comp)) {
                thumbnail.setBaseClass("mobi-thumb-done");
            } else {
                thumbnail.setBaseClass("mobi-thumb");
            }
        } else if (facesContext.isProjectStage(ProjectStage.Development) || logger.isLoggable(Level.FINER)) {
            logger.finer(" Cannot find camera or camcorder component with id=" + compId);
        }
        if (null == thumbnail.getMFor()) {
            thumbnail.setMFor(mFor);
        }
        ThumbnailCoreRenderer renderer = new ThumbnailCoreRenderer();
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        renderer.encode(thumbnail, writer);
    }
}

