/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.timespinner;

import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.icefaces.mobi.component.timespinner.TimeSpinner;
import org.icefaces.mobi.renderkit.BaseInputRenderer;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icefaces.mobi.utils.PassThruAttributeWriter;
import org.icefaces.mobi.utils.Utils;

public class TimeSpinnerRenderer
extends BaseInputRenderer {
    private static Logger logger = Logger.getLogger(TimeSpinnerRenderer.class.getName());
    private static final String JS_NAME = "timespinner.js";
    private static final String JS_MIN_NAME = "timespinner-min.js";
    private static final String JS_LIBRARY = "org.icefaces.component.timespinner";
    public static final String TOUCH_START_EVENT = "ontouchstart";
    public static final String CLICK_EVENT = "onclick";

    public void decode(FacesContext context, UIComponent component) {
        TimeSpinner timeSpinner = (TimeSpinner)component;
        String clientId = timeSpinner.getClientId(context);
        if (timeSpinner.isDisabled()) {
            return;
        }
        String inputField = clientId + "_input";
        String inputValue = (String)context.getExternalContext().getRequestParameterMap().get(inputField);
        if (this.shouldUseNative(timeSpinner)) {
            inputValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
            if (this.isValueBlank(inputValue)) {
                return;
            }
            String twenty4HrString = this.convertToClock(inputValue, 24);
            timeSpinner.setSubmittedValue(twenty4HrString);
        } else {
            if (this.isValueBlank(inputValue)) {
                return;
            }
            timeSpinner.setSubmittedValue(inputValue);
        }
        this.decodeBehaviors(context, (UIComponent)timeSpinner);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TimeSpinner spinner = (TimeSpinner)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = spinner.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)component;
        boolean hasBehaviors = !cbh.getClientBehaviors().isEmpty();
        boolean singleSubmit = spinner.isSingleSubmit();
        String initialValue = TimeSpinnerRenderer.getStringValueToRender(context, component);
        spinner.setTouchEnabled(Utils.isTouchEventEnabled(context));
        if (this.shouldUseNative(spinner)) {
            writer.startElement("input", component);
            writer.writeAttribute("type", (Object)"time", "type");
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("name", (Object)clientId, null);
            if (spinner.getStyle() != null) {
                writer.writeAttribute("style", (Object)spinner.getStyle(), "style");
            }
            boolean disabled = spinner.isDisabled();
            boolean readonly = spinner.isReadonly();
            String defaultPattern = "HH:mm";
            SimpleDateFormat df2 = new SimpleDateFormat(defaultPattern);
            if (this.isValueBlank(initialValue)) {
                Date aDate = new Date();
                writer.writeAttribute("value", (Object)df2.format(aDate), "value");
            } else {
                String clockVal24 = initialValue;
                if (!this.isFormattedDate(initialValue, "HH:mm")) {
                    clockVal24 = this.convertStringInput("EEE MMM dd hh:mm:ss zzz yyyy", defaultPattern, initialValue);
                }
                writer.writeAttribute("value", (Object)clockVal24, "value");
            }
            if (disabled) {
                writer.writeAttribute("disabled", (Object)component, "disabled");
            }
            if (readonly) {
                writer.writeAttribute("readonly", (Object)component, "readonly");
            }
            if (!readonly && !disabled && hasBehaviors) {
                String event = spinner.getDefaultEventName(context);
                String cbhCall = this.buildAjaxRequest(context, cbh, event);
                writer.writeAttribute("onblur", (Object)cbhCall, null);
            } else if (!readonly && !disabled && singleSubmit) {
                writer.writeAttribute("onblur", (Object)"ice.se(event, this);", null);
            }
            writer.endElement("input");
        } else {
            this.writeJavascriptFile(context, component, JS_NAME, JS_MIN_NAME, JS_LIBRARY);
            String value = this.encodeValue(spinner, initialValue);
            this.encodeMarkup(context, component, value, hasBehaviors);
            this.encodeScript(context, component);
        }
    }

    protected void encodeMarkup(FacesContext context, UIComponent uiComponent, String value, boolean hasBehaviors) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TimeSpinner timeEntry = (TimeSpinner)uiComponent;
        String clientId = timeEntry.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        String eventStr = timeEntry.isTouchEnabled() ? TOUCH_START_EVENT : CLICK_EVENT;
        boolean readonly = timeEntry.isReadonly();
        boolean disabled = timeEntry.isDisabled();
        boolean disabledOrReadonly = false;
        if (readonly || disabled) {
            disabledOrReadonly = true;
        }
        writer.startElement("span", uiComponent);
        if (timeEntry.getStyle() != null) {
            writer.writeAttribute("style", (Object)timeEntry.getStyle(), "style");
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("class", (Object)"mobi-time-wrapper", "class");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_input"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_input"), "name");
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, timeEntry.getCommonAttributeNames());
        StringBuilder classNames = new StringBuilder("mobi-input-text").append(" ").append(timeEntry.getStyleClass());
        writer.writeAttribute("class", (Object)classNames.toString(), null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.writeAttribute("type", (Object)"text", "type");
        if (readonly) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.endElement("span");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"", null);
        writer.writeAttribute("class", (Object)"mobi-time-popup-btn", null);
        if (timeEntry.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (!disabledOrReadonly) {
            writer.writeAttribute(CLICK_EVENT, (Object)("mobi.timespinner.toggle('" + clientId + "');"), null);
        }
        writer.endElement("input");
        writer.endElement("span");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_bg"), "id");
        writer.writeAttribute("class", (Object)"mobi-time-bg-inv", "class");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_popup"), "id");
        writer.writeAttribute("class", (Object)"mobi-time-container-inv", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_title"), "id");
        writer.writeAttribute("class", (Object)"mobi-time-title-container", null);
        writer.write(value);
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-container", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-incr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-incr", null);
        writer.writeAttribute("id", (Object)(clientId + "_hrUpBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.hrUp('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_hrInt"), null);
        writer.write(String.valueOf(timeEntry.getHourInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-decr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-decr", null);
        writer.writeAttribute("id", (Object)(clientId + "_hrDnBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.hrDn('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-incr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-incr", null);
        writer.writeAttribute("id", (Object)(clientId + "_mUpBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.mUp('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_mInt"), null);
        writer.write(String.valueOf(timeEntry.getMinuteInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-decr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-decr", null);
        writer.writeAttribute("id", (Object)(clientId + "_mDnBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.mDn('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-incr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-incr", null);
        writer.writeAttribute("id", (Object)(clientId + "_ampmUpBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.ampmToggle('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_ampmInt"), null);
        String ampm = "AM";
        if (timeEntry.getAmpm() > 0) {
            ampm = "PM";
        }
        writer.write(ampm);
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-decr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-decr", null);
        writer.writeAttribute("id", (Object)(clientId + "_ampmBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.ampmToggle('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-submit-container", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button ui-btn-up-c", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Set", null);
        boolean singleSubmit = timeEntry.isSingleSubmit();
        StringBuilder builder = new StringBuilder(255);
        builder.append("mobi.timespinner.select('").append(clientId).append("',{ event: event,");
        builder.append("singleSubmit: ").append(singleSubmit);
        if (hasBehaviors) {
            String behaviors = this.encodeClientBehaviors(context, cbh, "change").toString();
            behaviors = behaviors.replace("\"", "'");
            builder.append(behaviors);
        }
        builder.append("});");
        String jsCall = builder.toString();
        if (!timeEntry.isDisabled() || !timeEntry.isReadonly()) {
            writer.writeAttribute(CLICK_EVENT, (Object)jsCall, null);
        }
        writer.endElement("input");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button ui-btn-up-c", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Cancel", null);
        writer.writeAttribute(CLICK_EVENT, (Object)("mobi.timespinner.close('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TimeSpinner spinner = (TimeSpinner)uiComponent;
        String clientId = spinner.getClientId(context);
        int hourInt = spinner.getHourInt();
        int minuteInt = spinner.getMinuteInt();
        int ampm = spinner.getAmpm();
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_script"), "id");
        writer.writeAttribute("class", (Object)"mobi-hidden", null);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("mobi.timespinner.init('" + clientId + "'," + hourInt + "," + minuteInt + "," + ampm + ",'" + spinner.getPattern() + "');");
        writer.endElement("script");
        writer.endElement("span");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        TimeSpinner spinner = (TimeSpinner)component;
        String submittedValue = String.valueOf(value);
        Converter converter = spinner.getConverter();
        if (converter != null) {
            Object objVal = converter.getAsObject(context, (UIComponent)spinner, submittedValue);
            return objVal;
        }
        try {
            Locale locale = spinner.calculateLocale(context);
            if (!this.shouldUseNative(spinner)) {
                SimpleDateFormat format = new SimpleDateFormat(spinner.getPattern(), locale);
                return this.customConversion(context, spinner, format, submittedValue);
            }
            SimpleDateFormat format = new SimpleDateFormat("HH:mm", locale);
            return this.customConversion(context, spinner, format, submittedValue);
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private Object customConversion(FacesContext context, TimeSpinner spinner, SimpleDateFormat format, String submittedValue) throws ParseException {
        Locale locale = spinner.calculateLocale(context);
        format.setTimeZone(spinner.calculateTimeZone());
        Date nativeValue = format.parse(submittedValue);
        return nativeValue;
    }

    private void setIntValues(TimeSpinner spinner, Date aDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(aDate);
        int hourInt = cal.get(10);
        if (0 == hourInt) {
            hourInt = 12;
        }
        spinner.setHourInt(hourInt);
        spinner.setMinuteInt(cal.get(12));
        spinner.setAmpm(cal.get(9));
    }

    private String convertStringInput(String patternIn, String patternOut, String inString) {
        SimpleDateFormat df1 = new SimpleDateFormat(patternIn);
        SimpleDateFormat df2 = new SimpleDateFormat(patternOut);
        String returnString = inString;
        try {
            Date aDate = df1.parse(inString);
            returnString = df2.format(aDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnString;
    }

    private String encodeValue(TimeSpinner spinner, String initialValue) {
        String value = "";
        Date aDate = new Date();
        SimpleDateFormat df2 = new SimpleDateFormat(spinner.getPattern());
        if (!this.isValueBlank(initialValue)) {
            try {
                if (this.isFormattedDate(initialValue, spinner.getPattern())) {
                    value = initialValue;
                    aDate = df2.parse(value);
                } else if (this.isFormattedDate(initialValue, "EEE MMM dd hh:mm:ss zzz yyyy")) {
                    value = this.convertStringInput("EEE MMM dd hh:mm:ss zzz yyyy", spinner.getPattern(), initialValue);
                    aDate = df2.parse(value);
                }
            }
            catch (Exception e) {
                throw new ConverterException();
            }
        }
        this.setIntValues(spinner, aDate);
        return value;
    }

    private boolean isFormattedDate(String inStr, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(inStr, new ParsePosition(0)) != null;
    }

    private String convertToClock(String inputVal, int hours) {
        if (!this.isValueEmpty(inputVal)) {
            String delim = ":";
            String[] tmp = inputVal.split(delim);
            String hr = tmp[0];
            String min = tmp[1];
            if (min.length() == 1) {
                min = min + "0";
            }
            String retVal = null;
            try {
                int hour = Integer.parseInt(hr);
                int minute = Integer.parseInt(min);
                retVal = hours == 12 ? (hour < 13 && minute <= 59 ? hr + ":" + min + " AM" : String.valueOf(hour - 12) + ":" + min + " PM") : hr + ":" + min;
            }
            catch (NumberFormatException nfe) {
                logger.info("not able to convert iOS5 input to " + hours + "hour clock");
            }
            return retVal;
        }
        return inputVal;
    }

    private boolean shouldUseNative(TimeSpinner component) {
        return component.isUseNative() && MobiJSFUtils.getClientDescriptor().isHasNativeDatePicker();
    }
}

