/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icemobile.component.IAccordion;
import org.icemobile.component.IMobiComponent;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IRenderer;
import org.icemobile.renderkit.IResponseWriter;
import org.icemobile.util.Utils;

public class AccordionCoreRenderer
extends BaseCoreRenderer
implements IRenderer {
    private static final Logger logger = Logger.getLogger(AccordionCoreRenderer.class.toString());

    public void encodeBegin(IMobiComponent component, IResponseWriter writer, boolean isJSP) throws IOException {
        IAccordion accordion = (IAccordion)component;
        String clientId = accordion.getClientId();
        if (!accordion.isScriptLoaded() && !isJSP) {
            super.writeExternalScript(component, writer, accordion.getJavascriptFileRequestPath());
            accordion.setScriptLoaded();
        }
        writer.startElement("div", accordion);
        writer.writeAttribute("id", clientId);
        writer.startElement("div", accordion);
        writer.writeAttribute("id", clientId + "_acc");
        StringBuilder styleClass = new StringBuilder("mobi-accordion");
        String userDefinedClass = accordion.getStyleClass();
        if (userDefinedClass != null && userDefinedClass.length() > 0) {
            styleClass.append(" ").append(userDefinedClass);
        }
        writer.writeAttribute("class", styleClass.toString());
        writer.writeAttribute("style", accordion.getStyle());
    }

    public void encodeEnd(IMobiComponent component, IResponseWriter writer, boolean isJSP) throws IOException {
        String fixedHeight;
        IAccordion accordion = (IAccordion)component;
        String clientId = accordion.getClientId();
        String openedPaneId = accordion.getOpenedPaneClientId();
        writer.endElement("div");
        writer.startElement("div", accordion);
        writer.writeAttribute("class", "mobi-hidden");
        writer.writeAttribute("id", clientId + "_hid");
        if (null != openedPaneId) {
            super.writeHiddenInput(writer, accordion, openedPaneId);
        } else {
            super.writeHiddenInput(writer, accordion);
        }
        writer.startElement("span", accordion);
        writer.writeAttribute("id", clientId + "_script");
        writer.startElement("script", null);
        writer.writeAttribute("text", "text/javascript");
        StringBuilder jsCall = new StringBuilder("ice.mobi.accordionController.initClient('");
        jsCall.append(clientId).append("', ");
        jsCall.append("{singleSubmit: true");
        if (null != openedPaneId) {
            jsCall.append(", opened: '").append(openedPaneId).append("'");
        }
        boolean autoheight = accordion.isAutoHeight();
        int hashcode = Utils.generateHashCode(openedPaneId);
        if (null != accordion.getHashVal()) {
            hashcode = Utils.generateHashCode(accordion.getHashVal());
        }
        jsCall.append(", hash: ").append(hashcode);
        jsCall.append(", autoHeight: ").append(autoheight);
        if (accordion.isDisabled()) {
            jsCall.append(", disabled: ").append(accordion.isDisabled());
        }
        if ((fixedHeight = accordion.getHeight()) != null && !autoheight && fixedHeight.length() > 0) {
            int fixedHtVal;
            block10: {
                fixedHtVal = -1;
                StringBuffer numbers = new StringBuffer();
                for (char c : fixedHeight.toCharArray()) {
                    if (!Character.isDigit(c)) continue;
                    numbers.append(c);
                }
                try {
                    fixedHtVal = Integer.valueOf(numbers.toString());
                }
                catch (NumberFormatException nfe) {
                    if (!logger.isLoggable(Level.WARNING)) break block10;
                    logger.warning(" could not parse int value of fixedHeight=" + fixedHeight);
                }
            }
            jsCall.append(", fixedHeight: '").append(fixedHeight).append("'");
            if (fixedHtVal > 30) {
                jsCall.append(", fHtVal: ").append(fixedHtVal);
            }
        }
        jsCall.append("});");
        writer.writeText("setTimeout(function () {" + jsCall.toString() + "}, 200);");
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("div");
    }
}

