/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icemobile.component.IAccordion;
import org.icemobile.component.IContentPane;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.ContentPaneCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;
import org.icemobile.util.ClientDescriptor;
import org.icemobile.util.Utils;

public class AccordionPaneCoreRenderer
extends BaseCoreRenderer {
    private static final Logger logger = Logger.getLogger(ContentPaneCoreRenderer.class.toString());

    public void encodeBegin(IContentPane pane, IResponseWriter writer, boolean isJsp, boolean selected) throws IOException {
        IAccordion accordion = pane.getAccordionParent();
        this.encodeAccordionHandle(accordion, pane, writer, isJsp, selected);
    }

    public void encodeEnd(IContentPane component, IResponseWriter writer, boolean isJsp) throws IOException {
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeAccordionHandle(IAccordion accordion, IContentPane pane, IResponseWriter writer, boolean isJsp, boolean selected) throws IOException {
        String userDefinedClass;
        String accordionId = accordion.getClientId();
        String clientId = pane.getClientId();
        boolean client = pane.isClient();
        boolean autoheight = accordion.isAutoHeight();
        String myId = pane.getId();
        String handleClass = "handle ui-bar-b";
        String pointerClass = "pointer";
        writer.startElement("div", pane);
        writer.writeAttribute("id", clientId + "_sect");
        StringBuilder styleClass = new StringBuilder("closed");
        if (!isJsp && selected) {
            styleClass = new StringBuilder("open");
        }
        if ((userDefinedClass = pane.getStyleClass()) != null && userDefinedClass.length() > 0) {
            handleClass = handleClass + " " + userDefinedClass;
            pointerClass = pointerClass + " " + userDefinedClass;
        }
        writer.writeAttribute("class", styleClass);
        writer.writeAttribute("style", pane.getStyle());
        writer.startElement("div", pane);
        writer.writeAttribute("id", clientId + "_hndl");
        writer.writeAttribute("class", handleClass);
        StringBuilder args = new StringBuilder("ice.mobi.accordionController.toggleClient('");
        args.append(accordionId).append("', this, '").append(client).append("'");
        ClientDescriptor cd = accordion.getClient();
        if (Utils.isTransformerHack(cd)) {
            args.append(", 'true'");
        }
        args.append(");");
        writer.writeAttribute("onclick", args.toString());
        writer.startElement("span", pane);
        writer.writeAttribute("class", pointerClass);
        writer.endElement("span");
        String title = pane.getTitle();
        writer.writeText(title);
        writer.endElement("div");
        writer.startElement("div", pane);
        writer.writeAttribute("id", clientId + "wrp");
        String htString = accordion.getHeight();
        boolean scrollablePaneContent = false;
        StringBuilder style = new StringBuilder(256);
        if (!autoheight && null != htString && !htString.equals("") && scrollablePaneContent) {
            style.append("height: ").append(htString).append("; overflow-y: auto;");
            writer.writeAttribute("style", style.toString());
        }
        writer.startElement("div", pane);
        writer.writeAttribute("id", clientId);
    }
}

