/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icemobile.component.IButton;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;
import org.icemobile.util.ClientDescriptor;

public class ButtonCoreRenderer
extends BaseCoreRenderer {
    private static final Logger logger = Logger.getLogger(ButtonCoreRenderer.class.toString());

    public void encodeEnd(IButton component, IResponseWriter writer) throws IOException {
        String type;
        String styleClass;
        String style;
        IButton button = component;
        ClientDescriptor client = button.getClient();
        String clientId = button.getClientId();
        StringBuilder baseClass = new StringBuilder("mobi-button ui-btn-up-c");
        String buttonType = button.getButtonType();
        if (button.isSelectedButton().booleanValue() || button.isSelected()) {
            baseClass.append(" mobi-button-selected ui-btn-active");
        }
        if (button.isDisabled()) {
            baseClass.append(" ").append(" mobi-button-dis");
        }
        if ((style = button.getStyle()) != null && (style = style.trim()).length() == 0) {
            style = null;
        }
        if (buttonType != null && !"".equals(buttonType)) {
            if ("unimportant".equals(buttonType)) {
                baseClass.append(" mobi-button-unimportant");
            } else if ("back".equals(buttonType)) {
                baseClass.append(" mobi-button-back");
            } else if ("attention".equals(buttonType)) {
                baseClass.append(" mobi-button-attention");
            } else if ("important".equals(buttonType)) {
                baseClass.append(" mobi-button-important");
            } else if (!"default".equalsIgnoreCase(buttonType) && logger.isLoggable(Level.WARNING)) {
                logger.warning("unsupported button type: '" + buttonType + "' for " + clientId);
            }
        }
        if ((styleClass = button.getStyleClass()) != null) {
            baseClass.append(" ").append(styleClass);
        }
        if ((type = button.getType()) == null) {
            type = "button";
        }
        if ("back".equals(buttonType) && client.isIOS()) {
            writer.startElement("div", button);
            writer.writeAttribute("id", clientId + "_ctr");
            writer.writeAttribute("class", baseClass.toString());
            if (style != null) {
                writer.writeAttribute("style", style);
            }
            writer.startElement("span", button);
            writer.endElement("span");
        }
        writer.startElement("input", component);
        writer.writeAttribute("id", clientId);
        writer.writeAttribute("value", button.getValue());
        if (!"back".equals(buttonType) || !client.isIOS()) {
            writer.writeAttribute("class", baseClass.toString());
            if (style != null) {
                writer.writeAttribute("style", style);
            }
        }
        writer.writeAttribute("type", type);
        String name = clientId;
        if (button.getName() != null) {
            name = button.getName();
        }
        writer.writeAttribute("name", name);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", "disabled");
            writer.endElement("input");
            if ("back".equals(button.getButtonType()) && client.isIOS()) {
                writer.endElement("div");
            }
            return;
        }
        if (button.getOpenContentPane() != null) {
            writer.writeAttribute("onclick", button.getJsCall().toString());
            writer.endElement("input");
        } else if (!button.getType().trim().toLowerCase().equals("submit")) {
            StringBuilder sb = new StringBuilder("ice.mobi.button.select('");
            sb.append(clientId).append("', event, {");
            sb.append("singleSubmit: ").append(button.isSingleSubmit());
            if (null != button.getParams() && button.getParams().trim() != "") {
                sb.append(", params: ").append(button.getParams());
            }
            if (null != button.getGroupId()) {
                sb.append(", groupId: '").append(button.getGroupId()).append("'");
            }
            if (null != button.getPanelConfirmation()) {
                sb.append(", pcId: '").append(button.getPanelConfirmationId()).append("'");
            }
            if (null != button.getSubmitNotification()) {
                sb.append(", snId: '").append(button.getSubmitNotificationId()).append("'");
            }
            if (button.isParentDisabled()) {
                sb.append(", pDisabled: ").append(button.isParentDisabled());
            }
            if (null != button.getBehaviors()) {
                sb.append(button.getBehaviors());
            }
            sb.append("});");
            writer.writeAttribute("onclick", sb.toString());
        }
        writer.endElement("input");
        if ("back".equals(button.getButtonType()) && client.isIOS()) {
            writer.startElement("b", button);
            writer.writeAttribute("class", "mobi-button-placeholder");
            Object oVal2 = button.getValue();
            if (null != oVal2) {
                String value = oVal2.toString();
                writer.writeText(value);
            }
            writer.endElement("b");
            writer.endElement("div");
        }
    }
}

