/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icemobile.component.IDevice;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;
import org.icemobile.util.ClientDescriptor;

public class DeviceCoreRenderer
extends BaseCoreRenderer {
    private static final Logger logger = Logger.getLogger(DeviceCoreRenderer.class.toString());

    public void encode(IDevice component, IResponseWriter writer, boolean isJSP) throws IOException {
        boolean isEnhanced;
        String clientId = component.getClientId();
        StringBuilder baseClass = new StringBuilder("mobi-button ui-btn-up-c");
        String comptype = component.getComponentType();
        ClientDescriptor cd = component.getClient();
        boolean bl = isEnhanced = cd.isICEmobileContainer() || cd.isSXRegistered();
        if (cd.isICEmobileContainer() || cd.isSXRegistered() && !isJSP) {
            writer.startElement("button", component);
            writer.writeAttribute("id", clientId);
            writer.writeAttribute("name", clientId + "_button");
            writer.writeAttribute("type", "button");
            this.writeStandardAttributes(writer, component, baseClass.toString(), " mobi-button-dis");
            String script = component.getScript(clientId, cd.isSXRegistered());
            writer.writeAttribute("onclick", script);
            writer.writeText(component.getButtonLabel());
            writer.endElement("button");
        } else if (isJSP && cd.isSXRegistered()) {
            writer.startElement("button", component);
            writer.writeAttribute("id", clientId);
            writer.writeAttribute("name", clientId + "_button");
            writer.writeAttribute("type", "button");
            writer.writeAttribute("data-id", component.getClientId());
            if (null != component.getParams()) {
                writer.writeAttribute("data-params", component.getParams());
            }
            if (null != component.getSessionId()) {
                writer.writeAttribute("data-jsessionid", component.getSessionId());
            }
            this.writeStandardAttributes(writer, component, baseClass.toString(), " mobi-button-dis");
            writer.writeAttribute("data-command", component.getComponentType());
            writer.writeAttribute("onclick", "ice.mobilesx(this)");
            writer.writeText(component.getButtonLabel());
            writer.endElement("button");
        } else {
            writer.startElement("input", component);
            if (comptype.equals("scan") || comptype.equals("aug")) {
                writer.writeAttribute("type", "text");
                writer.writeAttribute("class", "mobi-input-text ui-input-text");
            } else {
                writer.writeAttribute("type", "file");
            }
            writer.writeAttribute("id", clientId);
            writer.writeAttribute("name", clientId);
            this.writeStandardAttributes(writer, component, "", "");
            if (comptype.equals("camera")) {
                writer.writeAttribute("accept", "image/*");
            }
            if (!cd.isDesktopBrowser()) {
                if (comptype.equals("camcorder")) {
                    writer.writeAttribute("accept", "video/*");
                }
                if (comptype.equals("microphone")) {
                    writer.writeAttribute("accept", "audio/*");
                }
            }
            writer.endElement("input");
        }
    }
}

