/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import org.icemobile.component.IGetEnhanced;
import org.icemobile.renderkit.IResponseWriter;
import org.icemobile.util.ClientDescriptor;

public class GetEnhancedCoreRenderer {
    public void encode(IGetEnhanced component, IResponseWriter writer) throws IOException {
        if (component.isIOSSmartBannerRendered()) {
            return;
        }
        String clientId = component.getClientId();
        ClientDescriptor client = component.getClient();
        if (!client.isICEmobileContainer() && !client.isSXRegistered()) {
            boolean disabled;
            writer.startElement("div", component);
            writer.writeAttribute("id", clientId);
            String styleClass = component.getStyleClass();
            styleClass = styleClass != null ? "mobi-getenhanced " + styleClass : "mobi-getenhanced";
            writer.writeAttribute("class", styleClass);
            String style = component.getStyle();
            if (style != null) {
                writer.writeAttribute("style", style);
            }
            if (disabled = component.isDisabled()) {
                writer.writeAttribute("disabled", "disabled");
            }
            String msg = "ICEmobile container was not detected. ";
            String link = null;
            if (client.isAndroidOS()) {
                link = "https://play.google.com/store/apps/developer?id=ICEsoft+Technologies";
                String androidMsg = component.getAndroidMsg();
                if (androidMsg != null) {
                    msg = androidMsg;
                }
            } else if (client.isIOS()) {
                link = "http://itunes.apple.com/us/app/icemobile-sx/id485908934?mt=8";
                String iosMsg = component.getIosMsg();
                if (iosMsg != null) {
                    msg = iosMsg;
                }
            } else if (client.isBlackBerryOS()) {
                link = "http://appworld.blackberry.com/webstore/content/59555/";
                String blackBerryMsg = component.getBlackberryMsg();
                if (blackBerryMsg != null) {
                    msg = blackBerryMsg;
                }
            } else {
                link = "http://www.icesoft.org/projects/ICEmobile/containers.jsf";
            }
            writer.writeText(msg);
            if (client.isIOS() || client.isAndroidOS() || client.isBlackBerry10OS()) {
                writer.startElement("a", null);
                writer.writeAttribute("href", "#");
                writer.writeAttribute("class", "mobi-button ui-btn-up-c mobi-button-important");
                writer.writeAttribute("onclick", component.getICEmobileRegisterSXScript());
                writer.writeText("Enable ICEmobile SX");
                writer.endElement("a");
            }
            if (component.isIncludeLink()) {
                writer.startElement("a");
                writer.writeAttribute("href", link);
                writer.writeAttribute("class", "mobi-button ui-btn-up-c mobi-button-important");
                writer.writeText("Download ICEmobile");
                writer.endElement("a");
            }
            writer.endElement("div");
        }
    }
}

