/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icemobile.component.IPagePanel;
import org.icemobile.renderkit.IResponseWriter;

public class PagePanelCoreRenderer {
    private static Logger logger = Logger.getLogger(PagePanelCoreRenderer.class.getName());
    public static final String HEADER_CLASS = "mobi-pagePanel-header ui-header";
    public static final String FOOTER_CLASS = "mobi-pagePanel-footer ui-footer";
    public static final String BODY_CLASS = "mobi-pagePanel-body ui-body-c";
    public static final String CTR_CLASS = "mobi-pagePanel-ctr";
    public static final String BODY_NO_HEADER_CLASS = "mobi-pagePanel-body-noheader";
    public static final String BODY_NO_FOOTER_CLASS = "mobi-pagePanel-body-nofooter";

    public void encode(IPagePanel component, IResponseWriter writer) throws IOException {
        String clientId = component.getClientId();
        Object header = component.getHeader();
        Object body = component.getBody();
        Object footer = component.getFooter();
        writer.startElement("div", component);
        writer.writeAttribute("style", component.getStyle());
        writer.writeAttribute("class", component.getStyleClass());
        if (clientId != null) {
            writer.writeAttribute("id", clientId + "_pgPnl");
        }
        if (header == null && footer == null && body == null) {
            logger.warning("PagePanel header, body and footer were not defined, no content will be rendered by this component.");
        }
        if (header != null) {
            writer.startElement("div", component);
            writer.writeAttribute("class", HEADER_CLASS + (component.getClient().isSupportsFixedPosition() ? " ui-header-fixed" : ""));
            if (clientId != null) {
                writer.writeAttribute("id", clientId + "_pgPnlHdr");
            }
            writer.startElement("div", component);
            writer.writeAttribute("class", CTR_CLASS);
            writer.endElement("div");
            writer.endElement("div");
        }
        if (body != null) {
            StringBuilder bodyStyleClass = new StringBuilder(BODY_CLASS);
            if (header == null) {
                bodyStyleClass.append(" ").append(BODY_NO_HEADER_CLASS);
            }
            if (footer == null) {
                bodyStyleClass.append(" ").append(BODY_NO_FOOTER_CLASS);
            }
            writer.startElement("div", component);
            writer.writeAttribute("class", bodyStyleClass);
            if (clientId != null) {
                writer.writeAttribute("id", clientId + "_pgPnlBdy");
            }
            writer.endElement("div");
        }
        if (footer != null) {
            writer.startElement("div", component);
            writer.writeAttribute("class", FOOTER_CLASS + (component.getClient().isSupportsFixedPosition() ? " ui-footer-fixed " : ""));
            if (clientId != null) {
                writer.writeAttribute("id", clientId + "_pgPnlFtr");
            }
            writer.startElement("div", component);
            writer.writeAttribute("class", CTR_CLASS);
            writer.endElement("div");
            writer.endElement("div");
        }
        writer.endElement("div");
    }
}

