/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icemobile.component.IFragment;
import org.icemobile.component.ISplitPane;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;

public class SplitPaneCoreRenderer
extends BaseCoreRenderer {
    public static final String SPLITPANE_BASE_CSS = "mobi-splitpane";
    public static final String SPLITPANE_NONSCROLL_CSS = "mobi-splitpane-nonScrollable";
    public static final String SPLITPANE_SCROLLABLE_CSS = "mobi-splitpane-scrollable";
    public static final String SPLITPANE_DIVIDER_CSS = "mobi-splitpane-divider";
    private static final Logger logger = Logger.getLogger(SplitPaneCoreRenderer.class.toString());
    private static final int DEFAULT_COLUMN_WIDTH = 25;
    private String leftwidth;
    private String rightwidth;
    private StringBuilder paneClass = new StringBuilder("mobi-splitpane-scrollable");
    private StringBuilder spltClass = new StringBuilder("mobi-splitpane-divider");

    public void encodeBegin(ISplitPane component, IResponseWriter writer) throws IOException {
        int leftWidth;
        if (!component.isScrollable()) {
            this.paneClass = new StringBuilder(SPLITPANE_NONSCROLL_CSS);
        }
        if ((leftWidth = component.getColumnDivider()) < 1 || leftWidth > 99) {
            leftWidth = 25;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" input of ColumnDivider is invalid, setting it to default value");
            }
        }
        int rightWidth = 100 - leftWidth;
        this.setLeftwidth(String.valueOf(leftWidth) + "%");
        this.setRightwidth(String.valueOf(rightWidth) + "%");
        String userClass = component.getStyleClass();
        if (userClass != null) {
            this.paneClass.append(" ").append(userClass);
            this.spltClass.append(" ").append(userClass).toString();
        }
        writer.startElement("div", component);
        writer.writeAttribute("id", component.getClientId());
        this.writeStandardLayoutAttributes(writer, component, SPLITPANE_BASE_CSS);
    }

    public void encodePane(IFragment component, IResponseWriter writer, String style) throws IOException {
        writer.startElement("div", component);
        writer.writeAttribute("id", component.getClientId());
        writer.writeAttribute("class", this.getPaneClass());
        writer.writeAttribute("style", style);
    }

    public void encodePaneEnd(IResponseWriter writer) throws IOException {
        writer.endElement("div");
    }

    public void encodePane(ISplitPane component, IResponseWriter writer, String side) throws IOException {
        writer.startElement("div", component);
        String width = this.getLeftwidth();
        if (side.equals("right")) {
            width = this.getRightwidth();
        }
        writer.writeAttribute("style", width);
        writer.writeAttribute("class", this.getPaneClass());
        writer.writeAttribute("id", component.getClientId() + "_" + side);
    }

    public void encodeColumnDivider(ISplitPane component, IResponseWriter writer) throws IOException {
    }

    public void encodeEnd(ISplitPane pane, IResponseWriter writer) throws IOException {
        writer.startElement("span", pane);
        writer.writeAttribute("class", "mobi-hidden");
        writer.startElement("script", pane);
        writer.writeAttribute("type", "text/javascript");
        StringBuilder sb = new StringBuilder("ice.mobi.splitpane.initClient('").append(pane.getClientId()).append("'");
        sb.append(",{ scrollable: '").append(pane.isScrollable()).append("'");
        int width = pane.getColumnDivider();
        if (width < 1 || width > 99) {
            width = 25;
        }
        sb.append(",width: '").append(width).append("'");
        sb.append("});");
        writer.writeText(sb.toString());
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("div");
    }

    public String getLeftwidth() {
        if (this.leftwidth != null) {
            return "width:" + this.leftwidth + ";";
        }
        return "width: 30%;";
    }

    public void setLeftwidth(String leftwidth) {
        this.leftwidth = leftwidth;
    }

    public String getRightwidth() {
        if (this.rightwidth != null) {
            return "width:" + this.rightwidth + ";";
        }
        return "width: 70%;";
    }

    public void setRightwidth(String rightwidth) {
        this.rightwidth = rightwidth;
    }

    public String getPaneClass() {
        return this.paneClass.toString();
    }

    public void setPaneClass(StringBuilder paneClass) {
        this.paneClass = paneClass;
    }

    public String getSpltClass() {
        return this.spltClass.toString();
    }

    public void setSpltClass(StringBuilder spltClass) {
        this.spltClass = spltClass;
    }
}

