/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icemobile.component.IMobiComponent;
import org.icemobile.component.ITabPane;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;

public class TabPaneCoreRenderer
extends BaseCoreRenderer {
    private static final Logger logger = Logger.getLogger(TabPaneCoreRenderer.class.toString());
    public static String LI_TAG = "<li ";
    public static String LI_TAG_END = "</li>";
    public static String START_TAG = "<";
    public static String CLOSE_TAG = "/>";
    public static String SPAN_TAG = "<span ";
    public static String SPAN_END_TAG = "</span>";
    public static String RIGHT_ANCHOR_TAG = ">";
    public static String STRING_QUOTE = "\"";
    private String mActiveContentClass = "mobi-tabpage";
    private String mPassiveContentClass = "mobi-tabpage-hidden";

    public StringBuilder encodeBegin(IMobiComponent component, IResponseWriter writer, boolean isJSP, String parentId) throws IOException {
        ITabPane tabPane = (ITabPane)component;
        StringBuilder sb = new StringBuilder(LI_TAG);
        int index = tabPane.getIndex();
        sb.append("id").append("=").append(STRING_QUOTE).append(parentId).append("tab_");
        sb.append(tabPane.getIndex()).append(STRING_QUOTE);
        sb.append("onclick").append("=").append(STRING_QUOTE).append((CharSequence)this.getScript(tabPane, parentId, index)).append(STRING_QUOTE);
        sb.append(RIGHT_ANCHOR_TAG);
        sb.append(tabPane.getTitle());
        sb.append(LI_TAG_END);
        return sb;
    }

    public void encodeBegin(IMobiComponent component, IResponseWriter writer, String parentId) throws IOException {
        ITabPane tabPane = (ITabPane)component;
        int index = tabPane.getIndex();
        writer.startElement("li", component);
        writer.writeAttribute("id", parentId + "tab_" + index);
        writer.writeAttribute("onclick", this.getScript(tabPane, parentId, index));
        writer.writeText(tabPane.getTitle());
        writer.endElement("li");
    }

    public StringBuilder getScript(ITabPane tabPane, String parentId, int index) {
        StringBuilder script = new StringBuilder("ice.mobi.tabsetController.showContent('");
        script.append(parentId).append("', this, ").append("{");
        script.append("singleSubmit: true, tIndex: ").append(index);
        script.append(",client: ").append(tabPane.isClient());
        script.append("});");
        return script;
    }

    public void encodeContentWrapperBegin(IMobiComponent component, IResponseWriter writer, String selectedId, String clientId) throws IOException {
        writer.startElement("div", component);
        writer.writeAttribute("id", clientId + "_wrapper");
        String myclass = this.mPassiveContentClass;
        if (selectedId.equals(clientId)) {
            myclass = this.mActiveContentClass;
        }
        writer.writeAttribute("class", myclass);
        writer.startElement("div");
        writer.writeAttribute("id", clientId);
    }

    public void encodeContentEnd(IMobiComponent component, IResponseWriter writer) throws IOException {
        writer.endElement("div");
        writer.endElement("div");
    }
}

