/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.icemobile.util.ClientDescriptor;

public class Utils {
    private static Logger logger = Logger.getLogger(Utils.class.getName());
    public static final Map<String, String> FILE_EXT_BY_CONTENT_TYPE = new HashMap<String, String>(){
        private static final long serialVersionUID = -8905491307471581114L;
        {
            this.put("video/mp4", ".mp4");
            this.put("audio/mp4", ".mp4");
            this.put("video/mpeg", ".mpg");
            this.put("video/mov", ".mov");
            this.put("video/3gpp", ".3gp");
            this.put("audio/wav", ".wav");
            this.put("audio/x-wav", ".wav");
            this.put("audio/x-m4a", ".m4a");
            this.put("audio/mpeg", ".mp3");
            this.put("audio/amr", ".amr");
            this.put("image/jpeg", ".jpg");
            this.put("image/jpg", ".jpg");
            this.put("image/png", ".png");
        }
    };
    private static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final Map<String, String> CONTENT_TYPE_BY_FILE_EXT = new HashMap<String, String>(){
        {
            this.put(".mp4", "video/mp4");
            this.put(".mp4", "audio/mp4");
            this.put(".mpg", "video/mpeg");
            this.put(".mov", "video/mov");
            this.put(".3gp", "video/3gpp");
            this.put(".wav", "audio/wav");
            this.put(".wav", "audio/x-wav");
            this.put(".m4a", "audio/x-m4a");
            this.put(".mp3", "audio/mpeg");
            this.put(".amr", "audio/amr");
            this.put(".jpg", "image/jpeg");
            this.put(".jpg", "image/jpg");
            this.put(".png", "image/png");
        }
    };

    public static Cookie getCookie(String name, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equalsIgnoreCase(name)) continue;
                return cookies[i];
            }
        }
        return null;
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        if (in != null && out != null) {
            byte[] buf = new byte[1000];
            int l = 1;
            while (l > 0) {
                l = in.read(buf);
                if (l <= 0) continue;
                out.write(buf, 0, l);
            }
        }
    }

    public static int copyStream(InputStream in, OutputStream out, int start, int end) throws IOException {
        long skipped = in.skip(start);
        if ((long)start != skipped) {
            throw new IOException("copyStream failed range start " + start);
        }
        byte[] buf = new byte[1000];
        int pos = start - 1;
        int count = 0;
        int l = 1;
        while (l > 0) {
            l = in.read(buf);
            if (l <= 0) continue;
            if ((pos += l) > end) {
                out.write(buf, 0, l -= pos - end);
                count += l;
                break;
            }
            out.write(buf, 0, l);
            count += l;
        }
        return count;
    }

    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }

    public static boolean isTransformerHack(ClientDescriptor client) {
        String ua = client.getUserAgent();
        if (ua != null) {
            ua = ua.toLowerCase();
            return ua.contains("transformer prime");
        }
        return false;
    }

    public static String getBaseURL(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String serverName = httpRequest.getHeader("x-forwarded-host");
        if (null == serverName) {
            serverName = httpRequest.getServerName() + ":" + httpRequest.getServerPort();
        }
        return httpRequest.getScheme() + "://" + serverName + httpRequest.getContextPath() + "/";
    }

    public static String getCloudPushId(HttpServletRequest request) {
        String cloudPushId = null;
        cloudPushId = (String)request.getSession().getAttribute("iceCloudPushId");
        return cloudPushId;
    }

    public static String getAcceptHeader(HttpServletRequest request) {
        String accept = request.getHeader("Accept");
        return accept == null ? accept : accept.toLowerCase();
    }

    public static boolean acceptContains(HttpServletRequest request, String contains) {
        boolean result = false;
        String accept = Utils.getAcceptHeader(request);
        if (accept != null) {
            result = accept.contains(contains);
        }
        return result;
    }

    public static void concatenateStyleClass(StringBuilder sb, String styleClass, boolean disabled, String disabledStr) {
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(styleClass);
        if (disabled) {
            sb.append(' ');
            sb.append(styleClass);
            sb.append(disabledStr);
        }
    }

    public static int generateHashCode(Object value) {
        int hashCode = 0;
        if (value != null) {
            hashCode = value.toString().hashCode();
        }
        return hashCode;
    }

    public static DateFormat getHttpDateFormat() {
        return new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
    }
}

