package org.icepush;

public class ProductInfo {
    /**
     * The company that owns this product.
     */
    public static String COMPANY = "ICEsoft Technologies Inc.";

    /**
     * The name of the product.
     */
    public static String PRODUCT = "ICEpush";

    /**
     * The 3 levels of version identification, e.g. 1.0.0.
     */
    public static String PRIMARY = "3";
    public static String SECONDARY = "0";
    public static String TERTIARY = "1";

    /**
     * The release type of the product (alpha, beta, production).
     */
    public static String RELEASE_TYPE = "";

    /**
     * The build number.  Typically this would be tracked and maintained
     * by the build system (i.e. Ant).
     */
    public static String BUILD_NO = "2";

    /**
     * The revision number retrieved from the repository for this build.
     * This is substitued automatically by subversion.
     */
    public static String REVISION = "28519";

    /**
     * Convenience method to get all the relevant product information.
     *
     * @return
     */
    public String toString() {
        StringBuffer info = new StringBuffer();
        info.append("\n");
        info.append(COMPANY);
        info.append("\n");
        info.append(PRODUCT);
        info.append(" ");
        info.append(PRIMARY);
        info.append(".");
        info.append(SECONDARY);
        info.append(".");
        info.append(TERTIARY);
        if ( (RELEASE_TYPE.length() > 0) &&
        	(!RELEASE_TYPE.equals("x")) &&
        	(!RELEASE_TYPE.equals("${release.type}")) ) { 
	        info.append(".");
	        info.append(RELEASE_TYPE);
        }    
        info.append("\n");
        info.append("Build number: ");
        info.append(BUILD_NO);
        info.append("\n");
        info.append("Revision: ");
        info.append(REVISION);
        info.append("\n");
        return info.toString();
    }

    public static void main(String[] args) {
        ProductInfo app = new ProductInfo();
        System.out.println(app.toString());
    }
}