/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.fonts.ofont.Encoding;
import org.icepdf.core.util.Library;

public class OutlineItem
extends Dictionary {
    private String title;
    private Destination dest;
    private Action action;
    private Reference parent;
    private Reference prev;
    private Reference next;
    private Reference first;
    private Reference last;
    private int count = -1;
    private boolean loadedSubItems = false;
    private Vector<OutlineItem> subItems = new Vector(Math.max(Math.abs(this.getCount()), 16));

    public OutlineItem(Library l, Hashtable h) {
        super(l, h);
    }

    public boolean isEmpty() {
        return this.getTitle() == null && this.getDest() == null && this.getAction() == null;
    }

    public int getSubItemCount() {
        this.ensureSubItemsLoaded();
        if (this.subItems != null) {
            return this.subItems.size();
        }
        return 0;
    }

    public OutlineItem getSubItem(int index) {
        this.ensureSubItemsLoaded();
        return this.subItems.get(index);
    }

    public Action getAction() {
        Object obj;
        if (this.action == null && (obj = this.library.getObject(this.entries, "A")) instanceof Hashtable) {
            this.action = new Action(this.library, (Hashtable)obj);
        }
        return this.action;
    }

    public Reference getFirst() {
        Object attribute;
        if (this.first == null && (attribute = this.entries.get("First")) instanceof Reference) {
            this.first = (Reference)attribute;
        }
        return this.first;
    }

    public Reference getLast() {
        Object attribute;
        if (this.last == null && (attribute = this.entries.get("Last")) instanceof Reference) {
            this.last = (Reference)attribute;
        }
        return this.last;
    }

    public Reference getNext() {
        Object attribute;
        if (this.next == null && (attribute = this.entries.get("Next")) instanceof Reference) {
            this.next = (Reference)attribute;
        }
        return this.next;
    }

    public Reference getPrev() {
        Object attribute;
        if (this.prev == null && (attribute = this.entries.get("Prev")) instanceof Reference) {
            this.prev = (Reference)attribute;
        }
        return this.prev;
    }

    public Reference getParent() {
        Object attribute;
        if (this.parent == null && (attribute = this.entries.get("Parent")) instanceof Reference) {
            this.parent = (Reference)attribute;
        }
        return this.parent;
    }

    private int getCount() {
        if (this.count < 0) {
            this.count = this.library.getInt(this.entries, "Count");
        }
        return this.count;
    }

    public String getTitle() {
        Object obj;
        if (this.title == null && (obj = this.library.getObject(this.entries, "Title")) instanceof StringObject) {
            StringObject outlineText = (StringObject)obj;
            String titleText = outlineText.getDecryptedLiteralString(this.library.securityManager);
            if (titleText != null && titleText.length() >= 2 && titleText.charAt(0) == '\u00fe' && titleText.charAt(1) == '\u00ff') {
                int i;
                StringBuilder sb1 = new StringBuilder();
                String hexTmp = "";
                for (i = 0; i < titleText.length(); ++i) {
                    char c = titleText.charAt(i);
                    if (c == '\t' || c == '\r' || c == '\n') continue;
                    hexTmp = hexTmp + titleText.charAt(i);
                }
                for (i = 2; i < hexTmp.length(); i += 2) {
                    try {
                        int b1 = hexTmp.charAt(i) & 0xFF;
                        int b2 = hexTmp.charAt(i + 1) & 0xFF;
                        sb1.append((char)(b1 * 256 + b2));
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.title = sb1.toString();
            } else if (titleText != null) {
                StringBuilder sb = new StringBuilder();
                Encoding enc = Encoding.getPDFDoc();
                for (int i = 0; i < titleText.length(); ++i) {
                    sb.append(enc.get(titleText.charAt(i)));
                }
                this.title = sb.toString();
            }
        }
        return this.title;
    }

    public Destination getDest() {
        Object obj;
        if (this.dest == null && (obj = this.library.getObject(this.entries, "Dest")) != null) {
            this.dest = new Destination(this.library, obj);
        }
        return this.dest;
    }

    private void ensureSubItemsLoaded() {
        if (this.loadedSubItems) {
            return;
        }
        this.loadedSubItems = true;
        if (this.getFirst() != null) {
            Hashtable dictionary;
            Reference nextReference = this.getFirst();
            while (nextReference != null && (dictionary = (Hashtable)this.library.getObject(nextReference)) != null) {
                OutlineItem outLineItem = new OutlineItem(this.library, dictionary);
                this.subItems.add(outLineItem);
                Reference oldNextReference = nextReference;
                if (!oldNextReference.equals(nextReference = outLineItem.getNext())) continue;
                break;
            }
        }
    }
}

