/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.icepdf.core.util.CacheManager;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

public class ImageCache {
    private static final Logger logger = Logger.getLogger(ImageCache.class.toString());
    private File tempFile = null;
    private long length = 0L;
    private boolean isCached = false;
    private CacheManager cacheManager = null;
    private boolean isScaled = false;
    private BufferedImage imageStore;
    private static boolean isCachingEnabled = Defs.sysPropertyBoolean("org.icepdf.core.imagecache.enabled", true);
    private static boolean scaleImages = Defs.sysPropertyBoolean("org.icepdf.core.scaleImages", true);

    public ImageCache(Library library) {
        this.cacheManager = library.getCacheManager();
    }

    public void setImage(BufferedImage image) {
        this.setImage(image, this.isCached);
    }

    private void setImage(BufferedImage image, boolean useCaching) {
        try {
            if (useCaching && this.isCached && this.imageStore == image) {
                return;
            }
            if (this.imageStore != null && this.imageStore != image) {
                this.imageStore.flush();
                this.imageStore = null;
            }
            if (useCaching) {
                this.tempFile = File.createTempFile("PDFImageStream" + this.getClass().hashCode(), ".tmp");
                this.cacheManager.addCachedFile(this.tempFile.getAbsolutePath());
                this.tempFile.deleteOnExit();
                ImageIO.write((RenderedImage)image, "png", this.tempFile);
                this.length = this.tempFile.length();
                this.isCached = true;
            } else {
                this.imageStore = image;
                this.isCached = false;
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error creating ImageCache temporary file.", e);
        }
    }

    public BufferedImage readImage() {
        if (this.imageStore != null) {
            return this.imageStore;
        }
        if (this.isCached) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(this.tempFile);
                this.length = this.tempFile.length();
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Error creating ImageCache temporary file ", e);
            }
            return image;
        }
        return null;
    }

    public void dispose(boolean cache, boolean imageRecoverableElsewise) {
        if (this.imageStore != null) {
            if (cache && isCachingEnabled && !this.isCached && !imageRecoverableElsewise) {
                this.setImage(this.imageStore, true);
            }
            if (!cache || this.isCached || imageRecoverableElsewise) {
                this.imageStore = null;
            }
        }
    }

    public void scaleImage(int width, int height) {
        if (scaleImages) {
            this.setImage(ImageCache.scaleBufferedImage(this.readImage(), width, height));
            this.isScaled = true;
        } else {
            this.isScaled = false;
        }
    }

    public void setIsScaled(boolean flag) {
        this.isScaled = flag;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isScaled() {
        return this.isScaled;
    }

    public boolean isCachedSomehow() {
        return this.isCached || this.imageStore != null;
    }

    public static BufferedImage scaleBufferedImage(BufferedImage bim, int width, int height) {
        double imageScale = 1.0;
        if (!(width < 500 && height < 500 || width >= 1000 && height >= 1000)) {
            imageScale = 0.8;
        } else if (!(width < 1000 && height < 1000 || width >= 1500 && height >= 1500)) {
            imageScale = 0.7;
        } else if (!(width < 1500 && height < 1500 || width >= 2000 && height >= 2000)) {
            imageScale = 0.6;
        } else if (!(width < 2000 && height < 2000 || width >= 2500 && height >= 2500)) {
            imageScale = 0.5;
        } else if (!(width < 2500 && height < 2500 || width >= 3000 && height >= 3000)) {
            imageScale = 0.4;
        } else if (width >= 3000 || height >= 3000) {
            imageScale = 0.3;
        }
        if (imageScale < 1.0) {
            AffineTransform tx = new AffineTransform();
            tx.scale(imageScale, imageScale);
            AffineTransformOp op = new AffineTransformOp(tx, 2);
            BufferedImage sbim = op.filter(bim, null);
            bim.flush();
            bim = sbim;
        }
        return bim;
    }
}

