/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.icepdf.core.io.BitStream;
import org.icepdf.core.io.ConservativeSizingByteArrayOutputStream;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.filters.ASCII85Decode;
import org.icepdf.core.pobjects.filters.ASCIIHexDecode;
import org.icepdf.core.pobjects.filters.CCITTFax;
import org.icepdf.core.pobjects.filters.CCITTFaxDecoder;
import org.icepdf.core.pobjects.filters.FlateDecode;
import org.icepdf.core.pobjects.filters.LZWDecode;
import org.icepdf.core.pobjects.filters.RunLengthDecode;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.ICCBased;
import org.icepdf.core.pobjects.graphics.Indexed;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.Separation;
import org.icepdf.core.tag.Tagger;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.ImageCache;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stream
extends Dictionary {
    private static final Logger logger = Logger.getLogger(Stream.class.toString());
    private SeekableInputConstrainedWrapper streamInput;
    private ImageCache image = null;
    private final Object imageLock = new Object();
    private Reference pObjectReference = null;
    private boolean inlineImage;
    private static boolean scaleImages;
    private static int redIndex;
    private static int blueIndex;
    private static final int[] GRAY_1_BIT_INDEX_TO_RGB_REVERSED;
    private static final int[] GRAY_1_BIT_INDEX_TO_RGB;
    private static final int[] GRAY_2_BIT_INDEX_TO_RGB;
    private static final int[] GRAY_4_BIT_INDEX_TO_RGB;
    private static final int JPEG_ENC_UNKNOWN_PROBABLY_YCbCr = 0;
    private static final int JPEG_ENC_RGB = 1;
    private static final int JPEG_ENC_CMYK = 2;
    private static final int JPEG_ENC_YCbCr = 3;
    private static final int JPEG_ENC_YCCK = 4;
    private static final int JPEG_ENC_GRAY = 5;
    private static String[] JPEG_ENC_NAMES;

    public Stream(Library l, Hashtable h, SeekableInputConstrainedWrapper streamInputWrapper) {
        super(l, h);
        this.streamInput = streamInputWrapper;
    }

    @Override
    public void setPObjectReference(Reference reference) {
        this.pObjectReference = reference;
    }

    @Override
    public Reference getPObjectReference() {
        return this.pObjectReference;
    }

    public void setInlineImage(boolean inlineImage) {
        this.inlineImage = inlineImage;
    }

    public boolean isInlineImage() {
        return this.inlineImage;
    }

    boolean isImageSubtype() {
        Object subtype = this.library.getObject(this.entries, "Subtype");
        return subtype != null && subtype.equals("Image");
    }

    private boolean checkMemory(int memoryNeeded) {
        return this.library.memoryManager.checkMemory(memoryNeeded);
    }

    public InputStream getInputStreamForDecodedStreamBytes() {
        Vector filterNames;
        if (this.streamInput == null || this.streamInput.getLength() < 1L) {
            return null;
        }
        long streamLength = this.streamInput.getLength();
        int memoryNeeded = (int)streamLength;
        this.checkMemory(memoryNeeded);
        this.streamInput.prepareForCurrentUse();
        InputStream input = this.streamInput;
        int bufferSize = Math.min(Math.max((int)streamLength, 64), 16384);
        input = new BufferedInputStream(input, bufferSize);
        if (this.library.securityManager != null) {
            Hashtable decodeParams = this.library.getDictionary(this.entries, "DecodeParam");
            input = this.library.getSecurityManager().getEncryptionInputStream(this.getPObjectReference(), this.library.getSecurityManager().getDecryptionKey(), decodeParams, input, true);
        }
        if ((filterNames = this.getFilterNames()) == null) {
            return input;
        }
        for (int i = 0; i < filterNames.size(); ++i) {
            String filterName = filterNames.elementAt(i).toString();
            if (filterName.equals("FlateDecode") || filterName.equals("/Fl") || filterName.equals("Fl")) {
                input = new FlateDecode(this.library, this.entries, input);
                memoryNeeded *= 2;
                continue;
            }
            if (filterName.equals("LZWDecode") || filterName.equals("/LZW") || filterName.equals("LZW")) {
                input = new LZWDecode(new BitStream(input), this.library, this.entries);
                memoryNeeded *= 2;
                continue;
            }
            if (filterName.equals("ASCII85Decode") || filterName.equals("/A85") || filterName.equals("A85")) {
                input = new ASCII85Decode(input);
                memoryNeeded *= 2;
                continue;
            }
            if (filterName.equals("ASCIIHexDecode") || filterName.equals("/AHx") || filterName.equals("AHx")) {
                input = new ASCIIHexDecode(input);
                memoryNeeded /= 2;
                continue;
            }
            if (filterName.equals("RunLengthDecode") || filterName.equals("/RL") || filterName.equals("RL")) {
                input = new RunLengthDecode(input);
                memoryNeeded *= 2;
                continue;
            }
            if (filterName.equals("CCITTFaxDecode") || filterName.equals("/CCF") || filterName.equals("CCF") || filterName.equals("DCTDecode") || filterName.equals("/DCT") || filterName.equals("DCT") || filterName.equals("JBIG2Decode") || filterName.equals("JPXDecode") || !logger.isLoggable(Level.FINE)) continue;
            logger.fine("UNSUPPORTED:" + filterName + " " + this.entries);
        }
        this.checkMemory(memoryNeeded);
        return input;
    }

    private byte[] getDecodedStreamBytes() {
        InputStream input = this.getInputStreamForDecodedStreamBytes();
        if (input == null) {
            return null;
        }
        try {
            int read;
            int outLength = Math.max(1024, (int)this.streamInput.getLength());
            ConservativeSizingByteArrayOutputStream out = new ConservativeSizingByteArrayOutputStream(outLength, this.library.memoryManager);
            byte[] buffer = new byte[outLength > 1024 ? 4096 : 1024];
            while ((read = input.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            out.flush();
            out.close();
            input.close();
            byte[] ret = out.toByteArray();
            return ret;
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem decoding stream bytes: ", e);
            return null;
        }
    }

    private Object[] getDecodedStreamBytesAndSize(int presize) {
        InputStream input = this.getInputStreamForDecodedStreamBytes();
        if (input == null) {
            return null;
        }
        try {
            int read;
            int outLength = presize > 0 ? presize : Math.max(1024, (int)this.streamInput.getLength());
            ConservativeSizingByteArrayOutputStream out = new ConservativeSizingByteArrayOutputStream(outLength, this.library.memoryManager);
            byte[] buffer = new byte[outLength > 1024 ? 4096 : 1024];
            while ((read = input.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            out.flush();
            out.close();
            input.close();
            int size = out.size();
            boolean trimmed = out.trim();
            byte[] data = out.relinquishByteArray();
            Object[] ret = new Object[]{data, size};
            return ret;
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem decoding stream bytes: ", e);
            return null;
        }
    }

    private void copyDecodedStreamBytesIntoRGB(int[] pixels) {
        byte[] rgb = new byte[3];
        try {
            InputStream input = this.getInputStreamForDecodedStreamBytes();
            for (int pixelIndex = 0; pixelIndex < pixels.length; ++pixelIndex) {
                int argb = -16777216;
                if (input != null) {
                    int haveRead;
                    int currRead;
                    int toRead = 3;
                    for (haveRead = 0; haveRead < 3 && (currRead = input.read(rgb, haveRead, 3 - haveRead)) >= 0; haveRead += currRead) {
                    }
                    if (haveRead >= 1) {
                        argb |= rgb[0] << 16 & 0xFF0000;
                    }
                    if (haveRead >= 2) {
                        argb |= rgb[1] << 8 & 0xFF00;
                    }
                    if (haveRead >= 3) {
                        argb |= rgb[2] & 0xFF;
                    }
                }
                pixels[pixelIndex] = argb;
            }
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem copying decoding stream bytes: ", e);
        }
    }

    private boolean shouldUseCCITTFaxDecode() {
        return this.containsFilter(new String[]{"CCITTFaxDecode", "/CCF", "CCF"});
    }

    private boolean shouldUseDCTDecode() {
        return this.containsFilter(new String[]{"DCTDecode", "/DCT", "DCT"});
    }

    private boolean shouldUseJBIG2Decode() {
        return this.containsFilter(new String[]{"JBIG2Decode"});
    }

    private boolean shouldUseJPXDecode() {
        return this.containsFilter(new String[]{"JPXDecode"});
    }

    private boolean containsFilter(String[] searchFilterNames) {
        Vector filterNames = this.getFilterNames();
        if (filterNames == null) {
            return false;
        }
        for (int i = 0; i < filterNames.size(); ++i) {
            String filterName = filterNames.elementAt(i).toString();
            for (String search : searchFilterNames) {
                if (!search.equals(filterName)) continue;
                return true;
            }
        }
        return false;
    }

    private Vector getFilterNames() {
        Vector filterNames = null;
        Object o = this.library.getObject(this.entries, "Filter");
        if (o instanceof Name) {
            filterNames = new Vector(1);
            filterNames.addElement(o);
        } else if (o instanceof Vector) {
            filterNames = (Vector)o;
        }
        return filterNames;
    }

    private Vector getNormalisedFilterNames() {
        Vector filterNames = this.getFilterNames();
        if (filterNames == null) {
            return null;
        }
        for (int i = 0; i < filterNames.size(); ++i) {
            String filterName = filterNames.elementAt(i).toString();
            if (filterName.equals("FlateDecode") || filterName.equals("/Fl") || filterName.equals("Fl")) {
                filterName = "FlateDecode";
            } else if (filterName.equals("LZWDecode") || filterName.equals("/LZW") || filterName.equals("LZW")) {
                filterName = "LZWDecode";
            } else if (filterName.equals("ASCII85Decode") || filterName.equals("/A85") || filterName.equals("A85")) {
                filterName = "ASCII85Decode";
            } else if (filterName.equals("ASCIIHexDecode") || filterName.equals("/AHx") || filterName.equals("AHx")) {
                filterName = "ASCIIHexDecode";
            } else if (filterName.equals("RunLengthDecode") || filterName.equals("/RL") || filterName.equals("RL")) {
                filterName = "RunLengthDecode";
            } else if (filterName.equals("CCITTFaxDecode") || filterName.equals("/CCF") || filterName.equals("CCF")) {
                filterName = "CCITTFaxDecode";
            } else if (filterName.equals("DCTDecode") || filterName.equals("/DCT") || filterName.equals("DCT")) {
                filterName = "DCTDecode";
            }
            filterNames.set(i, filterName);
        }
        return filterNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean cache) {
        if (this.streamInput != null) {
            if (!cache) {
                try {
                    this.streamInput.dispose();
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "Error disposing stream.", e);
                }
                this.streamInput = null;
            } else {
                this.library.removeObject(this.getPObjectReference());
            }
        }
        Object object = this.imageLock;
        synchronized (object) {
            if (this.image != null) {
                this.image.dispose(cache, this.streamInput != null);
                if (!cache || !this.image.isCachedSomehow()) {
                    this.image = null;
                }
            }
        }
    }

    private BufferedImage dctDecode(int width, int height, PColorSpace colourSpace, int bitspercomponent, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB, Vector<Integer> decode) {
        BufferedImage tmpImage;
        InputStream input = this.getInputStreamForDecodedStreamBytes();
        int MAX_BYTES_TO_READ_FOR_ENCODING = 2048;
        BufferedInputStream bufferedInput = new BufferedInputStream(input, 2048);
        bufferedInput.mark(2048);
        int jpegEncoding = 0;
        try {
            byte[] data = new byte[2048];
            int dataRead = bufferedInput.read(data);
            bufferedInput.reset();
            if (dataRead > 0) {
                jpegEncoding = Stream.getJPEGEncoding(data, dataRead);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, "Problem determining JPEG type: ", ioe);
        }
        if (Tagger.tagging) {
            Tagger.tagImage("DCTDecode_JpegEncoding=" + JPEG_ENC_NAMES[jpegEncoding]);
        }
        if ((tmpImage = null) == null) {
            try {
                WritableRaster wr;
                Raster r;
                JPEGImageDecoder imageDecoder = JPEGCodec.createJPEGDecoder((InputStream)bufferedInput);
                int bizarreFudge = 65536 + (int)this.streamInput.getLength();
                this.checkMemory(width * height * 8 + bizarreFudge);
                if (jpegEncoding == 1 && bitspercomponent == 8) {
                    r = imageDecoder.decodeAsRaster();
                    wr = r instanceof WritableRaster ? (WritableRaster)r : r.createCompatibleWritableRaster();
                    Stream.alterRasterRGB2PColorSpace(wr, colourSpace);
                    tmpImage = Stream.makeRGBBufferedImage(wr);
                } else if (jpegEncoding == 2 && bitspercomponent == 8) {
                    r = imageDecoder.decodeAsRaster();
                    wr = r instanceof WritableRaster ? (WritableRaster)r : r.createCompatibleWritableRaster();
                    tmpImage = Stream.alterRasterCMYK2BGRA(wr, smaskImage, maskImage);
                } else if (jpegEncoding == 3 && bitspercomponent == 8) {
                    r = imageDecoder.decodeAsRaster();
                    wr = r instanceof WritableRaster ? (WritableRaster)r : r.createCompatibleWritableRaster();
                    tmpImage = Stream.alterRasterYCbCr2RGB(wr, smaskImage, maskImage, decode, bitspercomponent);
                } else if (jpegEncoding == 4 && bitspercomponent == 8) {
                    r = imageDecoder.decodeAsRaster();
                    wr = r instanceof WritableRaster ? (WritableRaster)r : r.createCompatibleWritableRaster();
                    Stream.alterRasterYCCK2CMYK(wr, decode, bitspercomponent);
                    tmpImage = Stream.alterRasterCMYK2BGRA(wr, smaskImage, maskImage);
                } else if (jpegEncoding == 5 && bitspercomponent == 8) {
                    r = imageDecoder.decodeAsRaster();
                    WritableRaster writableRaster = wr = r instanceof WritableRaster ? (WritableRaster)r : r.createCompatibleWritableRaster();
                    if (!(colourSpace instanceof DeviceGray) && !(colourSpace instanceof ICCBased)) {
                        if (Tagger.tagging) {
                            Tagger.tagImage("DCTDecode_JpegSubEncoding=Y");
                        }
                        Stream.alterRasterY2Gray(wr, bitspercomponent, decode);
                    }
                    tmpImage = Stream.makeGrayBufferedImage(wr);
                    if (maskImage != null) {
                        Stream.applyExplicitMask(tmpImage, maskImage);
                    }
                } else {
                    r = imageDecoder.decodeAsRaster();
                    WritableRaster writableRaster = wr = r instanceof WritableRaster ? (WritableRaster)r : r.createCompatibleWritableRaster();
                    if (imageDecoder.getJPEGDecodeParam().getEncodedColorID() == 7) {
                        if (Tagger.tagging) {
                            Tagger.tagImage("DCTDecode_JpegSubEncoding=YCbCrA");
                        }
                        Stream.alterRasterYCbCrA2RGBA_new(wr, smaskImage, maskImage, decode, bitspercomponent);
                        tmpImage = Stream.makeRGBABufferedImage(wr);
                    } else {
                        if (Tagger.tagging) {
                            Tagger.tagImage("DCTDecode_JpegSubEncoding=YCbCr");
                        }
                        Stream.alterRasterYCbCr2RGB(wr, smaskImage, maskImage, decode, bitspercomponent);
                        tmpImage = Stream.makeRGBBufferedImage(wr);
                        if (smaskImage != null) {
                            BufferedImage argbImage = new BufferedImage(width, height, 2);
                            int[] srcBand = new int[width];
                            int[] sMaskBand = new int[width];
                            for (int i = 0; i < height; ++i) {
                                tmpImage.getRGB(0, i, width, 1, srcBand, 0, width);
                                smaskImage.getRGB(0, i, width, 1, sMaskBand, 0, width);
                                for (int j = 0; j < width; ++j) {
                                    sMaskBand[j] = (sMaskBand[j] & 0xFF) << 24 | srcBand[j] & 0xFFFFFF;
                                }
                                argbImage.setRGB(0, i, width, 1, sMaskBand, 0, width);
                            }
                            tmpImage.flush();
                            tmpImage = argbImage;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Problem loading JPEG image via JPEGImageDecoder: ", e);
            }
            if (tmpImage != null && Tagger.tagging) {
                Tagger.tagImage("HandledBy=DCTDecode_SunJPEGImageDecoder");
            }
        }
        try {
            bufferedInput.close();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error closing image stream.", e);
        }
        if (tmpImage == null) {
            try {
                Class<?> roClass;
                Method roGetAsBufferedImage;
                Object javax_media_jai_RenderedOp_op = null;
                try {
                    input = this.getInputStreamForDecodedStreamBytes();
                    Class<?> ssClass = Class.forName("com.sun.media.jai.codec.SeekableStream");
                    Method ssWrapInputStream = ssClass.getMethod("wrapInputStream", InputStream.class, Boolean.TYPE);
                    Object com_sun_media_jai_codec_SeekableStream_s = ssWrapInputStream.invoke(null, input, Boolean.TRUE);
                    ParameterBlock pb = new ParameterBlock();
                    pb.add(com_sun_media_jai_codec_SeekableStream_s);
                    Class<?> jaiClass = Class.forName("javax.media.jai.JAI");
                    Method jaiCreate = jaiClass.getMethod("create", String.class, ParameterBlock.class);
                    javax_media_jai_RenderedOp_op = jaiCreate.invoke(null, "jpeg", pb);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!(javax_media_jai_RenderedOp_op == null || jpegEncoding == 2 && bitspercomponent == 8 || jpegEncoding == 4 && bitspercomponent == 8 || (tmpImage = (BufferedImage)(roGetAsBufferedImage = (roClass = Class.forName("javax.media.jai.RenderedOp")).getMethod("getAsBufferedImage", new Class[0])).invoke(javax_media_jai_RenderedOp_op, new Object[0])) == null || !Tagger.tagging)) {
                    Tagger.tagImage("HandledBy=DCTDecode_JAI");
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Problem loading JPEG image via JAI: ", e);
            }
            try {
                input.close();
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Problem closing image stream. ", e);
            }
        }
        if (tmpImage == null) {
            try {
                Image img;
                byte[] data = this.getDecodedStreamBytes();
                if (data != null && (img = Toolkit.getDefaultToolkit().createImage(data)) != null) {
                    tmpImage = this.makeRGBABufferedImageFromImage(img);
                    if (Tagger.tagging) {
                        Tagger.tagImage("HandledBy=DCTDecode_ToolkitCreateImage");
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Problem loading JPEG image via Toolkit: ", e);
            }
        }
        return tmpImage;
    }

    private BufferedImage jbig2Decode(int width, int height, Color fill) {
        BufferedImage tmpImage = null;
        try {
            Class<?> jbig2DecoderClass = Class.forName("org.jpedal.jbig2.JBIG2Decoder");
            Constructor<?> jbig2DecoderClassConstructor = jbig2DecoderClass.getDeclaredConstructor(new Class[0]);
            Object jbig2Decoder = jbig2DecoderClassConstructor.newInstance(new Object[0]);
            this.checkMemory(110592);
            Hashtable decodeParms = this.library.getDictionary(this.entries, "DecodeParms");
            if (decodeParms != null) {
                byte[] globals;
                Stream globalsStream = null;
                Object jbigGlobals = this.library.getObject(decodeParms, "JBIG2Globals");
                if (jbigGlobals instanceof Stream) {
                    globalsStream = (Stream)this.library.getObject(decodeParms, "JBIG2Globals");
                }
                if (globalsStream != null && (globals = super.getDecodedStreamBytes()) != null && globals.length > 0) {
                    Class[] partypes = new Class[]{byte[].class};
                    Object[] arglist = new Object[]{globals};
                    Method setGlobalData = jbig2DecoderClass.getMethod("setGlobalData", partypes);
                    setGlobalData.invoke(jbig2Decoder, arglist);
                    globals = null;
                }
            }
            byte[] data = this.getDecodedStreamBytes();
            this.checkMemory((width + 8) * height * 22 / 10);
            Class[] argTypes = new Class[]{byte[].class};
            Object[] arglist = new Object[]{data};
            Method decodeJBIG2 = jbig2DecoderClass.getMethod("decodeJBIG2", argTypes);
            decodeJBIG2.invoke(jbig2Decoder, arglist);
            data = null;
            Method cleanupPostDecode = jbig2DecoderClass.getMethod("cleanupPostDecode", new Class[0]);
            cleanupPostDecode.invoke(jbig2Decoder, new Object[0]);
            this.checkMemory((width + 8) * height / 8);
            argTypes = new Class[]{Integer.TYPE};
            arglist = new Object[]{0};
            Method getPageAsBufferedImage = jbig2DecoderClass.getMethod("getPageAsBufferedImage", argTypes);
            tmpImage = (BufferedImage)getPageAsBufferedImage.invoke(jbig2Decoder, arglist);
        }
        catch (ClassNotFoundException e) {
            logger.warning("JBIG2 image library could not be found");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Problem loading JBIG2 image: ", e);
        }
        return tmpImage;
    }

    public Stream(Library library, Hashtable entries) {
        super(library, entries);
    }

    private BufferedImage jpxDecode(int width, int height, PColorSpace colourSpace, int bitsPerComponent, Color fill, BufferedImage sMaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB, Vector decode) {
        BufferedImage tmpImage = null;
        try {
            WritableRaster wr;
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG2000");
            if (!iterator.hasNext()) {
                logger.info("ImageIO missing required plug-in to read JPEG 2000 images. You can download the JAI ImageIO Tools from: https://jai-imageio.dev.java.net/");
                return null;
            }
            byte[] data = this.getDecodedStreamBytes();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
            tmpImage = ImageIO.read(imageInputStream);
            if (colourSpace instanceof ICCBased) {
                ICCBased iccBased = (ICCBased)colourSpace;
                if (iccBased.getAlternate() != null) {
                    colourSpace = iccBased.getAlternate();
                } else {
                    ColorSpace cs = iccBased.getColorSpace();
                    ColorConvertOp cco = new ColorConvertOp(cs, null);
                    tmpImage = cco.filter(tmpImage, null);
                }
            }
            if (colourSpace instanceof DeviceRGB && bitsPerComponent == 8) {
                wr = tmpImage.getRaster();
                Stream.alterRasterRGB2PColorSpace(wr, colourSpace);
                tmpImage = Stream.makeRGBBufferedImage(wr);
            } else if (colourSpace instanceof DeviceCMYK && bitsPerComponent == 8) {
                wr = tmpImage.getRaster();
                tmpImage = Stream.alterRasterCMYK2BGRA(wr, sMaskImage, maskImage);
            } else if ((colourSpace instanceof DeviceGray || colourSpace instanceof Indexed) && bitsPerComponent == 8) {
                wr = tmpImage.getRaster();
                tmpImage = Stream.makeGrayBufferedImage(wr);
            } else if (colourSpace instanceof Separation) {
                wr = tmpImage.getRaster();
                Stream.alterRasterY2Gray(wr, bitsPerComponent, decode);
            }
            if (maskImage != null) {
                Stream.applyExplicitMask(tmpImage, maskImage);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem loading JPEG2000 image: ", e);
        }
        return tmpImage;
    }

    private static BufferedImage alterRasterCMYK2BGRA(WritableRaster wr, BufferedImage smaskImage, BufferedImage maskImage) {
        int width = wr.getWidth();
        int height = wr.getHeight();
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
            if (width < smaskWidth || height < smaskHeight) {
                double scaleX = (double)width / (double)smaskWidth;
                double scaleY = (double)height / (double)smaskHeight;
                AffineTransform tx = new AffineTransform();
                tx.scale(scaleX, scaleY);
                AffineTransformOp op = new AffineTransformOp(tx, 1);
                BufferedImage sbim = op.filter(smaskImage, null);
                smaskImage.flush();
                smaskImage = sbim;
            }
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        float lastCyan = -1.0f;
        float lastMagenta = -1.0f;
        float lastYellow = -1.0f;
        float lastBlack = -1.0f;
        int rValue = 0;
        int gValue = 0;
        int bValue = 0;
        int alpha = 0;
        int[] values = new int[4];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.getPixel(x, y, values);
                float inCyan = (float)values[0] / 255.0f;
                float inMagenta = (float)values[1] / 255.0f;
                float inYellow = (float)values[2] / 255.0f;
                float inBlack = (float)values[3] / 768.0f;
                if (inCyan != lastCyan || inMagenta != lastMagenta || inYellow != lastYellow || inBlack != lastBlack) {
                    double c = Stream.clip(0.0, 1.0, inCyan + inBlack);
                    double m = Stream.clip(0.0, 1.0, inMagenta + inBlack);
                    double y2 = Stream.clip(0.0, 1.0, inYellow + inBlack);
                    double aw = (1.0 - c) * (1.0 - m) * (1.0 - y2);
                    double ac = c * (1.0 - m) * (1.0 - y2);
                    double am = (1.0 - c) * m * (1.0 - y2);
                    double ay = (1.0 - c) * (1.0 - m) * y2;
                    double ar = (1.0 - c) * m * y2;
                    double ag = c * (1.0 - m) * y2;
                    double ab = c * m * (1.0 - y2);
                    float outRed = (float)Stream.clip(0.0, 1.0, aw + 0.9137 * am + 0.9961 * ay + 0.9882 * ar);
                    float outGreen = (float)Stream.clip(0.0, 1.0, aw + 0.6196 * ac + ay + 0.5176 * ag);
                    float outBlue = (float)Stream.clip(0.0, 1.0, aw + 0.7804 * ac + 0.5412 * am + 0.0667 * ar + 0.2118 * ag + 0.4863 * ab);
                    rValue = (int)(outRed * 255.0f);
                    gValue = (int)(outGreen * 255.0f);
                    bValue = (int)(outBlue * 255.0f);
                    alpha = 255;
                }
                lastCyan = inCyan;
                lastMagenta = inMagenta;
                lastYellow = inYellow;
                lastBlack = inBlack;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskRaster.getSample(x, y, 0) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                }
                values[Stream.redIndex] = rValue;
                values[1] = gValue;
                values[Stream.blueIndex] = bValue;
                values[3] = alpha;
                wr.setPixel(x, y, values);
            }
        }
        BufferedImage tmpImage = Stream.makeRGBABufferedImage(wr);
        if (smaskImage != null) {
            BufferedImage argbImage = new BufferedImage(width, height, 2);
            int[] srcBand = new int[width];
            int[] sMaskBand = new int[width];
            for (int i = 0; i < height; ++i) {
                tmpImage.getRGB(0, i, width, 1, srcBand, 0, width);
                smaskImage.getRGB(0, i, width, 1, sMaskBand, 0, width);
                for (int j = 0; j < width; ++j) {
                    sMaskBand[j] = (sMaskBand[j] & 0xFF) << 24 | srcBand[j] & 0xFFFFFF;
                }
                argbImage.setRGB(0, i, width, 1, sMaskBand, 0, width);
            }
            tmpImage.flush();
            tmpImage = argbImage;
        }
        return tmpImage;
    }

    private static BufferedImage alterRasterYCbCr2RGB(WritableRaster wr, BufferedImage smaskImage, BufferedImage maskImage, Vector<Integer> decode, int bitsPerComponent) {
        int width = wr.getWidth();
        int height = wr.getHeight();
        int maxValue = (int)Math.pow(2.0, bitsPerComponent) - 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int gByte;
                int rByte;
                float[] values = Stream.getNormalizedComponents((byte[])wr.getDataElements(x, y, null), decode, maxValue);
                float Y = values[0] * 255.0f;
                float Cb = values[1] * 255.0f;
                float Cr = values[2] * 255.0f;
                float Cr_128 = Cr - 128.0f;
                float Cb_128 = Cb - 128.0f;
                float rVal = Y + 1370705.0f * Cr_128 / 1000000.0f;
                float gVal = Y - 337633.0f * Cb_128 / 1000000.0f - 698001.0f * Cr_128 / 1000000.0f;
                float bVal = Y + 1732446.0f * Cb_128 / 1000000.0f;
                byte by = (byte)(rVal < 0.0f ? 0 : (byte)(rByte = (byte)(rVal > 255.0f ? -1 : (byte)rVal)));
                byte by2 = (byte)(gVal < 0.0f ? 0 : (byte)(gByte = (byte)(gVal > 255.0f ? -1 : (byte)gVal)));
                int bByte = (byte)(bVal < 0.0f ? 0 : (byte)(bVal > 255.0f ? -1 : (byte)bVal));
                values[0] = rByte;
                values[1] = gByte;
                values[2] = bByte;
                wr.setPixel(x, y, values);
            }
        }
        BufferedImage tmpImage = Stream.makeRGBBufferedImage(wr);
        if (smaskImage != null) {
            BufferedImage argbImage = new BufferedImage(width, height, 2);
            int[] srcBand = new int[width];
            int[] sMaskBand = new int[width];
            for (int i = 0; i < height; ++i) {
                tmpImage.getRGB(0, i, width, 1, srcBand, 0, width);
                smaskImage.getRGB(0, i, width, 1, sMaskBand, 0, width);
                for (int j = 0; j < width; ++j) {
                    sMaskBand[j] = (sMaskBand[j] & 0xFF) << 24 | srcBand[j] & 0xFFFFFF;
                }
                argbImage.setRGB(0, i, width, 1, sMaskBand, 0, width);
            }
            tmpImage.flush();
            tmpImage = argbImage;
        }
        return tmpImage;
    }

    private static void alterRasterYCCK2BGRA(WritableRaster wr, BufferedImage smaskImage, BufferedImage maskImage, Vector<Integer> decode, int bitsPerComponent) {
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        double[] rgbaValues = new double[4];
        int width = wr.getWidth();
        int height = wr.getHeight();
        int maxValue = (int)Math.pow(2.0, bitsPerComponent) - 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int gByte;
                int rByte;
                float[] origValues = Stream.getNormalizedComponents((byte[])wr.getDataElements(x, y, null), decode, maxValue);
                float Y = origValues[0] * 255.0f;
                float Cb = origValues[1] * 255.0f;
                float Cr = origValues[2] * 255.0f;
                float Cr_128 = Cr - 128.0f;
                float Cb_128 = Cb - 128.0f;
                double rVal = (double)Y + 1.402 * (double)Cr_128;
                double gVal = (double)Y + 0.14414 * (double)Cb_128 + 0.11413636 * (double)Cr_128;
                double bVal = (double)Y + 1.772 * (double)Cb_128;
                byte by = (byte)(rVal < 0.0 ? 0 : (byte)(rByte = (byte)(rVal > 255.0 ? -1 : (byte)rVal)));
                byte by2 = (byte)(gVal < 0.0 ? 0 : (byte)(gByte = (byte)(gVal > 255.0 ? -1 : (byte)gVal)));
                int bByte = (byte)(bVal < 0.0 ? 0 : (byte)(bVal > 255.0 ? -1 : (byte)bVal));
                int alpha = 255;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskRaster.getSample(x, y, 0) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                }
                rgbaValues[0] = bByte;
                rgbaValues[1] = gByte;
                rgbaValues[2] = rByte;
                rgbaValues[3] = alpha;
                wr.setPixel(x, y, rgbaValues);
            }
        }
    }

    private static void alterRasterYCCK2CMYK(WritableRaster wr, Vector<Integer> decode, int bitsPerComponent) {
        double[] pixels = new double[4];
        double lastY = -1.0;
        double lastCb = -1.0;
        double lastCr = -1.0;
        double lastK = -1.0;
        double c = 0.0;
        double m = 0.0;
        double y2 = 0.0;
        double k = 0.0;
        int width = wr.getWidth();
        int height = wr.getHeight();
        int maxValue = (int)Math.pow(2.0, bitsPerComponent) - 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float[] origValues = Stream.getNormalizedComponents((byte[])wr.getDataElements(x, y, null), decode, maxValue);
                double Y = origValues[0] * 255.0f;
                double Cb = origValues[1] * 255.0f;
                double Cr = origValues[2] * 255.0f;
                double K = origValues[3] * 255.0f;
                if (lastY != (double)y || lastCb != Cb || lastCr != Cr || lastK != K) {
                    c = 255.0 - (Y + 1.402 * Cr - 179.456);
                    m = 255.0 - (Y - 0.34414 * Cb - 0.71413636 * Cr + 135.45984);
                    y2 = 255.0 - (Y + 1.7718 * Cb - 226.816);
                    k = K;
                    c = Stream.clip(0.0, 255.0, c);
                    m = Stream.clip(0.0, 255.0, m);
                    y2 = Stream.clip(0.0, 255.0, y2);
                }
                lastY = Y;
                lastCb = Cb;
                lastCr = Cr;
                lastK = K;
                pixels[0] = c;
                pixels[1] = m;
                pixels[2] = y2;
                pixels[3] = k;
                wr.setPixel(x, y, pixels);
            }
        }
    }

    private static float[] getNormalizedComponents(byte[] pixels, Vector decode, int xMax) {
        float[] normComponents = new float[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            int val = pixels[i] & 0xFF;
            float yMin = ((Number)decode.get(i * 2)).floatValue();
            float yMax = ((Number)decode.get(i * 2 + 1)).floatValue();
            normComponents[i] = Function.interpolate(val, 0.0f, xMax, yMin, yMax);
        }
        return normComponents;
    }

    private static void alterRasterYCbCrA2RGBA_new(WritableRaster wr, BufferedImage smaskImage, BufferedImage maskImage, Vector<Integer> decode, int bitsPerComponent) {
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        float[] origValues = new float[4];
        int[] rgbaValues = new int[4];
        int width = wr.getWidth();
        int height = wr.getHeight();
        int maxValue = (int)Math.pow(2.0, bitsPerComponent) - 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int gByte;
                int rByte;
                wr.getPixel(x, y, origValues);
                float Y = origValues[0];
                float Cb = origValues[1];
                float Cr = origValues[2];
                float K = origValues[3];
                Y = K - Y;
                float Cr_128 = Cr - 128.0f;
                float Cb_128 = Cb - 128.0f;
                float rVal = Y + 1370705.0f * Cr_128 / 1000000.0f;
                float gVal = Y - 337633.0f * Cb_128 / 1000000.0f - 698001.0f * Cr_128 / 1000000.0f;
                float bVal = Y + 1732446.0f * Cb_128 / 1000000.0f;
                byte by = (byte)(rVal < 0.0f ? 0 : (byte)(rByte = (byte)(rVal > 255.0f ? -1 : (byte)rVal)));
                byte by2 = (byte)(gVal < 0.0f ? 0 : (byte)(gByte = (byte)(gVal > 255.0f ? -1 : (byte)gVal)));
                int bByte = (byte)(bVal < 0.0f ? 0 : (byte)(bVal > 255.0f ? -1 : (byte)bVal));
                float alpha = K;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskRaster.getSample(x, y, 0) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                }
                rgbaValues[0] = rByte;
                rgbaValues[1] = gByte;
                rgbaValues[2] = bByte;
                rgbaValues[3] = (int)alpha;
                wr.setPixel(x, y, rgbaValues);
            }
        }
    }

    private static void applyExplicitMask(BufferedImage baseImage, BufferedImage maskImage) {
        int baseWidth = baseImage.getWidth();
        int baseHeight = baseImage.getHeight();
        int maskWidth = maskImage.getWidth();
        int maskHeight = maskImage.getHeight();
        if (baseWidth != maskWidth || baseHeight != maskHeight) {
            double scaleX = (double)baseWidth / (double)maskWidth;
            double scaleY = (double)baseHeight / (double)maskHeight;
            AffineTransform tx = new AffineTransform();
            tx.scale(scaleX, scaleY);
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            BufferedImage sbim = op.filter(maskImage, null);
            maskImage.flush();
            maskImage = sbim;
        }
        for (int y = 0; y < baseHeight; ++y) {
            for (int x = 0; x < baseWidth; ++x) {
                int maskPixel = maskImage.getRGB(x, y);
                if (maskPixel != -1 && maskPixel != 0xFFFFFF) continue;
                baseImage.setRGB(x, y, Color.WHITE.getRGB());
            }
        }
    }

    private static BufferedImage alterBufferedImage(BufferedImage bi, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB) {
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        int width = bi.getWidth();
        int height = bi.getHeight();
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
            if (width < smaskWidth || height < smaskHeight) {
                double scaleX = (double)smaskWidth / (double)width;
                double scaleY = (double)smaskHeight / (double)height;
                AffineTransform tx = new AffineTransform();
                tx.scale(scaleX, scaleY);
                AffineTransformOp op = new AffineTransformOp(tx, 1);
                BufferedImage bim = op.filter(bi, null);
                bi.flush();
                bi = bim;
            }
            width = bi.getWidth();
            height = bi.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        int maskMinRed = 255;
        int maskMinGreen = 255;
        int maskMinBlue = 255;
        int maskMaxRed = 0;
        int maskMaxGreen = 0;
        int maskMaxBlue = 0;
        if (maskMinRGB != null && maskMaxRGB != null) {
            maskMinRed = maskMinRGB[0];
            maskMinGreen = maskMinRGB[1];
            maskMinBlue = maskMinRGB[2];
            maskMaxRed = maskMaxRGB[0];
            maskMaxGreen = maskMaxRGB[1];
            maskMaxBlue = maskMaxRGB[2];
        }
        if (smaskRaster == null && maskRaster == null && (maskMinRGB == null || maskMaxRGB == null)) {
            return null;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                boolean gotARBG = false;
                int argb = 0;
                int alpha = 255;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskRaster.getSample(x, y, 0) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                } else {
                    gotARBG = true;
                    argb = bi.getRGB(x, y);
                    int red = argb >> 16 & 0xFF;
                    int green = argb >> 8 & 0xFF;
                    int blue = argb & 0xFF;
                    if (blue >= maskMinBlue && blue <= maskMaxBlue && green >= maskMinGreen && green <= maskMaxGreen && red >= maskMinRed && red <= maskMaxRed) {
                        alpha = 0;
                    }
                }
                if (alpha == 255) continue;
                if (!gotARBG) {
                    argb = bi.getRGB(x, y);
                }
                argb &= 0xFFFFFF;
                bi.setRGB(x, y, argb |= alpha << 24 & 0xFF000000);
            }
        }
        BufferedImage tmpImage = bi;
        if (smaskImage != null) {
            BufferedImage argbImage = new BufferedImage(width, height, 2);
            int[] srcBand = new int[width];
            int[] sMaskBand = new int[width];
            for (int i = 0; i < height; ++i) {
                tmpImage.getRGB(0, i, width, 1, srcBand, 0, width);
                smaskImage.getRGB(0, i, width, 1, sMaskBand, 0, width);
                for (int j = 0; j < width; ++j) {
                    sMaskBand[j] = (sMaskBand[j] & 0xFF) << 24 | srcBand[j] & 0xFFFFFF;
                }
                argbImage.setRGB(0, i, width, 1, sMaskBand, 0, width);
            }
            tmpImage.flush();
            tmpImage = argbImage;
        }
        return tmpImage;
    }

    private static WritableRaster alterRasterRGBA(WritableRaster wr, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB) {
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        int maskMinRed = 255;
        int maskMinGreen = 255;
        int maskMinBlue = 255;
        int maskMaxRed = 0;
        int maskMaxGreen = 0;
        int maskMaxBlue = 0;
        if (maskMinRGB != null && maskMaxRGB != null) {
            maskMinRed = maskMinRGB[0];
            maskMinGreen = maskMinRGB[1];
            maskMinBlue = maskMinRGB[2];
            maskMaxRed = maskMaxRGB[0];
            maskMaxGreen = maskMaxRGB[1];
            maskMaxBlue = maskMaxRGB[2];
        }
        if (smaskRaster == null && maskRaster == null && (maskMinRGB == null || maskMaxRGB == null)) {
            return null;
        }
        int[] rgbaValues = new int[4];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.getPixel(x, y, rgbaValues);
                int red = rgbaValues[0];
                int green = rgbaValues[1];
                int blue = rgbaValues[2];
                int alpha = 255;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskImage.getRGB(x, y) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                } else if (blue >= maskMinBlue && blue <= maskMaxBlue && green >= maskMinGreen && green <= maskMaxGreen && red >= maskMinRed && red <= maskMaxRed) {
                    alpha = 0;
                }
                if (alpha == 255) continue;
                rgbaValues[3] = alpha;
                wr.setPixel(x, y, rgbaValues);
            }
        }
        return wr;
    }

    private static void alterRasterRGB2PColorSpace(WritableRaster wr, PColorSpace colorSpace) {
        if (colorSpace instanceof DeviceRGB) {
            return;
        }
        float[] values = new float[3];
        int[] rgbValues = new int[3];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.getPixel(x, y, rgbValues);
                PColorSpace.reverseInPlace(rgbValues);
                colorSpace.normaliseComponentsToFloats(rgbValues, values, 255.0f);
                Color c = colorSpace.getColor(values);
                rgbValues[0] = c.getRed();
                rgbValues[1] = c.getGreen();
                rgbValues[2] = c.getBlue();
                wr.setPixel(x, y, rgbValues);
            }
        }
    }

    private static void alterRasterY2Gray(WritableRaster wr, int bitsPerComponent, Vector decode) {
        int[] values = new int[1];
        int width = wr.getWidth();
        int height = wr.getHeight();
        boolean defaultDecode = 0.0f == ((Number)decode.elementAt(0)).floatValue();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.getPixel(x, y, values);
                int Y = values[0];
                int n = Y = defaultDecode ? 255 - Y : Y;
                values[0] = Y = (byte)(Y < 0 ? 0 : (byte)(Y > 255 ? -1 : (byte)Y));
                wr.setPixel(x, y, values);
            }
        }
    }

    private static int getJPEGEncoding(byte[] data, int dataLength) {
        int jpegEncoding = 0;
        boolean foundAPP14 = false;
        int compsTypeFromAPP14 = 0;
        boolean foundSOF = false;
        int numCompsFromSOF = 0;
        boolean foundSOS = false;
        int numCompsFromSOS = 0;
        int index = 0;
        while (!(index >= dataLength || data[index] != -1 || foundAPP14 && foundSOF)) {
            byte segmentType = data[index + 1];
            index += 2;
            if (segmentType == -40) continue;
            int length = (data[index] << 8 & 0xFF00) + (data[index + 1] & 0xFF);
            if (segmentType == -18) {
                if (length >= 14) {
                    foundAPP14 = true;
                    compsTypeFromAPP14 = data[index + 13];
                }
            } else if (segmentType == -64) {
                foundSOF = true;
                numCompsFromSOF = data[index + 7] & 0xFF;
            } else if (segmentType == -38) {
                foundSOS = true;
                numCompsFromSOS = data[index + 2] & 0xFF;
            }
            index += length;
        }
        if (foundAPP14 && foundSOF) {
            if (compsTypeFromAPP14 == 0) {
                if (numCompsFromSOF == 1) {
                    jpegEncoding = 5;
                }
                if (numCompsFromSOF == 3) {
                    jpegEncoding = 1;
                } else if (numCompsFromSOF == 4) {
                    jpegEncoding = 2;
                }
            } else if (compsTypeFromAPP14 == 1) {
                jpegEncoding = 3;
            } else if (compsTypeFromAPP14 == 2) {
                jpegEncoding = 4;
            }
        } else if (foundSOS && numCompsFromSOS == 1) {
            jpegEncoding = 5;
        }
        return jpegEncoding;
    }

    private static BufferedImage makeRGBABufferedImage(WritableRaster wr) {
        return Stream.makeRGBABufferedImage(wr, 1);
    }

    private static BufferedImage makeRGBABufferedImage(WritableRaster wr, int transparency) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[4];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = 8;
        }
        ComponentColorModel cm = new ComponentColorModel(cs, bits, true, false, transparency, wr.getTransferType());
        BufferedImage img = new BufferedImage(cm, wr, false, null);
        return img;
    }

    private static BufferedImage makeRGBBufferedImage(WritableRaster wr) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[3];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = 8;
        }
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, wr.getTransferType());
        BufferedImage img = new BufferedImage(cm, wr, false, null);
        return img;
    }

    private static BufferedImage makeGrayBufferedImage(WritableRaster wr) {
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[1];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = 8;
        }
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, wr.getTransferType());
        BufferedImage img = new BufferedImage(cm, wr, false, null);
        return img;
    }

    private BufferedImage makeRGBABufferedImageFromImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = Stream.hasAlpha(image);
        BufferedImage bImage = null;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if (width == -1 || height == -1) {
                return null;
            }
            bImage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            // empty catch block
        }
        if (bImage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if (width == -1 || height == -1) {
                return null;
            }
            bImage = new BufferedImage(width, height, type);
        }
        Graphics2D g = bImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        image.flush();
        return bImage;
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = pixelGrabber.getColorModel();
        return cm == null || cm.hasAlpha();
    }

    private byte[] ccittFaxDecode(int width, int height) {
        byte[] streamData = this.getDecodedStreamBytes();
        Hashtable decodeParms = this.library.getDictionary(this.entries, "DecodeParms");
        float k = this.library.getFloat(decodeParms, "K");
        boolean blackIs1 = this.getBlackIs1(this.library, decodeParms);
        boolean encodedByteAlign = false;
        Object encodedByteAlignObject = this.library.getObject(decodeParms, "EncodedByteAlign");
        if (encodedByteAlignObject instanceof Boolean) {
            encodedByteAlign = (Boolean)encodedByteAlignObject;
        }
        int columns = this.library.getInt(decodeParms, "Columns");
        int rows = this.library.getInt(decodeParms, "Rows");
        if (columns == 0) {
            columns = width;
        }
        if (rows == 0) {
            rows = height;
        }
        int size = rows * (columns + 7 >> 3);
        byte[] decodedStreamData = new byte[size];
        CCITTFaxDecoder decoder = new CCITTFaxDecoder(1, columns, rows);
        decoder.setAlign(encodedByteAlign);
        try {
            if (k == 0.0f) {
                decoder.decodeT41D(decodedStreamData, streamData, 0, rows);
            } else if (k > 0.0f) {
                decoder.decodeT42D(decodedStreamData, streamData, 0, rows);
            } else if (k < 0.0f) {
                decoder.decodeT6(decodedStreamData, streamData, 0, rows);
            }
        }
        catch (Exception e) {
            logger.warning("Error decoding CCITTFax image k: " + k);
            decoder.decodeT6(decodedStreamData, streamData, 0, rows);
        }
        if (!blackIs1) {
            for (int i = 0; i < decodedStreamData.length; ++i) {
                decodedStreamData[i] = ~decodedStreamData[i];
            }
        }
        return decodedStreamData;
    }

    public byte[] getBytes() {
        byte[] data = this.getDecodedStreamBytes();
        if (data == null) {
            data = new byte[]{};
        }
        return data;
    }

    public BufferedImage getImage(Color fill, Resources resources, boolean allowScaling) {
        BufferedImage img;
        if (Tagger.tagging) {
            Tagger.beginImage(this.pObjectReference, this.inlineImage);
        }
        if (Tagger.tagging) {
            Tagger.tagImage("Filter=" + this.getNormalisedFilterNames());
        }
        PColorSpace colourSpace = null;
        Object o = this.library.getObject(this.entries, "ColorSpace");
        if (resources != null) {
            colourSpace = resources.getColorSpace(o);
        }
        if (colourSpace == null) {
            colourSpace = new DeviceGray(this.library, null);
            if (Tagger.tagging) {
                Tagger.tagImage("ColorSpace_Implicit_DeviceGray");
            }
        }
        if (Tagger.tagging) {
            Tagger.tagImage("ColorSpace=" + colourSpace.getDescription());
        }
        boolean imageMask = this.isImageMask();
        if (Tagger.tagging) {
            Tagger.tagImage("ImageMask=" + imageMask);
        }
        if (imageMask) {
            allowScaling = false;
        }
        int bitspercomponent = this.library.getInt(this.entries, "BitsPerComponent");
        if (imageMask && bitspercomponent == 0) {
            bitspercomponent = 1;
            if (Tagger.tagging) {
                Tagger.tagImage("BitsPerComponent_Implicit_1");
            }
        }
        if (Tagger.tagging) {
            Tagger.tagImage("BitsPerComponent=" + bitspercomponent);
        }
        int width = this.library.getInt(this.entries, "Width");
        int height = this.library.getInt(this.entries, "Height");
        if (height == 0) {
            height = width;
        }
        int colorSpaceCompCount = colourSpace.getNumComponents();
        Vector<Integer> decode = (Vector<Integer>)this.library.getObject(this.entries, "Decode");
        if (decode == null) {
            int depth = colourSpace.getNumComponents();
            decode = new Vector<Integer>(depth);
            for (int i = 0; i < depth; ++i) {
                decode.addElement(0);
                decode.addElement(1);
            }
            if (Tagger.tagging) {
                Tagger.tagImage("Decode_Implicit_01");
            }
        }
        if (Tagger.tagging) {
            Tagger.tagImage("Decode=" + decode);
        }
        BufferedImage smaskImage = null;
        BufferedImage maskImage = null;
        int[] maskMinRGB = null;
        int[] maskMaxRGB = null;
        int maskMinIndex = -1;
        int maskMaxIndex = -1;
        Object smaskObj = this.library.getObject(this.entries, "SMask");
        Object maskObj = this.library.getObject(this.entries, "Mask");
        if (smaskObj instanceof Stream) {
            Stream smaskStream;
            if (Tagger.tagging) {
                Tagger.tagImage("SMaskStream");
            }
            if ((smaskStream = (Stream)smaskObj).isImageSubtype()) {
                smaskImage = smaskStream.getImage(fill, resources, false);
            }
        }
        if (smaskImage != null) {
            if (Tagger.tagging) {
                Tagger.tagImage("SMaskImage");
            }
            allowScaling = false;
        }
        if (maskObj != null && smaskImage == null) {
            if (maskObj instanceof Stream) {
                Stream maskStream;
                if (Tagger.tagging) {
                    Tagger.tagImage("MaskStream");
                }
                if ((maskStream = (Stream)maskObj).isImageSubtype() && (maskImage = maskStream.getImage(fill, resources, false)) != null && Tagger.tagging) {
                    Tagger.tagImage("MaskImage");
                }
            } else if (maskObj instanceof Vector) {
                if (Tagger.tagging) {
                    Tagger.tagImage("MaskVector");
                }
                Vector maskVector = (Vector)maskObj;
                int[] maskMinOrigCompsInt = new int[colorSpaceCompCount];
                int[] maskMaxOrigCompsInt = new int[colorSpaceCompCount];
                for (int i = 0; i < colorSpaceCompCount; ++i) {
                    if (i * 2 < maskVector.size()) {
                        maskMinOrigCompsInt[i] = ((Number)maskVector.get(i * 2)).intValue();
                    }
                    if (i * 2 + 1 >= maskVector.size()) continue;
                    maskMaxOrigCompsInt[i] = ((Number)maskVector.get(i * 2 + 1)).intValue();
                }
                if (colourSpace instanceof Indexed) {
                    Indexed icolourSpace = (Indexed)colourSpace;
                    Color[] colors = icolourSpace.accessColorTable();
                    if (colors != null && maskMinOrigCompsInt.length >= 1 && maskMaxOrigCompsInt.length >= 1) {
                        maskMinIndex = maskMinOrigCompsInt[0];
                        maskMaxIndex = maskMaxOrigCompsInt[0];
                        if (maskMinIndex >= 0 && maskMinIndex < colors.length && maskMaxIndex >= 0 && maskMaxIndex < colors.length) {
                            Color minColor = colors[maskMinOrigCompsInt[0]];
                            Color maxColor = colors[maskMaxOrigCompsInt[0]];
                            maskMinRGB = new int[]{minColor.getRed(), minColor.getGreen(), minColor.getBlue()};
                            maskMaxRGB = new int[]{maxColor.getRed(), maxColor.getGreen(), maxColor.getBlue()};
                        }
                    }
                } else {
                    PColorSpace.reverseInPlace(maskMinOrigCompsInt);
                    PColorSpace.reverseInPlace(maskMaxOrigCompsInt);
                    float[] maskMinOrigComps = new float[colorSpaceCompCount];
                    float[] maskMaxOrigComps = new float[colorSpaceCompCount];
                    colourSpace.normaliseComponentsToFloats(maskMinOrigCompsInt, maskMinOrigComps, (1 << bitspercomponent) - 1);
                    colourSpace.normaliseComponentsToFloats(maskMaxOrigCompsInt, maskMaxOrigComps, (1 << bitspercomponent) - 1);
                    Color minColor = colourSpace.getColor(maskMinOrigComps);
                    Color maxColor = colourSpace.getColor(maskMaxOrigComps);
                    PColorSpace.reverseInPlace(maskMinOrigComps);
                    PColorSpace.reverseInPlace(maskMaxOrigComps);
                    maskMinRGB = new int[]{minColor.getRed(), minColor.getGreen(), minColor.getBlue()};
                    maskMaxRGB = new int[]{maxColor.getRed(), maxColor.getGreen(), maxColor.getBlue()};
                }
            }
        }
        if ((img = this.getImage(colourSpace, fill, width, height, colorSpaceCompCount, bitspercomponent, imageMask, decode, smaskImage, maskImage, maskMinRGB, maskMaxRGB, maskMinIndex, maskMaxIndex)) != null) {
            img = this.putIntoImageCache(img, width, height, allowScaling);
        }
        if (Tagger.tagging) {
            Tagger.endImage(this.pObjectReference);
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage(PColorSpace colourSpace, Color fill, int width, int height, int colorSpaceCompCount, int bitsPerComponent, boolean imageMask, Vector decode, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB, int maskMinIndex, int maskMaxIndex) {
        BufferedImage decodedImage;
        int dataLength;
        byte[] data;
        if (this.image != null) {
            this.checkMemory(width * height * Math.max(colorSpaceCompCount, 4));
            BufferedImage img = null;
            Object object = this.imageLock;
            synchronized (object) {
                if (this.image != null) {
                    img = this.image.readImage();
                }
            }
            if (img != null) {
                return img;
            }
        }
        if (this.image == null) {
            BufferedImage decodedImage2 = null;
            if (this.shouldUseDCTDecode()) {
                if (Tagger.tagging) {
                    Tagger.tagImage("DCTDecode");
                }
                decodedImage2 = this.dctDecode(width, height, colourSpace, bitsPerComponent, smaskImage, maskImage, maskMinRGB, maskMaxRGB, decode);
            } else if (this.shouldUseJBIG2Decode()) {
                if (Tagger.tagging) {
                    Tagger.tagImage("JBIG2Decode");
                }
                decodedImage2 = this.jbig2Decode(width, height, fill);
            } else if (this.shouldUseJPXDecode()) {
                if (Tagger.tagging) {
                    Tagger.tagImage("JPXDecode");
                }
                decodedImage2 = this.jpxDecode(width, height, colourSpace, bitsPerComponent, fill, smaskImage, maskImage, maskMinRGB, maskMaxRGB, decode);
            } else if (this.shouldUseCCITTFaxDecode()) {
                if (Tagger.tagging) {
                    Tagger.tagImage("CCITTFaxDecode JAI");
                }
                decodedImage2 = CCITTFax.attemptDeriveBufferedImageFromBytes(this, this.library, this.entries, fill);
            }
            if (decodedImage2 != null) {
                return decodedImage2;
            }
        }
        if (this.shouldUseCCITTFaxDecode()) {
            if (Tagger.tagging) {
                Tagger.tagImage("CCITTFaxDecode");
            }
            data = this.ccittFaxDecode(width, height);
            dataLength = data.length;
        } else {
            Object[] dataAndSize = this.getDecodedStreamBytesAndSize(width * height * colourSpace.getNumComponents() * bitsPerComponent / 8);
            data = (byte[])dataAndSize[0];
            dataLength = (Integer)dataAndSize[1];
        }
        if (data != null) {
            try {
                decodedImage = this.makeImageWithRasterFromBytes(colourSpace, fill, width, height, colorSpaceCompCount, bitsPerComponent, imageMask, decode, smaskImage, maskImage, maskMinRGB, maskMaxRGB, maskMinIndex, maskMaxIndex, data, dataLength);
                if (decodedImage != null) {
                    return decodedImage;
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error building image raster.", e);
            }
        }
        decodedImage = this.parseImage(width, height, colourSpace, imageMask, fill, bitsPerComponent, decode, data, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
        return decodedImage;
    }

    private BufferedImage makeImageWithRasterFromBytes(PColorSpace colourSpace, Color fill, int width, int height, int colorSpaceCompCount, int bitspercomponent, boolean imageMask, Vector decode, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB, int maskMinIndex, int maskMaxIndex, byte[] data, int dataLength) {
        ICCBased iccBased;
        BufferedImage img = null;
        if (colourSpace instanceof ICCBased && (iccBased = (ICCBased)colourSpace).getAlternate() != null) {
            colourSpace = iccBased.getAlternate();
        }
        if (colourSpace instanceof DeviceGray) {
            DataBufferByte db;
            if (imageMask && bitspercomponent == 1) {
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_DeviceGray_1_ImageMask");
                }
                db = new DataBufferByte(data, dataLength);
                WritableRaster wr = Raster.createPackedRaster(db, width, height, bitspercomponent, new Point(0, 0));
                boolean defaultDecode = 0.0f == ((Number)decode.elementAt(0)).floatValue();
                int a = 0xFFFFFF;
                int[] cmap = new int[]{defaultDecode ? fill.getRGB() : a, defaultDecode ? a : fill.getRGB()};
                int transparentIndex = defaultDecode ? 1 : 0;
                IndexColorModel icm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, true, transparentIndex, db.getDataType());
                img = new BufferedImage(icm, wr, false, null);
            } else if (bitspercomponent == 1 || bitspercomponent == 2 || bitspercomponent == 4) {
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_DeviceGray_124");
                }
                db = new DataBufferByte(data, dataLength);
                WritableRaster wr = Raster.createPackedRaster(db, width, height, bitspercomponent, new Point(0, 0));
                int[] cmap = null;
                if (bitspercomponent == 1) {
                    boolean defaultDecode = 0.0f == ((Number)decode.elementAt(0)).floatValue();
                    cmap = defaultDecode ? GRAY_1_BIT_INDEX_TO_RGB : GRAY_1_BIT_INDEX_TO_RGB_REVERSED;
                } else if (bitspercomponent == 2) {
                    cmap = GRAY_2_BIT_INDEX_TO_RGB;
                } else if (bitspercomponent == 4) {
                    cmap = GRAY_4_BIT_INDEX_TO_RGB;
                }
                IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, false, -1, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
            } else if (bitspercomponent == 8) {
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_DeviceGray_8");
                }
                db = new DataBufferByte(data, dataLength);
                PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), width, height, 1, width, new int[]{0});
                WritableRaster wr = Raster.createWritableRaster(sm, db, new Point(0, 0));
                float[] origValues = new float[3];
                int maxValue = (int)Math.pow(2.0, bitspercomponent) - 1;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        wr.getPixel(x, y, origValues);
                        origValues = Stream.getNormalizedComponents((byte[])wr.getDataElements(x, y, null), decode, maxValue);
                        float gray = origValues[0] * 255.0f;
                        int rByte = (byte)(gray < 0.0f ? 0 : (byte)(gray > 255.0f ? -1 : (byte)gray));
                        origValues[0] = rByte;
                        wr.setPixel(x, y, origValues);
                    }
                }
                ColorSpace cs = ColorSpace.getInstance(1003);
                ComponentColorModel cm = new ComponentColorModel(cs, new int[]{bitspercomponent}, false, false, 1, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
            }
            if (maskImage != null) {
                Stream.applyExplicitMask(img, maskImage);
            }
            if (smaskImage != null) {
                img = Stream.alterBufferedImage(img, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
            }
        } else if (colourSpace instanceof DeviceRGB) {
            if (bitspercomponent == 8) {
                boolean usingAlpha;
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_DeviceRGB_8");
                }
                this.checkMemory(width * height * 4);
                boolean bl = usingAlpha = smaskImage != null || maskImage != null || maskMinRGB != null && maskMaxRGB != null;
                if (Tagger.tagging) {
                    Tagger.tagImage("RasterFromBytes_DeviceRGB_8_alpha=" + usingAlpha);
                }
                int type = usingAlpha ? 2 : 1;
                img = new BufferedImage(width, height, type);
                int[] dataToRGB = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
                this.copyDecodedStreamBytesIntoRGB(dataToRGB);
                if (usingAlpha) {
                    Stream.alterBufferedImage(img, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
                }
            }
        } else if (!(colourSpace instanceof DeviceCMYK) && colourSpace instanceof Indexed) {
            Color[] colors;
            if (bitspercomponent == 1 || bitspercomponent == 2 || bitspercomponent == 4) {
                boolean usingAlpha;
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_Indexed_124");
                }
                colourSpace.init();
                colors = ((Indexed)colourSpace).accessColorTable();
                int[] cmap = new int[colors == null ? 0 : colors.length];
                for (int i = 0; i < cmap.length; ++i) {
                    cmap[i] = colors[i].getRGB();
                }
                int cmapMaxLength = 1 << bitspercomponent;
                if (cmap.length > cmapMaxLength) {
                    int[] cmapTruncated = new int[cmapMaxLength];
                    System.arraycopy(cmap, 0, cmapTruncated, 0, cmapMaxLength);
                    cmap = cmapTruncated;
                }
                boolean usingIndexedAlpha = maskMinIndex >= 0 && maskMaxIndex >= 0;
                boolean bl = usingAlpha = smaskImage != null || maskImage != null || maskMinRGB != null && maskMaxRGB != null;
                if (Tagger.tagging) {
                    Tagger.tagImage("RasterFromBytes_Indexed_124_alpha=" + (usingIndexedAlpha ? "indexed" : (usingAlpha ? "alpha" : "false")));
                }
                if (usingAlpha) {
                    DataBufferByte db = new DataBufferByte(data, dataLength);
                    WritableRaster wr = Raster.createPackedRaster(db, width, height, bitspercomponent, new Point(0, 0));
                    IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, false, -1, db.getDataType());
                    img = new BufferedImage(cm, wr, false, null);
                    img = Stream.alterBufferedImage(img, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
                } else {
                    DataBufferByte db = new DataBufferByte(data, dataLength);
                    WritableRaster wr = Raster.createPackedRaster(db, width, height, bitspercomponent, new Point(0, 0));
                    IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, false, -1, db.getDataType());
                    img = new BufferedImage(cm, wr, false, null);
                }
            } else if (bitspercomponent == 8) {
                boolean usingAlpha;
                int i;
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_Indexed_8");
                }
                colourSpace.init();
                colors = ((Indexed)colourSpace).accessColorTable();
                int colorsLength = colors == null ? 0 : colors.length;
                int[] cmap = new int[256];
                for (i = 0; i < colorsLength; ++i) {
                    cmap[i] = colors[i].getRGB();
                }
                for (i = colorsLength; i < cmap.length; ++i) {
                    cmap[i] = -16777216;
                }
                boolean usingIndexedAlpha = maskMinIndex >= 0 && maskMaxIndex >= 0;
                boolean bl = usingAlpha = smaskImage != null || maskImage != null || maskMinRGB != null && maskMaxRGB != null;
                if (Tagger.tagging) {
                    Tagger.tagImage("RasterFromBytes_Indexed_8_alpha=" + (usingIndexedAlpha ? "indexed" : (usingAlpha ? "alpha" : "false")));
                }
                if (usingIndexedAlpha) {
                    for (int i2 = maskMinIndex; i2 <= maskMaxIndex; ++i2) {
                        cmap[i2] = 0;
                    }
                    DataBufferByte db = new DataBufferByte(data, dataLength);
                    PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), width, height, 1, width, new int[]{0});
                    WritableRaster wr = Raster.createWritableRaster(sm, db, new Point(0, 0));
                    IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, true, -1, db.getDataType());
                    img = new BufferedImage(cm, wr, false, null);
                } else if (usingAlpha) {
                    this.checkMemory(width * height * 4);
                    int[] rgbaData = new int[width * height];
                    for (int index = 0; index < dataLength; ++index) {
                        int cmapIndex = data[index] & 0xFF;
                        rgbaData[index] = cmap[cmapIndex];
                    }
                    DataBufferInt db = new DataBufferInt(rgbaData, rgbaData.length);
                    int[] masks = new int[]{0xFF0000, 65280, 255, -16777216};
                    WritableRaster wr = Raster.createPackedRaster(db, width, height, width, masks, new Point(0, 0));
                    Stream.alterRasterRGBA(wr, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
                    ColorSpace cs = ColorSpace.getInstance(1000);
                    DirectColorModel cm = new DirectColorModel(cs, 32, 0xFF0000, 65280, 255, -16777216, false, db.getDataType());
                    img = new BufferedImage(cm, wr, false, null);
                } else {
                    DataBufferByte db = new DataBufferByte(data, dataLength);
                    PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), width, height, 1, width, new int[]{0});
                    WritableRaster wr = Raster.createWritableRaster(sm, db, new Point(0, 0));
                    IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, false, -1, db.getDataType());
                    img = new BufferedImage(cm, wr, false, null);
                }
            }
        }
        return img;
    }

    private BufferedImage parseImage(int width, int height, PColorSpace colorSpace, boolean imageMask, Color fill, int bitsPerColour, Vector decode, byte[] baCCITTFaxData, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB) {
        BitStream in;
        if (Tagger.tagging) {
            Tagger.tagImage("HandledBy=ParseImage");
        }
        int[] imageBits = new int[width];
        int fillRGB = fill.getRGB();
        int colorSpaceCompCount = colorSpace.getNumComponents();
        boolean isDeviceRGB = colorSpace instanceof DeviceRGB;
        boolean isDeviceGray = colorSpace instanceof DeviceGray;
        int maxColourValue = (1 << bitsPerColour) - 1;
        int[] f = new int[colorSpaceCompCount];
        float[] ff = new float[colorSpaceCompCount];
        int imageMaskValue = ((Number)decode.elementAt(0)).intValue();
        float[] decodeArray = null;
        if (decode != null) {
            decodeArray = new float[decode.size()];
            for (int i = 0; i < decodeArray.length; ++i) {
                decodeArray[i] = ((Number)decode.elementAt(i)).floatValue();
            }
        }
        int memoryNeeded = width * height * 4;
        this.checkMemory(memoryNeeded);
        BufferedImage bim = new BufferedImage(width, height, 2);
        if (baCCITTFaxData != null) {
            in = new BitStream(new ByteArrayInputStream(baCCITTFaxData));
        } else {
            InputStream dataInput = this.getInputStreamForDecodedStreamBytes();
            if (dataInput == null) {
                return null;
            }
            in = new BitStream(dataInput);
        }
        try {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (imageMask) {
                        int bit = in.getBits(bitsPerColour);
                        imageBits[x] = bit = bit == imageMaskValue ? fillRGB : 0;
                        continue;
                    }
                    int red = 255;
                    int blue = 255;
                    int green = 255;
                    int alpha = 255;
                    if (colorSpaceCompCount == 1) {
                        int bit = in.getBits(bitsPerColour);
                        if (decodeArray != null && decodeArray[0] > decodeArray[1]) {
                            int n = bit = bit == maxColourValue ? 0 : maxColourValue;
                        }
                        if (isDeviceGray) {
                            if (bitsPerColour == 1) {
                                bit = GRAY_1_BIT_INDEX_TO_RGB[bit];
                            } else if (bitsPerColour == 2) {
                                bit = GRAY_2_BIT_INDEX_TO_RGB[bit];
                            } else if (bitsPerColour == 4) {
                                bit = GRAY_4_BIT_INDEX_TO_RGB[bit];
                            } else if (bitsPerColour == 8) {
                                bit = bit << 24 | bit << 16 | bit << 8 | bit;
                            }
                            imageBits[x] = bit;
                            continue;
                        }
                        f[0] = bit;
                        colorSpace.normaliseComponentsToFloats(f, ff, maxColourValue);
                        Color color = colorSpace.getColor(ff);
                        imageBits[x] = color.getRGB();
                        continue;
                    }
                    if (colorSpaceCompCount == 3) {
                        if (isDeviceRGB) {
                            red = in.getBits(bitsPerColour);
                            green = in.getBits(bitsPerColour);
                            blue = in.getBits(bitsPerColour);
                            imageBits[x] = alpha << 24 | red << 16 | green << 8 | blue;
                            continue;
                        }
                        for (int i = 0; i < colorSpaceCompCount; ++i) {
                            f[i] = in.getBits(bitsPerColour);
                        }
                        PColorSpace.reverseInPlace(f);
                        colorSpace.normaliseComponentsToFloats(f, ff, maxColourValue);
                        Color color = colorSpace.getColor(ff);
                        imageBits[x] = color.getRGB();
                        continue;
                    }
                    if (colorSpaceCompCount == 4) {
                        for (int i = 0; i < colorSpaceCompCount; ++i) {
                            f[i] = in.getBits(bitsPerColour);
                        }
                        PColorSpace.reverseInPlace(f);
                        colorSpace.normaliseComponentsToFloats(f, ff, maxColourValue);
                        Color color = colorSpace.getColor(ff);
                        imageBits[x] = color.getRGB();
                        continue;
                    }
                    imageBits[x] = alpha << 24 | red << 16 | green << 8 | blue;
                }
                bim.setRGB(0, y, width, 1, imageBits, 0, 1);
            }
            in.close();
            in = null;
            if (smaskImage != null || maskImage != null || maskMinRGB != null || maskMaxRGB != null) {
                WritableRaster wr = bim.getRaster();
                Stream.alterRasterRGBA(wr, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error parsing image.", e);
        }
        return bim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage putIntoImageCache(BufferedImage bim, int width, int height, boolean allowScaling) {
        boolean canScale;
        if (this.image == null) {
            this.image = new ImageCache(this.library);
        }
        boolean setIsScaledOnImageCache = false;
        if (allowScaling && scaleImages && !this.image.isScaled() && (canScale = this.checkMemory(Math.max(width, bim.getWidth()) * Math.max(height, bim.getHeight()) * Math.max(4, bim.getColorModel().getPixelSize())))) {
            bim = ImageCache.scaleBufferedImage(bim, width, height);
            setIsScaledOnImageCache = true;
        }
        Object object = this.imageLock;
        synchronized (object) {
            if (this.image == null) {
                this.image = new ImageCache(this.library);
            }
            if (setIsScaledOnImageCache) {
                this.image.setIsScaled(true);
            }
            this.image.setImage(bim);
            bim = this.image.readImage();
        }
        return bim;
    }

    public boolean isImageMask() {
        Object o = this.library.getObject(this.entries, "ImageMask");
        return o != null ? o.toString().equals("true") : false;
    }

    public boolean getBlackIs1(Library library, Hashtable decodeParmsDictionary) {
        Boolean blackIs1 = this.getBlackIs1OrNull(library, decodeParmsDictionary);
        if (blackIs1 != null) {
            return blackIs1;
        }
        return false;
    }

    public Boolean getBlackIs1OrNull(Library library, Hashtable decodeParmsDictionary) {
        Object blackIs1Obj = library.getObject(decodeParmsDictionary, "BlackIs1");
        if (blackIs1Obj != null) {
            if (blackIs1Obj instanceof Boolean) {
                return (Boolean)blackIs1Obj;
            }
            if (blackIs1Obj instanceof String) {
                String blackIs1String = (String)blackIs1Obj;
                if (blackIs1String.equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                if (blackIs1String.equalsIgnoreCase("t")) {
                    return Boolean.TRUE;
                }
                if (blackIs1String.equals("1")) {
                    return Boolean.TRUE;
                }
                if (blackIs1String.equalsIgnoreCase("false")) {
                    return Boolean.FALSE;
                }
                if (blackIs1String.equalsIgnoreCase("f")) {
                    return Boolean.FALSE;
                }
                if (blackIs1String.equals("0")) {
                    return Boolean.FALSE;
                }
            }
        }
        return null;
    }

    public SeekableInputConstrainedWrapper getStreamInput() {
        return this.streamInput;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("STREAM= ");
        sb.append(this.entries);
        if (this.getPObjectReference() != null) {
            sb.append("  ");
            sb.append(this.getPObjectReference());
        }
        return sb.toString();
    }

    private static double clip(double floor, double ceiling, double value) {
        if (value < floor) {
            value = floor;
        }
        if (value > ceiling) {
            value = ceiling;
        }
        return value;
    }

    private static void displayImage(BufferedImage bufferedImage) {
        int width2 = bufferedImage.getWidth();
        int height2 = bufferedImage.getHeight();
        final BufferedImage bi = bufferedImage;
        final JFrame f = new JFrame("Test");
        f.setDefaultCloseOperation(1);
        JComponent image = new JComponent(){

            public void paint(Graphics g_) {
                super.paint(g_);
                g_.drawImage(bi, 0, 0, f);
            }
        };
        image.setPreferredSize(new Dimension(bi.getWidth(), bi.getHeight()));
        image.setSize(new Dimension(bi.getWidth(), bi.getHeight()));
        JPanel test = new JPanel();
        test.setPreferredSize(new Dimension(1200, 1200));
        JScrollPane tmp = new JScrollPane(image);
        tmp.revalidate();
        f.setSize(new Dimension(800, 800));
        f.getContentPane().add(tmp);
        f.validate();
        f.setVisible(true);
    }

    static {
        redIndex = 0;
        blueIndex = 2;
        scaleImages = Defs.sysPropertyBoolean("org.icepdf.core.scaleImages", true);
        String version = System.getProperty("java.version");
        if (version.contains("1.5")) {
            redIndex = 2;
            blueIndex = 0;
        }
        GRAY_1_BIT_INDEX_TO_RGB_REVERSED = new int[]{-1, -16777216};
        GRAY_1_BIT_INDEX_TO_RGB = new int[]{-16777216, -1};
        GRAY_2_BIT_INDEX_TO_RGB = new int[]{-16777216, -11184811, -5592406, -1};
        GRAY_4_BIT_INDEX_TO_RGB = new int[]{-16777216, -15658735, -14540254, -13421773, -12303292, -11184811, -10066330, -8947849, -7829368, -6710887, -5592406, -4473925, -3355444, -2236963, -1118482, -1};
        JPEG_ENC_NAMES = new String[]{"JPEG_ENC_UNKNOWN_PROBABLY_YCbCr", "JPEG_ENC_RGB", "JPEG_ENC_CMYK", "JPEG_ENC_YCbCr", "JPEG_ENC_YCCK", "JPEG_ENC_GRAY"};
    }
}

