/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.Pattern;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.util.ContentParser;
import org.icepdf.core.util.Library;

public class TilingPattern
extends Stream
implements Pattern {
    private static final Logger logger = Logger.getLogger(TilingPattern.class.toString());
    private int patternType;
    private int paintType;
    private Color unColored;
    public static final int PAINTING_TYPE_COLORED_TILING_PATTERN = 1;
    public static final int PAINTING_TYPE_UNCOLORED_TILING_PATTERN = 2;
    private int tilingType;
    private String type = this.library.getName(this.entries, "Type");
    public static final int TILING_TYPE_CONSTANT_SPACING = 1;
    public static final int TILING_TYPE_NO_DISTORTION = 2;
    public static final int TILING_TYPE_CONSTANT_SPACING_FASTER = 3;
    private Rectangle2D bBox;
    private Rectangle2D bBoxMod;
    private float xStep;
    private float yStep;
    private Resources resources;
    private AffineTransform matrix;
    private Shapes shapes;
    public Color fillColour = null;
    private boolean inited;
    private TexturePaint texturePaint;
    private GraphicsState parentGraphicState;
    private TexturePaint patternPaint;

    public TilingPattern(Stream stream) {
        this(stream.getLibrary(), stream.getEntries(), stream.getStreamInput());
    }

    public TilingPattern(Library l, Hashtable h, SeekableInputConstrainedWrapper streamInputWrapper) {
        super(l, h, streamInputWrapper);
        this.patternType = this.library.getInt(this.entries, "PatternType");
        this.paintType = this.library.getInt(this.entries, "PaintType");
        this.tilingType = this.library.getInt(this.entries, "TilingType");
        this.bBox = this.library.getRectangle(this.entries, "BBox");
        this.xStep = this.library.getFloat(this.entries, "XStep");
        this.yStep = this.library.getFloat(this.entries, "YStep");
        Vector v = (Vector)this.library.getObject(this.entries, "Matrix");
        this.matrix = v != null ? TilingPattern.getAffineTransform(v) : new AffineTransform();
    }

    public String getType() {
        return this.type;
    }

    private static AffineTransform getAffineTransform(Vector v) {
        float[] f = new float[6];
        for (int i = 0; i < 6; ++i) {
            f[i] = ((Number)v.elementAt(i)).floatValue();
        }
        return new AffineTransform(f);
    }

    public Color getFirstColor() {
        if (this.shapes != null && this.unColored == null) {
            int max = this.shapes.shapes.size();
            for (int i = 0; i < max; ++i) {
                if (!(this.shapes.shapes.get(i) instanceof Color)) continue;
                this.unColored = (Color)this.shapes.shapes.get(i);
                return this.unColored;
            }
        }
        if (this.unColored == null) {
            this.unColored = Color.black;
            return this.unColored;
        }
        return this.unColored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        Resources leafResources = this.library.getResources(this.entries, "Resources");
        if (leafResources != null) {
            this.resources = leafResources;
        }
        ContentParser cp = new ContentParser(this.library, leafResources);
        cp.setGraphicsState(this.parentGraphicState);
        InputStream in = this.getInputStreamForDecodedStreamBytes();
        if (in != null) {
            try {
                this.shapes = cp.parse(in);
            }
            catch (Throwable e) {
                logger.log(Level.FINE, "Error processing tiling pattern.", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        if (this.xStep == 32767.0f) {
            this.xStep = (float)this.bBox.getWidth();
        }
        if (this.yStep == 32767.0f) {
            this.yStep = (float)this.bBox.getHeight();
        }
        this.bBoxMod = new Rectangle2D.Double(this.bBox.getX(), this.bBox.getY(), this.bBox.getWidth() == (double)this.xStep ? this.bBox.getWidth() : (double)this.xStep, this.bBox.getHeight() == (double)this.yStep ? this.bBox.getHeight() : (double)this.yStep);
        this.bBoxMod = this.matrix.createTransformedShape(this.bBoxMod).getBounds2D();
    }

    public void paintPattern(Graphics2D g, Page parentPage) {
        if (this.patternPaint == null) {
            int width = (int)this.bBoxMod.getWidth();
            int height = (int)this.bBoxMod.getHeight();
            if (width == 0) {
                width = 1;
            }
            if (height == 0) {
                height = 1;
            }
            BufferedImage bi = new BufferedImage(width, height, 2);
            Graphics2D canvas = bi.createGraphics();
            this.patternPaint = new TexturePaint(bi, this.bBoxMod);
            g.setPaint(this.patternPaint);
            canvas.setRenderingHints(g.getRenderingHints());
            Shapes tilingShapes = this.getShapes();
            canvas.setClip(0, 0, (int)this.bBoxMod.getWidth(), (int)this.bBoxMod.getHeight());
            this.paintPattern(canvas, tilingShapes, this.bBox);
            canvas.dispose();
            bi.flush();
        } else {
            g.setPaint(this.patternPaint);
        }
    }

    private void paintPattern(Graphics2D g2d, Shapes tilingShapes, Rectangle2D bBoxMod) {
        if (tilingShapes == null) {
            return;
        }
        AffineTransform preAf = g2d.getTransform();
        AffineTransform af = g2d.getTransform();
        if (this.matrix.getScaleX() != 0.0 && this.matrix.getScaleY() != 0.0) {
            af.scale(this.matrix.getScaleX(), Math.abs(this.matrix.getScaleY()));
        }
        af.shear(this.matrix.getShearX(), this.matrix.getShearY());
        g2d.transform(af);
        tilingShapes.paint(g2d);
        if (this.matrix.getShearX() > 0.0 || this.matrix.getShearY() > 0.0) {
            g2d.translate(bBoxMod.getWidth(), 0.0);
            tilingShapes.paint(g2d);
            g2d.translate(0.0, -bBoxMod.getHeight());
            tilingShapes.paint(g2d);
            g2d.translate(-bBoxMod.getWidth(), 0.0);
            tilingShapes.paint(g2d);
            g2d.translate(-bBoxMod.getWidth(), 0.0);
            tilingShapes.paint(g2d);
            g2d.translate(0.0, bBoxMod.getHeight());
            tilingShapes.paint(g2d);
            g2d.translate(0.0, bBoxMod.getHeight());
            tilingShapes.paint(g2d);
            g2d.translate(bBoxMod.getWidth(), 0.0);
            tilingShapes.paint(g2d);
            g2d.translate(bBoxMod.getWidth(), 0.0);
            tilingShapes.paint(g2d);
        }
        g2d.setTransform(preAf);
    }

    public Paint getPaint() {
        return this.texturePaint;
    }

    public int getPatternType() {
        return this.patternType;
    }

    public void setPatternType(int patternType) {
        this.patternType = patternType;
    }

    public int getPaintType() {
        return this.paintType;
    }

    public void setPaintType(int paintType) {
        this.paintType = paintType;
    }

    public int getTilingType() {
        return this.tilingType;
    }

    public void setTilingType(int tilingType) {
        this.tilingType = tilingType;
    }

    public Rectangle2D getBBox() {
        return this.bBox;
    }

    public Rectangle2D getbBoxMod() {
        return this.bBoxMod;
    }

    public float getXStep() {
        return this.xStep;
    }

    public float getYStep() {
        return this.yStep;
    }

    public AffineTransform getMatrix() {
        return this.matrix;
    }

    public AffineTransform getInvMatrix() {
        try {
            return this.matrix.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public void setMatrix(AffineTransform matrix) {
        this.matrix = matrix;
    }

    public Shapes getShapes() {
        return this.shapes;
    }

    public void setShapes(Shapes shapes) {
        this.shapes = shapes;
    }

    public void setParentGraphicState(GraphicsState graphicsState) {
        this.parentGraphicState = graphicsState;
    }

    public GraphicsState getParentGraphicState() {
        return this.parentGraphicState;
    }

    public Color getUnColored() {
        return this.unColored;
    }

    public void setUnColored(Color unColored) {
        this.unColored = unColored;
    }

    public String toString() {
        return "Tiling Pattern: \n           type: pattern \n    patternType: tilling\n      paintType: " + (this.paintType == 1 ? "colored" : "uncoloured") + "\n    tilingType: " + this.tilingType + "\n          bbox: " + this.bBox + "\n         xStep: " + this.xStep + "\n         yStep: " + this.yStep + "\n      resource: " + this.resources + "\n        matrix: " + this.matrix;
    }
}

