/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.ICCBased;
import org.icepdf.core.pobjects.graphics.Indexed;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.tag.Tagger;
import org.icepdf.core.util.Defs;

public class ImageUtility {
    private static final Logger logger = Logger.getLogger(ImageUtility.class.toString());
    protected static final int[] GRAY_1_BIT_INDEX_TO_RGB_REVERSED = new int[]{-1, -16777216};
    protected static final int[] GRAY_1_BIT_INDEX_TO_RGB = new int[]{-16777216, -1};
    protected static final int[] GRAY_2_BIT_INDEX_TO_RGB = new int[]{-16777216, -11184811, -5592406, -1};
    protected static final int[] GRAY_4_BIT_INDEX_TO_RGB = new int[]{-16777216, -15658735, -14540254, -13421773, -12303292, -11184811, -10066330, -8947849, -7829368, -6710887, -5592406, -4473925, -3355444, -2236963, -1118482, -1};
    protected static final int JPEG_ENC_UNKNOWN_PROBABLY_YCbCr = 0;
    protected static final int JPEG_ENC_RGB = 1;
    protected static final int JPEG_ENC_CMYK = 2;
    protected static final int JPEG_ENC_YCbCr = 3;
    protected static final int JPEG_ENC_YCCK = 4;
    protected static final int JPEG_ENC_GRAY = 5;
    protected static String[] JPEG_ENC_NAMES = new String[]{"JPEG_ENC_UNKNOWN_PROBABLY_YCbCr", "JPEG_ENC_RGB", "JPEG_ENC_CMYK", "JPEG_ENC_YCbCr", "JPEG_ENC_YCCK", "JPEG_ENC_GRAY"};
    private static float blackRatio;
    private static int redIndex;
    private static int blueIndex;

    protected static BufferedImage alterBufferedImage(BufferedImage bi, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB) {
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        int width = bi.getWidth();
        int height = bi.getHeight();
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
            if (width < smaskWidth || height < smaskHeight) {
                double scaleX = (double)smaskWidth / (double)width;
                double scaleY = (double)smaskHeight / (double)height;
                AffineTransform tx = new AffineTransform();
                tx.scale(scaleX, scaleY);
                AffineTransformOp op = new AffineTransformOp(tx, 1);
                BufferedImage bim = op.filter(bi, null);
                bi.flush();
                bi = bim;
            }
            width = bi.getWidth();
            height = bi.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        int maskMinRed = 255;
        int maskMinGreen = 255;
        int maskMinBlue = 255;
        int maskMaxRed = 0;
        int maskMaxGreen = 0;
        int maskMaxBlue = 0;
        if (maskMinRGB != null && maskMaxRGB != null) {
            maskMinRed = maskMinRGB[0];
            maskMinGreen = maskMinRGB[1];
            maskMinBlue = maskMinRGB[2];
            maskMaxRed = maskMaxRGB[0];
            maskMaxGreen = maskMaxRGB[1];
            maskMaxBlue = maskMaxRGB[2];
        }
        if (smaskRaster == null && maskRaster == null && (maskMinRGB == null || maskMaxRGB == null)) {
            return null;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                boolean gotARBG = false;
                int argb = 0;
                int alpha = 255;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskRaster.getSample(x, y, 0) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                } else {
                    gotARBG = true;
                    argb = bi.getRGB(x, y);
                    int red = argb >> 16 & 0xFF;
                    int green = argb >> 8 & 0xFF;
                    int blue = argb & 0xFF;
                    if (blue >= maskMinBlue && blue <= maskMaxBlue && green >= maskMinGreen && green <= maskMaxGreen && red >= maskMinRed && red <= maskMaxRed) {
                        alpha = 0;
                    }
                }
                if (alpha == 255) continue;
                if (!gotARBG) {
                    argb = bi.getRGB(x, y);
                }
                argb &= 0xFFFFFF;
                bi.setRGB(x, y, argb |= alpha << 24 & 0xFF000000);
            }
        }
        BufferedImage tmpImage = bi;
        if (smaskImage != null) {
            BufferedImage argbImage = new BufferedImage(width, height, 2);
            int[] srcBand = new int[width];
            int[] sMaskBand = new int[width];
            for (int i = 0; i < height; ++i) {
                tmpImage.getRGB(0, i, width, 1, srcBand, 0, width);
                smaskImage.getRGB(0, i, width, 1, sMaskBand, 0, width);
                for (int j = 0; j < width; ++j) {
                    sMaskBand[j] = (sMaskBand[j] & 0xFF) << 24 | srcBand[j] & 0xFFFFFF;
                }
                argbImage.setRGB(0, i, width, 1, sMaskBand, 0, width);
            }
            tmpImage.flush();
            tmpImage = argbImage;
        }
        return tmpImage;
    }

    protected static BufferedImage alterRasterCMYK2BGRA(WritableRaster wr, float[] decode) {
        int width = wr.getWidth();
        int height = wr.getHeight();
        float lastCyan = -1.0f;
        float lastMagenta = -1.0f;
        float lastYellow = -1.0f;
        float lastBlack = -1.0f;
        int rValue = 0;
        int gValue = 0;
        int bValue = 0;
        int alpha = 0;
        int[] values = new int[wr.getNumBands()];
        byte[] dataValues = new byte[wr.getNumBands()];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                byte[] compColors = (byte[])wr.getDataElements(x, y, dataValues);
                ImageUtility.getNormalizedComponents(compColors, decode, values);
                float inCyan = (float)values[0] / 255.0f;
                float inMagenta = (float)values[1] / 255.0f;
                float inYellow = (float)values[2] / 255.0f;
                float inBlack = (float)values[3] / blackRatio;
                if (inCyan != lastCyan || inMagenta != lastMagenta || inYellow != lastYellow || inBlack != lastBlack) {
                    double c = ImageUtility.clip(0.0, 1.0, inCyan + inBlack);
                    double m = ImageUtility.clip(0.0, 1.0, inMagenta + inBlack);
                    double y2 = ImageUtility.clip(0.0, 1.0, inYellow + inBlack);
                    double aw = (1.0 - c) * (1.0 - m) * (1.0 - y2);
                    double ac = c * (1.0 - m) * (1.0 - y2);
                    double am = (1.0 - c) * m * (1.0 - y2);
                    double ay = (1.0 - c) * (1.0 - m) * y2;
                    double ar = (1.0 - c) * m * y2;
                    double ag = c * (1.0 - m) * y2;
                    double ab = c * m * (1.0 - y2);
                    float outRed = (float)ImageUtility.clip(0.0, 1.0, aw + 0.9137 * am + 0.9961 * ay + 0.9882 * ar);
                    float outGreen = (float)ImageUtility.clip(0.0, 1.0, aw + 0.6196 * ac + ay + 0.5176 * ag);
                    float outBlue = (float)ImageUtility.clip(0.0, 1.0, aw + 0.7804 * ac + 0.5412 * am + 0.0667 * ar + 0.2118 * ag + 0.4863 * ab);
                    rValue = (int)(outRed * 255.0f);
                    gValue = (int)(outGreen * 255.0f);
                    bValue = (int)(outBlue * 255.0f);
                    alpha = 255;
                }
                lastCyan = inCyan;
                lastMagenta = inMagenta;
                lastYellow = inYellow;
                lastBlack = inBlack;
                values[ImageUtility.redIndex] = rValue;
                values[1] = gValue;
                values[ImageUtility.blueIndex] = bValue;
                values[3] = alpha;
                wr.setPixel(x, y, values);
            }
        }
        BufferedImage tmpImage = ImageUtility.makeRGBABufferedImage(wr, 3);
        return tmpImage;
    }

    protected static BufferedImage alterRasterCMYK2BGRA(WritableRaster wr) {
        int width = wr.getWidth();
        int height = wr.getHeight();
        float lastCyan = -1.0f;
        float lastMagenta = -1.0f;
        float lastYellow = -1.0f;
        float lastBlack = -1.0f;
        int rValue = 0;
        int gValue = 0;
        int bValue = 0;
        int alpha = 0;
        int[] values = new int[4];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.getPixel(x, y, values);
                float inCyan = (float)values[0] / 255.0f;
                float inMagenta = (float)values[1] / 255.0f;
                float inYellow = (float)values[2] / 255.0f;
                float inBlack = (float)values[3] / blackRatio;
                if (inCyan != lastCyan || inMagenta != lastMagenta || inYellow != lastYellow || inBlack != lastBlack) {
                    double c = ImageUtility.clip(0.0, 1.0, inCyan + inBlack);
                    double m = ImageUtility.clip(0.0, 1.0, inMagenta + inBlack);
                    double y2 = ImageUtility.clip(0.0, 1.0, inYellow + inBlack);
                    double aw = (1.0 - c) * (1.0 - m) * (1.0 - y2);
                    double ac = c * (1.0 - m) * (1.0 - y2);
                    double am = (1.0 - c) * m * (1.0 - y2);
                    double ay = (1.0 - c) * (1.0 - m) * y2;
                    double ar = (1.0 - c) * m * y2;
                    double ag = c * (1.0 - m) * y2;
                    double ab = c * m * (1.0 - y2);
                    float outRed = (float)ImageUtility.clip(0.0, 1.0, aw + 0.9137 * am + 0.9961 * ay + 0.9882 * ar);
                    float outGreen = (float)ImageUtility.clip(0.0, 1.0, aw + 0.6196 * ac + ay + 0.5176 * ag);
                    float outBlue = (float)ImageUtility.clip(0.0, 1.0, aw + 0.7804 * ac + 0.5412 * am + 0.0667 * ar + 0.2118 * ag + 0.4863 * ab);
                    rValue = (int)(outRed * 255.0f);
                    gValue = (int)(outGreen * 255.0f);
                    bValue = (int)(outBlue * 255.0f);
                    alpha = 255;
                }
                lastCyan = inCyan;
                lastMagenta = inMagenta;
                lastYellow = inYellow;
                lastBlack = inBlack;
                values[ImageUtility.redIndex] = rValue;
                values[1] = gValue;
                values[ImageUtility.blueIndex] = bValue;
                values[3] = alpha;
                wr.setPixel(x, y, values);
            }
        }
        BufferedImage tmpImage = ImageUtility.makeRGBABufferedImage(wr, 3);
        return tmpImage;
    }

    private static double clip(double floor, double ceiling, double value) {
        if (value < floor) {
            value = floor;
        }
        if (value > ceiling) {
            value = ceiling;
        }
        return value;
    }

    public static void displayImage(final BufferedImage bufferedImage, final String title) {
        if (bufferedImage == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                final BufferedImage bi = bufferedImage;
                final JFrame f = new JFrame("Image - " + title);
                f.setDefaultCloseOperation(1);
                JComponent image = new JComponent(){

                    public void paint(Graphics g_) {
                        super.paint(g_);
                        g_.drawImage(bi, 0, 0, f);
                    }
                };
                image.setPreferredSize(new Dimension(bi.getWidth(), bi.getHeight()));
                image.setSize(new Dimension(bi.getWidth(), bi.getHeight()));
                JPanel test = new JPanel();
                test.setPreferredSize(new Dimension(1200, 1200));
                JScrollPane tmp = new JScrollPane(image);
                tmp.revalidate();
                f.setSize(new Dimension(800, 800));
                f.getContentPane().add(tmp);
                f.validate();
                f.setVisible(true);
            }
        });
    }

    protected static BufferedImage makeRGBABufferedImage(WritableRaster wr) {
        return ImageUtility.makeRGBABufferedImage(wr, 1);
    }

    protected static BufferedImage makeRGBABufferedImage(WritableRaster wr, int transparency) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[4];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = 8;
        }
        ComponentColorModel cm = new ComponentColorModel(cs, bits, true, false, transparency, wr.getTransferType());
        return new BufferedImage(cm, wr, false, null);
    }

    protected static BufferedImage makeRGBtoRGBABuffer(WritableRaster wr, int width, int height) {
        BufferedImage tmpImage = ImageUtility.makeRGBBufferedImage(wr);
        BufferedImage argbImage = new BufferedImage(width, height, 2);
        int[] srcBand = new int[width];
        int[] argbBand = new int[width];
        for (int i = 0; i < height; ++i) {
            tmpImage.getRGB(0, i, width, 1, srcBand, 0, width);
            for (int j = 0; j < width; ++j) {
                int r = srcBand[j] >> 16 & 0xFF;
                int g = srcBand[j] >> 8 & 0xFF;
                int b = srcBand[j] & 0xFF;
                argbBand[j] = 0xFF000000 | r << 16 | g << 8 | b;
            }
            argbImage.setRGB(0, i, width, 1, argbBand, 0, width);
        }
        tmpImage.flush();
        return argbImage;
    }

    protected static BufferedImage makeRGBBufferedImage(WritableRaster wr) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[3];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = 8;
        }
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, wr.getTransferType());
        return new BufferedImage(cm, wr, false, null);
    }

    protected static BufferedImage makeGrayBufferedImage(WritableRaster wr) {
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[1];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = 8;
        }
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, wr.getTransferType());
        return new BufferedImage(cm, wr, false, null);
    }

    protected static BufferedImage makeRGBBufferedImage(WritableRaster wr, float[] decode, PColorSpace colorSpace) {
        int width = wr.getWidth();
        int height = wr.getHeight();
        BufferedImage rgbImage = new BufferedImage(width, height, 1);
        WritableRaster rgbRaster = rgbImage.getRaster();
        float[] values = new float[colorSpace.getNumComponents()];
        int[] rgbValues = new int[4];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                ImageUtility.getNormalizedComponents((byte[])wr.getDataElements(x, y, null), decode, rgbValues);
                colorSpace.normaliseComponentsToFloats(rgbValues, values, 255.0f);
                Color c = colorSpace.getColor(values);
                rgbValues[0] = c.getRed();
                rgbValues[1] = c.getGreen();
                rgbValues[2] = c.getBlue();
                rgbRaster.setPixel(x, y, rgbValues);
            }
        }
        return rgbImage;
    }

    protected static BufferedImage makeRGBABufferedImageFromImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtility.hasAlpha(image);
        BufferedImage bImage = null;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if (width == -1 || height == -1) {
                return null;
            }
            bImage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            // empty catch block
        }
        if (bImage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if (width == -1 || height == -1) {
                return null;
            }
            bImage = new BufferedImage(width, height, type);
        }
        Graphics2D g = bImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        image.flush();
        return bImage;
    }

    protected static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = pixelGrabber.getColorModel();
        return cm == null || cm.hasAlpha();
    }

    protected static void alterRasterYCCK2CMYK(WritableRaster wr, float[] decode) {
        float[] origValues = new float[wr.getNumBands()];
        double[] pixels = new double[4];
        double lastY = -1.0;
        double lastCb = -1.0;
        double lastCr = -1.0;
        double lastK = -1.0;
        double c = 0.0;
        double m = 0.0;
        double y2 = 0.0;
        double k = 0.0;
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                ImageUtility.getNormalizedComponents((byte[])wr.getDataElements(x, y, null), decode, origValues);
                double Y = origValues[0] * 255.0f;
                double Cb = origValues[1] * 255.0f;
                double Cr = origValues[2] * 255.0f;
                double K = origValues[3] * 255.0f;
                if (lastY != (double)y || lastCb != Cb || lastCr != Cr || lastK != K) {
                    c = 255.0 - (Y + 1.402 * Cr - 179.456);
                    m = 255.0 - (Y - 0.34414 * Cb - 0.71413636 * Cr + 135.45984);
                    y2 = 255.0 - (Y + 1.7718 * Cb - 226.816);
                    k = K;
                    c = ImageUtility.clip(0.0, 255.0, c);
                    m = ImageUtility.clip(0.0, 255.0, m);
                    y2 = ImageUtility.clip(0.0, 255.0, y2);
                }
                lastY = Y;
                lastCb = Cb;
                lastCr = Cr;
                lastK = K;
                pixels[0] = c;
                pixels[1] = m;
                pixels[2] = y2;
                pixels[3] = k;
                wr.setPixel(x, y, pixels);
            }
        }
    }

    protected static void getNormalizedComponents(byte[] pixels, float[] decode, float[] out) {
        for (int i = 0; i < pixels.length; ++i) {
            out[i] = decode[i * 2] + (float)(pixels[i] & 0xFF) * decode[i * 2 + 1];
        }
    }

    protected static void getNormalizedComponents(byte[] pixels, float[] decode, int[] out) {
        for (int i = 0; i < pixels.length; ++i) {
            out[i] = (int)(decode[i * 2] * 255.0f + (float)(pixels[i] & 0xFF) * (decode[i * 2 + 1] * 255.0f));
        }
    }

    protected static void alterRasterRGB2PColorSpace(WritableRaster wr, PColorSpace colorSpace) {
        if (colorSpace instanceof DeviceRGB) {
            return;
        }
        float[] values = new float[3];
        int[] rgbValues = new int[3];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.getPixel(x, y, rgbValues);
                PColorSpace.reverseInPlace(rgbValues);
                colorSpace.normaliseComponentsToFloats(rgbValues, values, 255.0f);
                Color c = colorSpace.getColor(values);
                rgbValues[0] = c.getRed();
                rgbValues[1] = c.getGreen();
                rgbValues[2] = c.getBlue();
                wr.setPixel(x, y, rgbValues);
            }
        }
    }

    protected static WritableRaster alterRasterRGBA(WritableRaster wr, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB) {
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        int maskMinRed = 255;
        int maskMinGreen = 255;
        int maskMinBlue = 255;
        int maskMaxRed = 0;
        int maskMaxGreen = 0;
        int maskMaxBlue = 0;
        if (maskMinRGB != null && maskMaxRGB != null) {
            maskMinRed = maskMinRGB[0];
            maskMinGreen = maskMinRGB[1];
            maskMinBlue = maskMinRGB[2];
            maskMaxRed = maskMaxRGB[0];
            maskMaxGreen = maskMaxRGB[1];
            maskMaxBlue = maskMaxRGB[2];
        }
        if (smaskRaster == null && maskRaster == null && (maskMinRGB == null || maskMaxRGB == null)) {
            return null;
        }
        int[] rgbaValues = new int[4];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.getPixel(x, y, rgbaValues);
                int red = rgbaValues[0];
                int green = rgbaValues[1];
                int blue = rgbaValues[2];
                int alpha = 255;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskImage.getRGB(x, y) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                } else if (blue >= maskMinBlue && blue <= maskMaxBlue && green >= maskMinGreen && green <= maskMaxGreen && red >= maskMinRed && red <= maskMaxRed) {
                    alpha = 0;
                }
                if (alpha == 255) continue;
                rgbaValues[3] = alpha;
                wr.setPixel(x, y, rgbaValues);
            }
        }
        return wr;
    }

    protected static void alterRasterY2Gray(WritableRaster wr, float[] decode) {
        int[] values = new int[1];
        int width = wr.getWidth();
        int height = wr.getHeight();
        boolean defaultDecode = 0.0f == decode[0];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.getPixel(x, y, values);
                int Y = values[0];
                int n = Y = defaultDecode ? 255 - Y : Y;
                values[0] = Y = (byte)(Y < 0 ? 0 : (byte)(Y > 255 ? -1 : (byte)Y));
                wr.setPixel(x, y, values);
            }
        }
    }

    protected static BufferedImage alterRasterYCbCr2RGBA(WritableRaster wr, float[] decode) {
        byte[] dataValues = new byte[wr.getNumBands()];
        float[] values = new float[wr.getNumBands()];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int gByte;
                int rByte;
                byte[] compColors = (byte[])wr.getDataElements(x, y, dataValues);
                ImageUtility.getNormalizedComponents(compColors, decode, values);
                float Y = values[0] * 255.0f;
                float Cb = values[1] * 255.0f;
                float Cr = values[2] * 255.0f;
                float Cr_128 = Cr - 128.0f;
                float Cb_128 = Cb - 128.0f;
                float rVal = Y + 1370705.0f * Cr_128 / 1000000.0f;
                float gVal = Y - 337633.0f * Cb_128 / 1000000.0f - 698001.0f * Cr_128 / 1000000.0f;
                float bVal = Y + 1732446.0f * Cb_128 / 1000000.0f;
                byte by = (byte)(rVal < 0.0f ? 0 : (byte)(rByte = (byte)(rVal > 255.0f ? -1 : (byte)rVal)));
                byte by2 = (byte)(gVal < 0.0f ? 0 : (byte)(gByte = (byte)(gVal > 255.0f ? -1 : (byte)gVal)));
                int bByte = (byte)(bVal < 0.0f ? 0 : (byte)(bVal > 255.0f ? -1 : (byte)bVal));
                values[0] = rByte;
                values[1] = gByte;
                values[2] = bByte;
                wr.setPixel(x, y, values);
            }
        }
        BufferedImage tmpImage = ImageUtility.makeRGBtoRGBABuffer(wr, width, height);
        return tmpImage;
    }

    protected static void alterRasterYCCK2BGRA(WritableRaster wr, BufferedImage smaskImage, BufferedImage maskImage, float[] decode, int bitsPerComponent) {
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        byte[] dataValues = new byte[wr.getNumBands()];
        float[] origValues = new float[wr.getNumBands()];
        double[] rgbaValues = new double[4];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int gByte;
                int rByte;
                ImageUtility.getNormalizedComponents((byte[])wr.getDataElements(x, y, dataValues), decode, origValues);
                float Y = origValues[0] * 255.0f;
                float Cb = origValues[1] * 255.0f;
                float Cr = origValues[2] * 255.0f;
                float Cr_128 = Cr - 128.0f;
                float Cb_128 = Cb - 128.0f;
                double rVal = (double)Y + 1.402 * (double)Cr_128;
                double gVal = (double)Y + 0.14414 * (double)Cb_128 + 0.11413636 * (double)Cr_128;
                double bVal = (double)Y + 1.772 * (double)Cb_128;
                byte by = (byte)(rVal < 0.0 ? 0 : (byte)(rByte = (byte)(rVal > 255.0 ? -1 : (byte)rVal)));
                byte by2 = (byte)(gVal < 0.0 ? 0 : (byte)(gByte = (byte)(gVal > 255.0 ? -1 : (byte)gVal)));
                int bByte = (byte)(bVal < 0.0 ? 0 : (byte)(bVal > 255.0 ? -1 : (byte)bVal));
                int alpha = 255;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskRaster.getSample(x, y, 0) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                }
                rgbaValues[0] = bByte;
                rgbaValues[1] = gByte;
                rgbaValues[2] = rByte;
                rgbaValues[3] = alpha;
                wr.setPixel(x, y, rgbaValues);
            }
        }
    }

    protected static void alterRasterYCbCrA2RGBA(WritableRaster wr) {
        float[] origValues = new float[4];
        int[] rgbaValues = new int[4];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int gByte;
                int rByte;
                wr.getPixel(x, y, origValues);
                float Y = origValues[0];
                float Cb = origValues[1];
                float Cr = origValues[2];
                float K = origValues[3];
                Y = K - Y;
                float Cr_128 = Cr - 128.0f;
                float Cb_128 = Cb - 128.0f;
                float rVal = Y + 1370705.0f * Cr_128 / 1000000.0f;
                float gVal = Y - 337633.0f * Cb_128 / 1000000.0f - 698001.0f * Cr_128 / 1000000.0f;
                float bVal = Y + 1732446.0f * Cb_128 / 1000000.0f;
                byte by = (byte)(rVal < 0.0f ? 0 : (byte)(rByte = (byte)(rVal > 255.0f ? -1 : (byte)rVal)));
                byte by2 = (byte)(gVal < 0.0f ? 0 : (byte)(gByte = (byte)(gVal > 255.0f ? -1 : (byte)gVal)));
                int bByte = (byte)(bVal < 0.0f ? 0 : (byte)(bVal > 255.0f ? -1 : (byte)bVal));
                float alpha = K;
                rgbaValues[0] = rByte;
                rgbaValues[1] = gByte;
                rgbaValues[2] = bByte;
                rgbaValues[3] = (int)alpha;
                wr.setPixel(x, y, rgbaValues);
            }
        }
    }

    protected static BufferedImage applyExplicitMask(BufferedImage baseImage, BufferedImage maskImage) {
        int baseWidth = baseImage.getWidth();
        int baseHeight = baseImage.getHeight();
        int maskWidth = maskImage.getWidth();
        int maskHeight = maskImage.getHeight();
        if (baseWidth != maskWidth || baseHeight != maskHeight) {
            double scaleX = (double)maskWidth / (double)baseWidth;
            double scaleY = (double)maskHeight / (double)baseHeight;
            AffineTransform tx = new AffineTransform();
            tx.scale(scaleX, scaleY);
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            BufferedImage sbim = op.filter(baseImage, null);
            baseImage.flush();
            baseImage = sbim;
        }
        baseWidth = baseImage.getWidth();
        baseHeight = baseImage.getHeight();
        BufferedImage argbImage = new BufferedImage(baseWidth, baseHeight, 2);
        int[] srcBand = new int[baseWidth];
        int[] maskBnd = new int[baseWidth];
        for (int i = 0; i < baseHeight; ++i) {
            baseImage.getRGB(0, i, baseWidth, 1, srcBand, 0, baseWidth);
            maskImage.getRGB(0, i, baseWidth, 1, maskBnd, 0, baseWidth);
            for (int j = 0; j < baseWidth; ++j) {
                maskBnd[j] = maskBnd[j] == 0 || maskBnd[j] == 0xFFFFFF ? 255 : srcBand[j];
            }
            argbImage.setRGB(0, i, baseWidth, 1, maskBnd, 0, baseWidth);
        }
        baseImage.flush();
        baseImage = argbImage;
        return baseImage;
    }

    protected static BufferedImage applyExplicitSMask(BufferedImage baseImage, BufferedImage sMaskImage) {
        int baseWidth = baseImage.getWidth();
        int baseHeight = baseImage.getHeight();
        int maskWidth = sMaskImage.getWidth();
        int maskHeight = sMaskImage.getHeight();
        if (baseWidth != maskWidth || baseHeight != maskHeight) {
            double scaleX = (double)maskWidth / (double)baseWidth;
            double scaleY = (double)maskHeight / (double)baseHeight;
            AffineTransform tx = new AffineTransform();
            tx.scale(scaleX, scaleY);
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            BufferedImage sbim = op.filter(baseImage, null);
            baseImage.flush();
            baseImage = sbim;
        }
        baseWidth = baseImage.getWidth();
        baseHeight = baseImage.getHeight();
        BufferedImage argbImage = new BufferedImage(baseWidth, baseHeight, 2);
        int[] srcBand = new int[baseWidth];
        int[] sMaskBand = new int[baseWidth];
        for (int i = 0; i < baseHeight; ++i) {
            baseImage.getRGB(0, i, baseWidth, 1, srcBand, 0, baseWidth);
            sMaskImage.getRGB(0, i, baseWidth, 1, sMaskBand, 0, baseWidth);
            for (int j = 0; j < baseWidth; ++j) {
                if (sMaskBand[j] == -1 && sMaskBand[j] == 0xFFFFFF && sMaskBand[j] == 0) continue;
                sMaskBand[j] = (sMaskBand[j] & 0xFF) << 24 | srcBand[j] & 0xFFFFFF;
            }
            argbImage.setRGB(0, i, baseWidth, 1, sMaskBand, 0, baseWidth);
        }
        baseImage.flush();
        baseImage = argbImage;
        return baseImage;
    }

    protected static BufferedImage applyExplicitMask(BufferedImage baseImage, Color fill) {
        int baseWidth = baseImage.getWidth();
        int baseHeight = baseImage.getHeight();
        BufferedImage imageMask = new BufferedImage(baseWidth, baseHeight, 2);
        for (int y = 0; y < baseHeight; ++y) {
            for (int x = 0; x < baseWidth; ++x) {
                int maskPixel = baseImage.getRGB(x, y);
                if (maskPixel == -1 || maskPixel == 0xFFFFFF) continue;
                imageMask.setRGB(x, y, fill.getRGB());
            }
        }
        baseImage.flush();
        return imageMask;
    }

    protected static BufferedImage applyIndexColourModel(BufferedImage image, int width, int height, PColorSpace colourSpace, int bitspercomponent) {
        int i;
        colourSpace.init();
        Color[] colors = ((Indexed)colourSpace).accessColorTable();
        int colorsLength = colors == null ? 0 : colors.length;
        int[] cmap = new int[256];
        for (i = 0; i < colorsLength; ++i) {
            if (colors == null) continue;
            cmap[i] = colors[i].getRGB();
        }
        for (i = colorsLength; i < cmap.length; ++i) {
            cmap[i] = -16777216;
        }
        DataBuffer db = image.getRaster().getDataBuffer();
        PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), width, height, 1, width, new int[]{0});
        WritableRaster wr = Raster.createWritableRaster(sm, db, new Point(0, 0));
        IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, false, -1, db.getDataType());
        BufferedImage img = new BufferedImage(cm, wr, false, null);
        return img;
    }

    protected static int getJPEGEncoding(byte[] data, int dataLength) {
        int jpegEncoding = 0;
        boolean foundAPP14 = false;
        int compsTypeFromAPP14 = 0;
        boolean foundSOF = false;
        int numCompsFromSOF = 0;
        boolean foundSOS = false;
        int numCompsFromSOS = 0;
        int index = 0;
        while (!(index >= dataLength || data[index] != -1 || foundAPP14 && foundSOF)) {
            byte segmentType = data[index + 1];
            index += 2;
            if (segmentType == -40) continue;
            int length = (data[index] << 8 & 0xFF00) + (data[index + 1] & 0xFF);
            if (segmentType == -18) {
                if (length >= 14) {
                    foundAPP14 = true;
                    compsTypeFromAPP14 = data[index + 13];
                }
            } else if (segmentType == -64) {
                foundSOF = true;
                numCompsFromSOF = data[index + 7] & 0xFF;
            } else if (segmentType == -38) {
                foundSOS = true;
                numCompsFromSOS = data[index + 2] & 0xFF;
            }
            index += length;
        }
        if (foundAPP14 && foundSOF) {
            if (compsTypeFromAPP14 == 0) {
                if (numCompsFromSOF == 1) {
                    jpegEncoding = 5;
                }
                if (numCompsFromSOF == 3) {
                    jpegEncoding = 1;
                } else if (numCompsFromSOF == 4) {
                    jpegEncoding = 2;
                }
            } else if (compsTypeFromAPP14 == 1) {
                jpegEncoding = 3;
            } else if (compsTypeFromAPP14 == 2) {
                jpegEncoding = 4;
            }
        } else if (foundSOS && numCompsFromSOS == 1) {
            jpegEncoding = 5;
        }
        return jpegEncoding;
    }

    protected static BufferedImage makeImageWithRasterFromBytes(PColorSpace colourSpace, Color fill, int width, int height, int colorSpaceCompCount, int bitspercomponent, boolean imageMask, float[] decode, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB, int maskMinIndex, int maskMaxIndex, byte[] data, int dataLength) {
        ICCBased iccBased;
        BufferedImage img = null;
        if (colourSpace instanceof ICCBased && (iccBased = (ICCBased)colourSpace).getAlternate() != null) {
            colourSpace = iccBased.getAlternate();
        }
        if (colourSpace instanceof DeviceGray) {
            DataBufferByte db;
            if (imageMask && bitspercomponent == 1) {
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_DeviceGray_1_ImageMask");
                }
                db = new DataBufferByte(data, dataLength);
                WritableRaster wr = Raster.createPackedRaster(db, width, height, bitspercomponent, new Point(0, 0));
                boolean defaultDecode = decode[0] == 0.0f;
                int a = 0xFFFFFF;
                int[] cmap = new int[]{defaultDecode ? fill.getRGB() : a, defaultDecode ? a : fill.getRGB()};
                int transparentIndex = defaultDecode ? 1 : 0;
                IndexColorModel icm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, true, transparentIndex, db.getDataType());
                img = new BufferedImage(icm, wr, false, null);
            } else if (bitspercomponent == 1 || bitspercomponent == 2 || bitspercomponent == 4) {
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_DeviceGray_124");
                }
                db = new DataBufferByte(data, dataLength);
                WritableRaster wr = Raster.createPackedRaster(db, width, height, bitspercomponent, new Point(0, 0));
                int[] cmap = null;
                if (bitspercomponent == 1) {
                    boolean defaultDecode = 0.0f == decode[0];
                    cmap = defaultDecode ? GRAY_1_BIT_INDEX_TO_RGB : GRAY_1_BIT_INDEX_TO_RGB_REVERSED;
                } else if (bitspercomponent == 2) {
                    cmap = GRAY_2_BIT_INDEX_TO_RGB;
                } else if (bitspercomponent == 4) {
                    cmap = GRAY_4_BIT_INDEX_TO_RGB;
                }
                IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, false, -1, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
            } else if (bitspercomponent == 8) {
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_DeviceGray_8");
                }
                db = new DataBufferByte(data, dataLength);
                PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), width, height, 1, width, new int[]{0});
                WritableRaster wr = Raster.createWritableRaster(sm, db, new Point(0, 0));
                byte[] dataValues = new byte[sm.getNumBands()];
                float[] origValues = new float[sm.getNumBands()];
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        ImageUtility.getNormalizedComponents((byte[])wr.getDataElements(x, y, dataValues), decode, origValues);
                        float gray = origValues[0] * 255.0f;
                        int rByte = (byte)(gray < 0.0f ? 0 : (byte)(gray > 255.0f ? -1 : (byte)gray));
                        origValues[0] = rByte;
                        wr.setPixel(x, y, origValues);
                    }
                }
                ColorSpace cs = ColorSpace.getInstance(1003);
                ComponentColorModel cm = new ComponentColorModel(cs, new int[]{bitspercomponent}, false, false, 1, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
            }
            if (maskImage != null) {
                img = ImageUtility.applyExplicitMask(img, maskImage);
            }
            if (smaskImage != null) {
                img = ImageUtility.applyExplicitSMask(img, smaskImage);
            }
        } else if (colourSpace instanceof DeviceRGB) {
            if (bitspercomponent == 8) {
                boolean usingAlpha;
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_DeviceRGB_8");
                }
                boolean bl = usingAlpha = smaskImage != null || maskImage != null || maskMinRGB != null && maskMaxRGB != null;
                if (Tagger.tagging) {
                    Tagger.tagImage("RasterFromBytes_DeviceRGB_8_alpha=" + usingAlpha);
                }
                int type = usingAlpha ? 2 : 1;
                img = new BufferedImage(width, height, type);
                int[] dataToRGB = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
                ImageUtility.copyDecodedStreamBytesIntoRGB(data, dataToRGB);
                if (usingAlpha) {
                    ImageUtility.alterBufferedImage(img, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
                }
            }
        } else if (!(colourSpace instanceof DeviceCMYK) && colourSpace instanceof Indexed) {
            Color[] colors;
            if (bitspercomponent == 1 || bitspercomponent == 2 || bitspercomponent == 4) {
                boolean usingAlpha;
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_Indexed_124");
                }
                colourSpace.init();
                colors = ((Indexed)colourSpace).accessColorTable();
                int[] cmap = new int[colors == null ? 0 : colors.length];
                for (int i = 0; i < cmap.length; ++i) {
                    cmap[i] = colors[i].getRGB();
                }
                int cmapMaxLength = 1 << bitspercomponent;
                if (cmap.length > cmapMaxLength) {
                    int[] cmapTruncated = new int[cmapMaxLength];
                    System.arraycopy(cmap, 0, cmapTruncated, 0, cmapMaxLength);
                    cmap = cmapTruncated;
                }
                boolean usingIndexedAlpha = maskMinIndex >= 0 && maskMaxIndex >= 0;
                boolean bl = usingAlpha = smaskImage != null || maskImage != null || maskMinRGB != null && maskMaxRGB != null;
                if (Tagger.tagging) {
                    Tagger.tagImage("RasterFromBytes_Indexed_124_alpha=" + (usingIndexedAlpha ? "indexed" : (usingAlpha ? "alpha" : "false")));
                }
                if (usingAlpha) {
                    DataBufferByte db = new DataBufferByte(data, dataLength);
                    WritableRaster wr = Raster.createPackedRaster(db, width, height, bitspercomponent, new Point(0, 0));
                    IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, false, -1, db.getDataType());
                    img = new BufferedImage(cm, wr, false, null);
                    img = ImageUtility.alterBufferedImage(img, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
                } else {
                    DataBufferByte db = new DataBufferByte(data, dataLength);
                    WritableRaster wr = Raster.createPackedRaster(db, width, height, bitspercomponent, new Point(0, 0));
                    IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, false, -1, db.getDataType());
                    img = new BufferedImage(cm, wr, false, null);
                }
            } else if (bitspercomponent == 8) {
                boolean usingAlpha;
                int i;
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_Indexed_8");
                }
                colourSpace.init();
                colors = ((Indexed)colourSpace).accessColorTable();
                int colorsLength = colors == null ? 0 : colors.length;
                int[] cmap = new int[256];
                for (i = 0; i < colorsLength; ++i) {
                    cmap[i] = colors[i].getRGB();
                }
                for (i = colorsLength; i < cmap.length; ++i) {
                    cmap[i] = -16777216;
                }
                boolean usingIndexedAlpha = maskMinIndex >= 0 && maskMaxIndex >= 0;
                boolean bl = usingAlpha = smaskImage != null || maskImage != null || maskMinRGB != null && maskMaxRGB != null;
                if (Tagger.tagging) {
                    Tagger.tagImage("RasterFromBytes_Indexed_8_alpha=" + (usingIndexedAlpha ? "indexed" : (usingAlpha ? "alpha" : "false")));
                }
                if (usingIndexedAlpha) {
                    for (int i2 = maskMinIndex; i2 <= maskMaxIndex; ++i2) {
                        cmap[i2] = 0;
                    }
                    DataBufferByte db = new DataBufferByte(data, dataLength);
                    PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), width, height, 1, width, new int[]{0});
                    WritableRaster wr = Raster.createWritableRaster(sm, db, new Point(0, 0));
                    IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, true, -1, db.getDataType());
                    img = new BufferedImage(cm, wr, false, null);
                } else if (usingAlpha) {
                    int[] rgbaData = new int[width * height];
                    for (int index = 0; index < dataLength; ++index) {
                        int cmapIndex = data[index] & 0xFF;
                        rgbaData[index] = cmap[cmapIndex];
                    }
                    DataBufferInt db = new DataBufferInt(rgbaData, rgbaData.length);
                    int[] masks = new int[]{0xFF0000, 65280, 255, -16777216};
                    WritableRaster wr = Raster.createPackedRaster(db, width, height, width, masks, new Point(0, 0));
                    ImageUtility.alterRasterRGBA(wr, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
                    ColorSpace cs = ColorSpace.getInstance(1000);
                    DirectColorModel cm = new DirectColorModel(cs, 32, 0xFF0000, 65280, 255, -16777216, false, db.getDataType());
                    img = new BufferedImage(cm, wr, false, null);
                } else {
                    DataBufferByte db = new DataBufferByte(data, dataLength);
                    PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), width, height, 1, width, new int[]{0});
                    WritableRaster wr = Raster.createWritableRaster(sm, db, new Point(0, 0));
                    IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, false, -1, db.getDataType());
                    img = new BufferedImage(cm, wr, false, null);
                }
            }
        }
        return img;
    }

    private static void copyDecodedStreamBytesIntoRGB(byte[] data, int[] pixels) {
        byte[] rgb = new byte[3];
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(data);
            for (int pixelIndex = 0; pixelIndex < pixels.length; ++pixelIndex) {
                int haveRead;
                int currRead;
                int argb = -16777216;
                int toRead = 3;
                for (haveRead = 0; haveRead < 3 && (currRead = ((InputStream)input).read(rgb, haveRead, 3 - haveRead)) >= 0; haveRead += currRead) {
                }
                if (haveRead >= 1) {
                    argb |= rgb[0] << 16 & 0xFF0000;
                }
                if (haveRead >= 2) {
                    argb |= rgb[1] << 8 & 0xFF00;
                }
                if (haveRead >= 3) {
                    argb |= rgb[2] & 0xFF;
                }
                pixels[pixelIndex] = argb;
            }
            ((InputStream)input).close();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem copying decoding stream bytes: ", e);
        }
    }

    public static BufferedImage createBufferedImage(Image imageIn) {
        return ImageUtility.createBufferedImage(imageIn, 2);
    }

    public static BufferedImage createBufferedImage(Image imageIn, int imageType) {
        BufferedImage bufferedImageOut = new BufferedImage(imageIn.getWidth(null), imageIn.getHeight(null), imageType);
        Graphics g = bufferedImageOut.getGraphics();
        g.drawImage(imageIn, 0, 0, null);
        return bufferedImageOut;
    }

    static {
        redIndex = 0;
        blueIndex = 2;
        String version = System.getProperty("java.version");
        if (version.contains("1.5")) {
            redIndex = 2;
            blueIndex = 0;
        }
        blackRatio = Defs.intProperty("org.icepdf.core.cmyk.image.black", 255);
    }
}

