/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.filters;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.InflaterInputStream;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.filters.ChunkingInputStream;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

public class FlateDecode
extends ChunkingInputStream {
    private static int DEFAULT_BUFFER_SIZE = Defs.sysPropertyInt("org.icepdf.core.flateDecode.bufferSize", 16384);
    private static final int LZW_FLATE_PREDICTOR_NONE = 1;
    private static final int LZW_FLATE_PREDICTOR_TIFF_2 = 2;
    private static final int LZW_FLATE_PREDICTOR_PNG_NONE = 10;
    private static final int LZW_FLATE_PREDICTOR_PNG_SUB = 11;
    private static final int LZW_FLATE_PREDICTOR_PNG_UP = 12;
    private static final int LZW_FLATE_PREDICTOR_PNG_AVG = 13;
    private static final int LZW_FLATE_PREDICTOR_PNG_PAETH = 14;
    private static final int LZW_FLATE_PREDICTOR_PNG_OPTIMUM = 15;
    public static final Name DECODE_PARMS_VALUE = new Name("DecodeParms");
    public static final Name PREDICTOR_VALUE = new Name("Predictor");
    public static final Name WIDTH_VALUE = new Name("Width");
    public static final Name COLUMNS_VALUE = new Name("Columns");
    public static final Name COLORS_VALUE = new Name("Colors");
    public static final Name BITS_PER_COMPONENT_VALUE = new Name("BitsPerComponent");
    private InputStream originalInputKeptSolelyForDebugging;
    private int width;
    private int numComponents;
    private int bitsPerComponent;
    private int bpp = 1;
    private int predictor;
    private byte[] aboveBuffer;

    public FlateDecode(Library library, HashMap props, InputStream input) {
        this.originalInputKeptSolelyForDebugging = input;
        this.width = 0;
        this.numComponents = 0;
        this.bitsPerComponent = 0;
        this.bpp = 1;
        int intermediateBufferSize = DEFAULT_BUFFER_SIZE;
        HashMap decodeParmsDictionary = library.getDictionary(props, DECODE_PARMS_VALUE);
        this.predictor = library.getInt(decodeParmsDictionary, PREDICTOR_VALUE);
        if (this.predictor != 1 && this.predictor != 2 && this.predictor != 10 && this.predictor != 11 && this.predictor != 12 && this.predictor != 13 && this.predictor != 14 && this.predictor != 15) {
            this.predictor = 1;
        }
        if (this.predictor != 1) {
            Object bitsPerComponentDecodeParmsObj;
            Number widthNumber = library.getNumber(props, WIDTH_VALUE);
            this.width = widthNumber != null ? widthNumber.intValue() : library.getInt(decodeParmsDictionary, COLUMNS_VALUE);
            this.numComponents = 1;
            this.bitsPerComponent = 8;
            Object numComponentsDecodeParmsObj = library.getObject(decodeParmsDictionary, COLORS_VALUE);
            if (numComponentsDecodeParmsObj instanceof Number) {
                this.numComponents = ((Number)numComponentsDecodeParmsObj).intValue();
            }
            if ((bitsPerComponentDecodeParmsObj = library.getObject(decodeParmsDictionary, BITS_PER_COMPONENT_VALUE)) instanceof Number) {
                this.bitsPerComponent = ((Number)bitsPerComponentDecodeParmsObj).intValue();
            }
            this.bpp = Math.max(1, Utils.numBytesToHoldBits(this.numComponents * this.bitsPerComponent));
            intermediateBufferSize = Utils.numBytesToHoldBits(this.width * this.numComponents * this.bitsPerComponent);
        }
        this.setInputStream(new InflaterInputStream(input));
        this.setBufferSize(intermediateBufferSize);
        this.aboveBuffer = new byte[intermediateBufferSize];
    }

    protected int fillInternalBuffer() throws IOException {
        byte[] temp = this.aboveBuffer;
        this.aboveBuffer = this.buffer;
        this.buffer = temp;
        if (this.predictor == 1) {
            int numRead = this.fillBufferFromInputStream();
            if (numRead <= 0) {
                return -1;
            }
            return numRead;
        }
        if (this.predictor == 2) {
            int numRead = this.fillBufferFromInputStream();
            if (numRead <= 0) {
                return -1;
            }
            if (this.bitsPerComponent == 8) {
                for (int i = 0; i < numRead; ++i) {
                    int prevIndex = i - this.numComponents;
                    if (prevIndex < 0) continue;
                    int n = i;
                    this.buffer[n] = (byte)(this.buffer[n] + this.buffer[prevIndex]);
                }
            }
            return numRead;
        }
        if (this.predictor >= 10 && this.predictor <= 15) {
            int currPredictor = this.predictor;
            int cp = this.in.read();
            if (cp < 0) {
                return -1;
            }
            currPredictor = cp + 10;
            int numRead = this.fillBufferFromInputStream();
            if (numRead <= 0) {
                return -1;
            }
            for (int i = 0; i < numRead && currPredictor != 10; ++i) {
                int above;
                int left;
                if (currPredictor == 11) {
                    if (i - this.bpp < 0) continue;
                    int n = i;
                    this.buffer[n] = (byte)(this.buffer[n] + this.buffer[i - this.bpp]);
                    continue;
                }
                if (currPredictor == 12) {
                    if (this.aboveBuffer == null) continue;
                    int n = i;
                    this.buffer[n] = (byte)(this.buffer[n] + this.aboveBuffer[i]);
                    continue;
                }
                if (currPredictor == 13) {
                    left = 0;
                    if (i - this.bpp >= 0) {
                        left = this.buffer[i - this.bpp] & 0xFF;
                    }
                    above = 0;
                    if (this.aboveBuffer != null) {
                        above = this.aboveBuffer[i] & 0xFF;
                    }
                    int sum = left + above;
                    byte avg = (byte)(sum >>> 1 & 0xFF);
                    int n = i;
                    this.buffer[n] = (byte)(this.buffer[n] + avg);
                    continue;
                }
                if (currPredictor != 14) continue;
                left = 0;
                if (i - this.bpp >= 0) {
                    left = this.buffer[i - this.bpp] & 0xFF;
                }
                above = 0;
                if (this.aboveBuffer != null) {
                    above = this.aboveBuffer[i] & 0xFF;
                }
                int aboveLeft = 0;
                if (i - this.bpp >= 0 && this.aboveBuffer != null) {
                    aboveLeft = this.aboveBuffer[i - this.bpp] & 0xFF;
                }
                int p = left + above - aboveLeft;
                int pLeft = Math.abs(p - left);
                int pAbove = Math.abs(p - above);
                int pAboveLeft = Math.abs(p - aboveLeft);
                int paeth = pLeft <= pAbove && pLeft <= pAboveLeft ? left : (pAbove <= pAboveLeft ? above : aboveLeft);
                int n = i;
                this.buffer[n] = (byte)(this.buffer[n] + (byte)(paeth & 0xFF));
            }
            return numRead;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(", orig: ");
        if (this.originalInputKeptSolelyForDebugging == null) {
            sb.append("null");
        } else {
            sb.append(this.originalInputKeptSolelyForDebugging.toString());
        }
        return sb.toString();
    }
}

