/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.functions;

import java.util.Arrays;
import java.util.List;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.functions.Function;

public class Function_2
extends Function {
    public static final Name N_KEY = new Name("N");
    public static final Name C0_KEY = new Name("C0");
    public static final Name C1_KEY = new Name("C1");
    private float N;
    private float[] C0 = new float[]{0.0f};
    private float[] C1 = new float[]{1.0f};

    Function_2(Dictionary d) {
        super(d);
        List c1;
        this.N = d.getFloat(N_KEY);
        List c0 = (List)d.getObject(C0_KEY);
        if (c0 != null) {
            this.C0 = new float[c0.size()];
            for (int i = 0; i < c0.size(); ++i) {
                this.C0[i] = ((Number)c0.get(i)).floatValue();
            }
        }
        if ((c1 = (List)d.getObject(C1_KEY)) != null) {
            this.C1 = new float[c1.size()];
            for (int i = 0; i < c1.size(); ++i) {
                this.C1[i] = ((Number)c1.get(i)).floatValue();
            }
        }
    }

    public float[] calculate(float[] x) {
        float[] y = new float[x.length * this.C0.length];
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < this.C0.length; ++j) {
                float yValue = (float)((double)this.C0[j] + Math.pow(x[i], this.N) * (double)(this.C1[j] - this.C0[j]));
                if (this.range != null) {
                    yValue = Math.min(Math.max(yValue, this.range[2 * j]), this.range[2 * j + 1]);
                }
                y[i * this.C0.length + j] = yValue;
            }
        }
        return y;
    }

    public String toString() {
        return "FunctionType: " + this.functionType + "\n    domain: " + Arrays.toString(this.domain) + "\n     range: " + Arrays.toString(this.range) + "\n         N: " + this.N + "\n        C0: " + Arrays.toString(this.C0) + "\n        C1: " + Arrays.toString(this.C1);
    }
}

