/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.ImagePool;
import org.icepdf.core.pobjects.graphics.ImageReference;

public abstract class CachedImageReference
extends ImageReference {
    private ImagePool imagePool;
    private boolean isNull;

    protected CachedImageReference(ImageStream imageStream, Color fillColor, Resources resources) {
        super(imageStream, fillColor, resources);
        this.imagePool = imageStream.getLibrary().getImagePool();
        this.reference = imageStream.getPObjectReference();
    }

    public BufferedImage getImage() {
        if (this.isNull) {
            return null;
        }
        if (this.image != null) {
            this.imagePool.put(this.reference, this.image);
            return this.image;
        }
        BufferedImage cached = this.imagePool.get(this.reference);
        if (cached != null) {
            return cached;
        }
        BufferedImage im = this.createImage();
        if (im != null) {
            this.imagePool.put(this.reference, im);
        } else {
            this.isNull = true;
        }
        return im;
    }
}

