/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.Pattern;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.commands.ColorDrawCmd;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.content.ContentParser;
import org.icepdf.core.util.content.ContentParserFactory;

public class TilingPattern
extends Stream
implements Pattern {
    private static final Logger logger = Logger.getLogger(TilingPattern.class.toString());
    public static final Name PATTERNTYPE_KEY = new Name("PatternType");
    public static final Name PAINTTYPE_KEY = new Name("PaintType");
    public static final Name TILINGTYPE_KEY = new Name("TilingType");
    public static final Name BBOX_KEY = new Name("BBox");
    public static final Name XSTEP_KEY = new Name("XStep");
    public static final Name YSTEP_KEY = new Name("YStep");
    public static final Name MATRIX_KEY = new Name("Matrix");
    public static final Name RESOURCES_KEY = new Name("Resources");
    private static RenderingHints renderingHints;
    private int patternType;
    private int paintType;
    private Color unColored;
    public static final int PAINTING_TYPE_COLORED_TILING_PATTERN = 1;
    public static final int PAINTING_TYPE_UNCOLORED_TILING_PATTERN = 2;
    private int tilingType;
    private Name type;
    public static final int TILING_TYPE_CONSTANT_SPACING = 1;
    public static final int TILING_TYPE_NO_DISTORTION = 2;
    public static final int TILING_TYPE_CONSTANT_SPACING_FASTER = 3;
    private Rectangle2D bBox;
    private Rectangle2D bBoxMod;
    private float xStep;
    private float yStep;
    private Resources resources;
    private AffineTransform matrix;
    private Shapes shapes;
    public Color fillColour = null;
    private boolean inited;
    private TexturePaint texturePaint;
    private GraphicsState parentGraphicState;
    private TexturePaint patternPaint;

    public TilingPattern(Stream stream) {
        super(stream.getLibrary(), stream.getEntries(), stream.getRawBytes());
        this.initiParams();
    }

    public TilingPattern(Library l, HashMap h, SeekableInputConstrainedWrapper streamInputWrapper) {
        super(l, h, streamInputWrapper);
        this.initiParams();
    }

    private void initiParams() {
        this.type = this.library.getName(this.entries, TYPE_KEY);
        this.patternType = this.library.getInt(this.entries, PATTERNTYPE_KEY);
        this.paintType = this.library.getInt(this.entries, PAINTTYPE_KEY);
        this.tilingType = this.library.getInt(this.entries, TILINGTYPE_KEY);
        this.bBox = this.library.getRectangle(this.entries, BBOX_KEY);
        this.xStep = this.library.getFloat(this.entries, XSTEP_KEY);
        this.yStep = this.library.getFloat(this.entries, YSTEP_KEY);
        List v = (List)this.library.getObject(this.entries, MATRIX_KEY);
        this.matrix = v != null ? TilingPattern.getAffineTransform(v) : new AffineTransform();
    }

    public Name getType() {
        return this.type;
    }

    private static AffineTransform getAffineTransform(List v) {
        float[] f = new float[6];
        for (int i = 0; i < 6; ++i) {
            f[i] = ((Number)v.get(i)).floatValue();
        }
        return new AffineTransform(f);
    }

    public Color getFirstColor() {
        if (this.shapes != null && this.unColored == null) {
            int max = this.shapes.shapes.size();
            for (int i = 0; i < max; ++i) {
                if (!(this.shapes.shapes.get(i) instanceof ColorDrawCmd)) continue;
                ColorDrawCmd tmp = (ColorDrawCmd)this.shapes.shapes.get(i);
                this.unColored = tmp.getColor();
                return this.unColored;
            }
        }
        if (this.unColored == null) {
            this.unColored = Color.black;
            return this.unColored;
        }
        return this.unColored;
    }

    public synchronized void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        Resources leafResources = this.library.getResources(this.entries, RESOURCES_KEY);
        if (leafResources != null) {
            this.resources = leafResources;
        }
        ContentParser cp = ContentParserFactory.getInstance().getContentParser(this.library, this.resources);
        cp.setGraphicsState(this.parentGraphicState);
        try {
            this.shapes = cp.parse(new byte[][]{this.getDecodedStreamBytes()}).getShapes();
        }
        catch (Throwable e) {
            logger.log(Level.FINE, "Error processing tiling pattern.", e);
        }
        if (this.xStep == 32767.0f) {
            this.xStep = (float)this.bBox.getWidth();
        }
        if (this.yStep == 32767.0f) {
            this.yStep = (float)this.bBox.getHeight();
        }
        this.bBoxMod = new Rectangle2D.Double(this.bBox.getX(), this.bBox.getY(), this.bBox.getWidth() == (double)this.xStep ? this.bBox.getWidth() : (double)this.xStep, this.bBox.getHeight() == (double)this.yStep ? this.bBox.getHeight() : (double)this.yStep);
        this.bBoxMod = this.matrix.createTransformedShape(this.bBoxMod).getBounds2D();
    }

    public void paintPattern(Graphics2D g, AffineTransform base) {
        if (this.patternPaint == null) {
            int width = (int)this.bBoxMod.getWidth();
            int height = (int)this.bBoxMod.getHeight();
            if (width == 0) {
                width = 1;
            }
            if (height == 0) {
                height = 1;
            }
            BufferedImage bi = new BufferedImage(width, height, 2);
            Graphics2D canvas = bi.createGraphics();
            this.patternPaint = new TexturePaint(bi, this.bBoxMod);
            g.setPaint(this.patternPaint);
            canvas.setRenderingHints(renderingHints);
            Shapes tilingShapes = this.getShapes();
            canvas.setClip(0, 0, (int)this.bBoxMod.getWidth(), (int)this.bBoxMod.getHeight());
            this.paintPattern(canvas, tilingShapes, base);
            canvas.dispose();
            bi.flush();
        } else {
            g.setPaint(this.patternPaint);
        }
    }

    private void paintPattern(Graphics2D g2d, Shapes tilingShapes, AffineTransform base) {
        AffineTransform preAf = g2d.getTransform();
        AffineTransform af = new AffineTransform(this.matrix.getScaleX(), this.matrix.getShearY(), this.matrix.getShearX(), this.matrix.getScaleY(), 0.0, 0.0);
        AffineTransform af2 = new AffineTransform(this.parentGraphicState.getCTM());
        af2.concatenate(af);
        g2d.transform(af2);
        AffineTransform prePaint = g2d.getTransform();
        tilingShapes.paint(g2d);
        g2d.setTransform(prePaint);
        g2d.translate(this.xStep, 0.0);
        prePaint = g2d.getTransform();
        tilingShapes.paint(g2d);
        g2d.setTransform(prePaint);
        g2d.translate(0.0, -this.yStep);
        prePaint = g2d.getTransform();
        tilingShapes.paint(g2d);
        g2d.setTransform(prePaint);
        g2d.translate(-this.xStep, 0.0);
        prePaint = g2d.getTransform();
        tilingShapes.paint(g2d);
        g2d.setTransform(prePaint);
        g2d.translate(-this.xStep, 0.0);
        prePaint = g2d.getTransform();
        tilingShapes.paint(g2d);
        g2d.setTransform(prePaint);
        g2d.translate(0.0, this.yStep);
        prePaint = g2d.getTransform();
        tilingShapes.paint(g2d);
        g2d.setTransform(prePaint);
        g2d.translate(0.0, this.yStep);
        prePaint = g2d.getTransform();
        tilingShapes.paint(g2d);
        g2d.setTransform(prePaint);
        g2d.translate(this.xStep, 0.0);
        prePaint = g2d.getTransform();
        tilingShapes.paint(g2d);
        g2d.setTransform(prePaint);
        g2d.translate(this.xStep, 0.0);
        tilingShapes.paint(g2d);
        g2d.setTransform(preAf);
    }

    public Paint getPaint() {
        return this.texturePaint;
    }

    public int getPatternType() {
        return this.patternType;
    }

    public void setPatternType(int patternType) {
        this.patternType = patternType;
    }

    public int getPaintType() {
        return this.paintType;
    }

    public void setPaintType(int paintType) {
        this.paintType = paintType;
    }

    public int getTilingType() {
        return this.tilingType;
    }

    public void setTilingType(int tilingType) {
        this.tilingType = tilingType;
    }

    public Rectangle2D getBBox() {
        return this.bBox;
    }

    public Rectangle2D getbBoxMod() {
        return this.bBoxMod;
    }

    public float getXStep() {
        return this.xStep;
    }

    public float getYStep() {
        return this.yStep;
    }

    public AffineTransform getMatrix() {
        return this.matrix;
    }

    public AffineTransform getInvMatrix() {
        try {
            return this.matrix.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public void setMatrix(AffineTransform matrix) {
        this.matrix = matrix;
    }

    public Shapes getShapes() {
        return this.shapes;
    }

    public void setShapes(Shapes shapes) {
        this.shapes = shapes;
    }

    public void setParentGraphicState(GraphicsState graphicsState) {
        this.parentGraphicState = graphicsState;
    }

    public GraphicsState getParentGraphicState() {
        return this.parentGraphicState;
    }

    public Color getUnColored() {
        return this.unColored;
    }

    public void setUnColored(Color unColored) {
        this.unColored = unColored;
    }

    public String toString() {
        return "Tiling Pattern: \n           type: pattern \n    patternType: tilling\n      paintType: " + (this.paintType == 1 ? "colored" : "uncoloured") + "\n    tilingType: " + this.tilingType + "\n          bbox: " + this.bBox + "\n         xStep: " + this.xStep + "\n         yStep: " + this.yStep + "\n      resource: " + this.resources + "\n        matrix: " + this.matrix;
    }

    static {
        Object antiAliasing = RenderingHints.VALUE_ANTIALIAS_OFF;
        Object interpolation = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        String property = Defs.sysProperty("org.icepdf.core.tiling.antiAliasing");
        if (property != null) {
            if (property.equalsIgnoreCase("VALUE_ANTIALIAS_DEFAULT")) {
                antiAliasing = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
            } else if (property.equalsIgnoreCase("VALUE_ANTIALIAS_ON")) {
                antiAliasing = RenderingHints.VALUE_ANTIALIAS_ON;
            } else if (property.equalsIgnoreCase("VALUE_ANTIALIAS_OFF")) {
                antiAliasing = RenderingHints.VALUE_ANTIALIAS_OFF;
            }
        }
        if ((property = Defs.sysProperty("org.icepdf.core.tiling.interpolation")) != null) {
            if (property.equalsIgnoreCase("VALUE_INTERPOLATION_BICUBIC")) {
                interpolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
            } else if (property.equalsIgnoreCase("VALUE_INTERPOLATION_BILINEAR")) {
                interpolation = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
            } else if (property.equalsIgnoreCase("VALUE_INTERPOLATION_NEAREST_NEIGHBOR")) {
                interpolation = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
        }
        renderingHints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, interpolation);
        renderingHints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, antiAliasing));
    }
}

