/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util.content;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.ByteDoubleArrayInputStream;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.GlyphOutlineClip;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.InlineImageStreamReference;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.commands.GlyphOutlineDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ImageDrawCmd;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;
import org.icepdf.core.util.content.AbstractContentParser;
import org.icepdf.core.util.content.ContentParser;
import org.icepdf.core.util.content.TextMetrics;

public class OContentParser
extends AbstractContentParser {
    private static final Logger logger = Logger.getLogger(OContentParser.class.toString());

    public OContentParser(Library l, Resources r) {
        super(l, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentParser parse(byte[][] streamBytes) throws InterruptedException, IOException {
        if (this.shapes == null) {
            this.shapes = new Shapes();
            if (this.graphicState == null) {
                this.graphicState = new GraphicsState(this.shapes);
            } else {
                this.graphicState.setCTM(new AffineTransform());
                this.graphicState.setClip(null);
                OContentParser.setStroke(this.shapes, this.graphicState);
                this.graphicState.setShapes(this.shapes);
            }
        }
        if (this.oCGs == null && this.library.getCatalog().getOptionalContent() != null) {
            this.oCGs = new LinkedList();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.fine("Parsing page content streams: " + streamBytes.length);
            for (byte[] streamByte : streamBytes) {
                if (streamByte == null) continue;
                String tmp = new String(streamByte, "ISO-8859-1");
                logger.finer("Content = " + tmp);
            }
        }
        Parser parser = new Parser(new ByteDoubleArrayInputStream(streamBytes));
        float yBTstart = 0.0f;
        try {
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("ContentParser thread interrupted");
                }
                Object tok = parser.getStreamObject();
                if (!(tok instanceof String)) {
                    this.stack.push(tok);
                    continue;
                }
                if (tok.equals("l")) {
                    this.geometricPath = OContentParser.consume_L(this.stack, this.geometricPath);
                    continue;
                }
                if (tok.equals("m")) {
                    this.geometricPath = OContentParser.consume_m(this.stack, this.geometricPath);
                    continue;
                }
                if (tok.equals("c")) {
                    this.geometricPath = OContentParser.consume_c(this.stack, this.geometricPath);
                    continue;
                }
                if (tok.equals("S")) {
                    this.geometricPath = OContentParser.consume_S(this.graphicState, this.shapes, this.geometricPath);
                    continue;
                }
                if (tok.equals("Tf")) {
                    OContentParser.consume_Tf(this.graphicState, this.stack, this.resources);
                    continue;
                }
                if (tok.equals("BT")) {
                    yBTstart = this.parseText(parser, this.shapes, yBTstart);
                    continue;
                }
                if (tok.equals("F") || tok.equals("f")) {
                    this.geometricPath = OContentParser.consume_F(this.graphicState, this.shapes, this.geometricPath);
                    continue;
                }
                if (tok.equals("q")) {
                    this.graphicState = OContentParser.consume_q(this.graphicState);
                    continue;
                }
                if (tok.equals("Q")) {
                    this.graphicState = this.consume_Q(this.graphicState, this.shapes);
                    continue;
                }
                if (tok.equals("re")) {
                    this.geometricPath = OContentParser.consume_re(this.stack, this.geometricPath);
                    continue;
                }
                if (tok.equals("cm")) {
                    OContentParser.consume_cm(this.graphicState, this.stack, this.inTextBlock, this.textBlockBase);
                    continue;
                }
                if (tok.equals("h")) {
                    OContentParser.consume_h(this.geometricPath);
                    continue;
                }
                if (tok.equals("BDC")) {
                    OContentParser.consume_BDC(this.stack, this.shapes, this.oCGs, this.resources);
                    continue;
                }
                if (tok.equals("EMC")) {
                    OContentParser.consume_EMC(this.shapes, this.oCGs);
                    continue;
                }
                if (tok.equals("Do")) {
                    this.graphicState = OContentParser.consume_Do(this.graphicState, this.stack, this.shapes, this.resources, true);
                    continue;
                }
                if (tok.equals("f*")) {
                    this.geometricPath = OContentParser.consume_f_star(this.graphicState, this.shapes, this.geometricPath);
                    continue;
                }
                if (tok.equals("gs")) {
                    OContentParser.consume_gs(this.graphicState, this.stack, this.resources);
                    continue;
                }
                if (tok.equals("n")) {
                    this.geometricPath = OContentParser.consume_n(this.geometricPath);
                    continue;
                }
                if (tok.equals("w") || tok.equals("LW")) {
                    OContentParser.consume_w(this.graphicState, this.stack, this.shapes);
                    continue;
                }
                if (tok.equals("W")) {
                    OContentParser.consume_W(this.graphicState, this.geometricPath);
                    continue;
                }
                if (tok.equals("sc")) {
                    OContentParser.consume_sc(this.graphicState, this.stack, this.library, this.resources, false);
                    continue;
                }
                if (tok.equals("scn")) {
                    OContentParser.consume_sc(this.graphicState, this.stack, this.library, this.resources, true);
                    continue;
                }
                if (tok.equals("b")) {
                    this.geometricPath = OContentParser.consume_b(this.graphicState, this.shapes, this.geometricPath);
                    continue;
                }
                if (tok.equals("k")) {
                    OContentParser.consume_k(this.graphicState, this.stack, this.library);
                    continue;
                }
                if (tok.equals("g")) {
                    OContentParser.consume_g(this.graphicState, this.stack, this.library);
                    continue;
                }
                if (tok.equals("i")) {
                    OContentParser.consume_i(this.stack);
                    continue;
                }
                if (tok.equals("M")) {
                    OContentParser.consume_M(this.graphicState, this.stack, this.shapes);
                    continue;
                }
                if (tok.equals("J")) {
                    OContentParser.consume_J(this.graphicState, this.stack, this.shapes);
                    continue;
                }
                if (tok.equals("rg")) {
                    OContentParser.consume_rg(this.graphicState, this.stack, this.library);
                    continue;
                }
                if (tok.equals("d")) {
                    OContentParser.consume_d(this.graphicState, this.stack, this.shapes);
                    continue;
                }
                if (tok.equals("v")) {
                    OContentParser.consume_v(this.stack, this.geometricPath);
                    continue;
                }
                if (tok.equals("j")) {
                    OContentParser.consume_j(this.graphicState, this.stack, this.shapes);
                    continue;
                }
                if (tok.equals("y")) {
                    OContentParser.consume_y(this.stack, this.geometricPath);
                    continue;
                }
                if (tok.equals("cs")) {
                    OContentParser.consume_cs(this.graphicState, this.stack, this.resources);
                    continue;
                }
                if (tok.equals("ri")) {
                    this.stack.pop();
                    continue;
                }
                if (tok.equals("SC")) {
                    OContentParser.consume_SC(this.graphicState, this.stack, this.library, this.resources, false);
                    continue;
                }
                if (tok.equals("SCN")) {
                    OContentParser.consume_SC(this.graphicState, this.stack, this.library, this.resources, true);
                    continue;
                }
                if (tok.equals("B")) {
                    this.geometricPath = OContentParser.consume_B(this.graphicState, this.shapes, this.geometricPath);
                    continue;
                }
                if (tok.equals("K")) {
                    OContentParser.consume_K(this.graphicState, this.stack, this.library);
                    continue;
                }
                if (tok.equals("d0")) {
                    this.graphicState = OContentParser.consume_d0(this.graphicState, this.stack);
                    continue;
                }
                if (tok.equals("s")) {
                    this.geometricPath = OContentParser.consume_s(this.graphicState, this.shapes, this.geometricPath);
                    continue;
                }
                if (tok.equals("G")) {
                    OContentParser.consume_G(this.graphicState, this.stack, this.library);
                    continue;
                }
                if (tok.equals("b*")) {
                    this.geometricPath = OContentParser.consume_b_star(this.graphicState, this.shapes, this.geometricPath);
                    continue;
                }
                if (tok.equals("RG")) {
                    OContentParser.consume_RG(this.graphicState, this.stack, this.library);
                    continue;
                }
                if (tok.equals("CS")) {
                    OContentParser.consume_CS(this.graphicState, this.stack, this.resources);
                    continue;
                }
                if (tok.equals("d1")) {
                    this.graphicState = OContentParser.consume_d1(this.graphicState, this.stack);
                    continue;
                }
                if (tok.equals("B*")) {
                    this.geometricPath = OContentParser.consume_B_star(this.graphicState, this.shapes, this.geometricPath);
                    continue;
                }
                if (tok.equals("BMC")) {
                    OContentParser.consume_BMC(this.stack, this.shapes, this.oCGs, this.resources);
                    continue;
                }
                if (tok.equals("BI")) {
                    this.parseInlineImage(parser, this.shapes);
                    continue;
                }
                if (tok.equals("BX") || tok.equals("EX")) continue;
                if (tok.equals("W*")) {
                    OContentParser.consume_W_star(this.graphicState, this.geometricPath);
                    continue;
                }
                if (tok.equals("DP")) {
                    OContentParser.consume_DP(this.stack);
                    continue;
                }
                if (tok.equals("MP")) {
                    OContentParser.consume_MP(this.stack);
                    continue;
                }
                if (tok.equals("sh")) {
                    OContentParser.consume_sh(this.graphicState, this.stack, this.shapes, this.resources);
                    continue;
                }
                if (tok.equals("Tc")) {
                    OContentParser.consume_Tc(this.graphicState, this.stack);
                    continue;
                }
                if (tok.equals("Tw")) {
                    OContentParser.consume_Tw(this.graphicState, this.stack);
                    continue;
                }
                if (tok.equals("TL")) {
                    OContentParser.consume_TL(this.graphicState, this.stack);
                    continue;
                }
                if (tok.equals("Tr")) {
                    OContentParser.consume_Tr(this.graphicState, this.stack);
                    continue;
                }
                if (tok.equals("Tz")) {
                    OContentParser.consume_Tz(this.graphicState, this.stack);
                    continue;
                }
                if (!tok.equals("Ts")) continue;
                OContentParser.consume_Ts(this.graphicState, this.stack);
            }
        }
        catch (IOException e) {
            logger.finer("End of Content Stream");
            OContentParser.setAlpha(this.shapes, 3, 1.0f);
        }
        catch (NoninvertibleTransformException e) {
            try {
                logger.log(Level.WARNING, "Error creating inverse transform:", e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                OContentParser.setAlpha(this.shapes, 3, 1.0f);
            }
        }
        while (!this.stack.isEmpty()) {
            String tmp = this.stack.pop().toString();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("STACK=" + tmp);
        }
        return this;
    }

    public Shapes parseTextBlocks(byte[][] source) throws UnsupportedEncodingException {
        Parser parser = new Parser(new ByteDoubleArrayInputStream(source));
        Shapes shapes = new Shapes();
        if (this.graphicState == null) {
            this.graphicState = new GraphicsState(shapes);
        }
        try {
            Object tok = parser.getStreamObject();
            Stack<Object> stack = new Stack<Object>();
            double yBTstart = 0.0;
            while (tok != null) {
                if (tok instanceof String) {
                    if (tok.equals("BT")) {
                        yBTstart = this.parseText(parser, shapes, yBTstart);
                        stack.clear();
                    } else if (tok.equals("Tf")) {
                        OContentParser.consume_Tf(this.graphicState, stack, this.resources);
                        stack.clear();
                    } else if (tok.equals("Do")) {
                        OContentParser.consume_Do(this.graphicState, stack, shapes, this.resources, false);
                        stack.clear();
                    }
                } else {
                    stack.push(tok);
                }
                tok = parser.getStreamObject();
            }
            stack.clear();
        }
        catch (IOException e) {
            logger.finer("End of Content Stream");
        }
        shapes.contract();
        return shapes;
    }

    float parseText(Parser parser, Shapes shapes, double previousBTStart) throws IOException {
        this.inTextBlock = true;
        TextMetrics textMetrics = new TextMetrics();
        this.textBlockBase = new AffineTransform(this.graphicState.getCTM());
        this.graphicState.getTextState().tmatrix = new AffineTransform();
        this.graphicState.getTextState().tlmatrix = new AffineTransform();
        this.graphicState.scale(1.0, -1.0);
        PageText pageText = shapes.getPageText();
        GlyphOutlineClip glyphOutlineClip = new GlyphOutlineClip();
        Object nextToken = parser.getStreamObject();
        while (!nextToken.equals("ET")) {
            if (nextToken instanceof String) {
                if (nextToken.equals("Tj")) {
                    OContentParser.consume_Tj(this.graphicState, this.stack, shapes, textMetrics, glyphOutlineClip, this.oCGs);
                } else if (nextToken.equals("Tc")) {
                    OContentParser.consume_Tc(this.graphicState, this.stack);
                } else if (nextToken.equals("Tw")) {
                    OContentParser.consume_Tw(this.graphicState, this.stack);
                } else if (nextToken.equals("Td")) {
                    OContentParser.consume_Td(this.graphicState, this.stack, textMetrics, pageText, previousBTStart, this.oCGs);
                } else if (nextToken.equals("Tm")) {
                    OContentParser.consume_tm(this.graphicState, this.stack, textMetrics, pageText, previousBTStart, this.textBlockBase, this.oCGs);
                } else if (nextToken.equals("Tf")) {
                    OContentParser.consume_Tf(this.graphicState, this.stack, this.resources);
                } else if (nextToken.equals("TJ")) {
                    OContentParser.consume_TJ(this.graphicState, this.stack, shapes, textMetrics, glyphOutlineClip, this.oCGs);
                } else if (nextToken.equals("TD")) {
                    OContentParser.consume_TD(this.graphicState, this.stack, textMetrics, pageText, this.oCGs);
                } else if (nextToken.equals("TL")) {
                    OContentParser.consume_TL(this.graphicState, this.stack);
                } else if (nextToken.equals("q")) {
                    this.graphicState = OContentParser.consume_q(this.graphicState);
                } else if (nextToken.equals("Q")) {
                    this.graphicState = this.consume_Q(this.graphicState, shapes);
                } else if (nextToken.equals("cm")) {
                    OContentParser.consume_cm(this.graphicState, this.stack, this.inTextBlock, this.textBlockBase);
                } else if (nextToken.equals("T*")) {
                    OContentParser.consume_T_star(this.graphicState, textMetrics, pageText, this.oCGs);
                } else if (nextToken.equals("BDC")) {
                    OContentParser.consume_BDC(this.stack, shapes, this.oCGs, this.resources);
                } else if (nextToken.equals("EMC")) {
                    OContentParser.consume_EMC(shapes, this.oCGs);
                } else if (nextToken.equals("gs")) {
                    OContentParser.consume_gs(this.graphicState, this.stack, this.resources);
                } else if (nextToken.equals("w") || nextToken.equals("LW")) {
                    OContentParser.consume_w(this.graphicState, this.stack, shapes);
                } else if (nextToken.equals("sc")) {
                    OContentParser.consume_sc(this.graphicState, this.stack, this.library, this.resources, false);
                } else if (nextToken.equals("scn")) {
                    OContentParser.consume_sc(this.graphicState, this.stack, this.library, this.resources, true);
                } else if (nextToken.equals("k")) {
                    OContentParser.consume_k(this.graphicState, this.stack, this.library);
                } else if (nextToken.equals("g")) {
                    OContentParser.consume_g(this.graphicState, this.stack, this.library);
                } else if (nextToken.equals("i")) {
                    OContentParser.consume_i(this.stack);
                } else if (nextToken.equals("M")) {
                    OContentParser.consume_M(this.graphicState, this.stack, shapes);
                } else if (nextToken.equals("J")) {
                    OContentParser.consume_J(this.graphicState, this.stack, shapes);
                } else if (nextToken.equals("rg")) {
                    OContentParser.consume_rg(this.graphicState, this.stack, this.library);
                } else if (nextToken.equals("d")) {
                    OContentParser.consume_d(this.graphicState, this.stack, shapes);
                } else if (nextToken.equals("d")) {
                    OContentParser.consume_d(this.graphicState, this.stack, shapes);
                } else if (nextToken.equals("j")) {
                    OContentParser.consume_j(this.graphicState, this.stack, shapes);
                } else if (nextToken.equals("cs")) {
                    OContentParser.consume_cs(this.graphicState, this.stack, this.resources);
                } else if (nextToken.equals("ri")) {
                    OContentParser.consume_ri(this.stack);
                } else if (nextToken.equals("SC")) {
                    OContentParser.consume_SC(this.graphicState, this.stack, this.library, this.resources, false);
                } else if (nextToken.equals("SCN")) {
                    OContentParser.consume_SC(this.graphicState, this.stack, this.library, this.resources, true);
                } else if (nextToken.equals("K")) {
                    OContentParser.consume_K(this.graphicState, this.stack, this.library);
                } else if (nextToken.equals("G")) {
                    OContentParser.consume_G(this.graphicState, this.stack, this.library);
                } else if (nextToken.equals("RG")) {
                    OContentParser.consume_RG(this.graphicState, this.stack, this.library);
                } else if (nextToken.equals("CS")) {
                    OContentParser.consume_CS(this.graphicState, this.stack, this.resources);
                } else if (nextToken.equals("Tr")) {
                    OContentParser.consume_Tr(this.graphicState, this.stack);
                } else if (nextToken.equals("Tz")) {
                    OContentParser.consume_Tz(this.graphicState, this.stack);
                } else if (nextToken.equals("Ts")) {
                    OContentParser.consume_Ts(this.graphicState, this.stack);
                } else if (!nextToken.equals("BX") && !nextToken.equals("EX")) {
                    if (nextToken.equals("'")) {
                        OContentParser.consume_single_quote(this.graphicState, this.stack, shapes, textMetrics, glyphOutlineClip, this.oCGs);
                    } else if (nextToken.equals("\"")) {
                        OContentParser.consume_double_quote(this.graphicState, this.stack, shapes, textMetrics, glyphOutlineClip, this.oCGs);
                    }
                }
            } else {
                this.stack.push(nextToken);
            }
            nextToken = parser.getStreamObject();
        }
        if (!glyphOutlineClip.isEmpty()) {
            this.graphicState.setClip(glyphOutlineClip.getGlyphOutlineClip());
            shapes.add(new GlyphOutlineDrawCmd(glyphOutlineClip));
        }
        while (!this.stack.isEmpty()) {
            String tmp = this.stack.pop().toString();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.warning("Text=" + tmp);
        }
        this.graphicState.set(this.textBlockBase);
        this.inTextBlock = false;
        return textMetrics.getyBTStart();
    }

    private void parseInlineImage(Parser p, Shapes shapes) throws IOException {
        try {
            HashMap<Object, Object> iih = new HashMap<Object, Object>();
            Object tok = p.getStreamObject();
            while (!tok.equals("ID")) {
                if (tok.equals("BPC")) {
                    tok = new Name("BitsPerComponent");
                } else if (tok.equals("CS")) {
                    tok = new Name("ColorSpace");
                } else if (tok.equals("D")) {
                    tok = new Name("Decode");
                } else if (tok.equals("DP")) {
                    tok = new Name("DecodeParms");
                } else if (tok.equals("F")) {
                    tok = new Name("Filter");
                } else if (tok.equals("H")) {
                    tok = new Name("Height");
                } else if (tok.equals("IM")) {
                    tok = new Name("ImageMask");
                } else if (tok.equals("I")) {
                    tok = new Name("Indexed");
                } else if (tok.equals("W")) {
                    tok = new Name("Width");
                }
                Object tok1 = p.getStreamObject();
                iih.put(tok, tok1);
                tok = p.getStreamObject();
            }
            ByteArrayOutputStream buf = new ByteArrayOutputStream(4096);
            tok = p.peek2();
            boolean ateEI = false;
            while (tok != null && !tok.equals(" EI") && !(ateEI = p.readLineForInlineImage(buf))) {
                tok = p.peek2();
            }
            if (!ateEI) {
                p.getToken();
            }
            buf.flush();
            buf.close();
            byte[] data = buf.toByteArray();
            ImageStream st = new ImageStream(this.library, iih, data);
            InlineImageStreamReference imageStreamReference = new InlineImageStreamReference(st, this.graphicState.getFillColor(), this.resources);
            AffineTransform af = new AffineTransform(this.graphicState.getCTM());
            this.graphicState.scale(1.0, -1.0);
            this.graphicState.translate(0.0, -1.0);
            shapes.add(new ImageDrawCmd(imageStreamReference));
            this.graphicState.set(af);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error parsing inline image.", e);
        }
    }
}

