/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.filters;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.BitStream;
import org.icepdf.core.io.SequenceInputStream;
import org.icepdf.core.io.ZeroPaddedInputStream;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.filters.G4State;
import org.icepdf.core.tag.Tagger;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

public class CCITTFax {
    private static final Logger logger = Logger.getLogger(CCITTFax.class.toString());
    static final String[] _twcodes = new String[]{"00110101", "000111", "0111", "1000", "1011", "1100", "1110", "1111", "10011", "10100", "00111", "01000", "001000", "000011", "110100", "110101", "101010", "101011", "0100111", "0001100", "0001000", "0010111", "0000011", "0000100", "0101000", "0101011", "0010011", "0100100", "0011000", "00000010", "00000011", "00011010", "00011011", "00010010", "00010011", "00010100", "00010101", "00010110", "00010111", "00101000", "00101001", "00101010", "00101011", "00101100", "00101101", "00000100", "00000101", "00001010", "00001011", "01010010", "01010011", "01010100", "01010101", "00100100", "00100101", "01011000", "01011001", "01011010", "01011011", "01001010", "01001011", "00110010", "00110011", "00110100"};
    static final String[] _mwcodes = new String[]{"11011", "10010", "010111", "0110111", "00110110", "00110111", "01100100", "01100101", "01101000", "01100111", "011001100", "011001101", "011010010", "011010011", "011010100", "011010101", "011010110", "011010111", "011011000", "011011001", "011011010", "011011011", "010011000", "010011001", "010011010", "011000", "010011011"};
    static final String[] _tbcodes = new String[]{"0000110111", "010", "11", "10", "011", "0011", "0010", "00011", "000101", "000100", "0000100", "0000101", "0000111", "00000100", "00000111", "000011000", "0000010111", "0000011000", "0000001000", "00001100111", "00001101000", "00001101100", "00000110111", "00000101000", "00000010111", "00000011000", "000011001010", "000011001011", "000011001100", "000011001101", "000001101000", "000001101001", "000001101010", "000001101011", "000011010010", "000011010011", "000011010100", "000011010101", "000011010110", "000011010111", "000001101100", "000001101101", "000011011010", "000011011011", "000001010100", "000001010101", "000001010110", "000001010111", "000001100100", "000001100101", "000001010010", "000001010011", "000000100100", "000000110111", "000000111000", "000000100111", "000000101000", "000001011000", "000001011001", "000000101011", "000000101100", "000001011010", "000001100110", "000001100111"};
    static final String[] _mbcodes = new String[]{"0000001111", "000011001000", "000011001001", "000001011011", "000000110011", "000000110100", "000000110101", "0000001101100", "0000001101101", "0000001001010", "0000001001011", "0000001001100", "0000001001101", "0000001110010", "0000001110011", "0000001110100", "0000001110101", "0000001110110", "0000001110111", "0000001010010", "0000001010011", "0000001010100", "0000001010101", "0000001011010", "0000001011011", "0000001100100", "0000001100101"};
    static final String[] _extmcodes = new String[]{"00000001000", "00000001100", "00000001101", "000000010010", "000000010011", "000000010100", "000000010101", "000000010110", "000000010111", "000000011100", "000000011101", "000000011110", "000000011111"};
    static final String[] _modecodes = new String[]{"0001", "001", "1", "011", "000011", "0000011", "010", "000010", "0000010", "0000001111", "000000001111", "000000000001"};
    static final Code[][] twcodes = CCITTFax.convertStringArrayToCodeArray2D(_twcodes);
    static final Code[][] mwcodes = CCITTFax.convertStringArrayToCodeArray2D(_mwcodes);
    static final Code[][] tbcodes = CCITTFax.convertStringArrayToCodeArray2D(_tbcodes);
    static final Code[][] mbcodes = CCITTFax.convertStringArrayToCodeArray2D(_mbcodes);
    static final Code[][] extmcodes = CCITTFax.convertStringArrayToCodeArray2D(_extmcodes);
    static final Code[][] modecodes = CCITTFax.convertStringArrayToCodeArray2D(_modecodes);
    static int black = 0;
    static int white = 1;
    private static final short TIFF_COMPRESSION_NONE_default = 1;
    private static final short TIFF_COMPRESSION_GROUP3_1D = 2;
    private static final short TIFF_COMPRESSION_GROUP3_2D = 3;
    private static final short TIFF_COMPRESSION_GROUP4 = 4;
    private static final String[] TIFF_COMPRESSION_NAMES = new String[]{"TIFF_COMPRESSION_NONE_default", "TIFF_COMPRESSION_GROUP3_1D", "TIFF_COMPRESSION_GROUP3_2D", "TIFF_COMPRESSION_GROUP4"};
    private static final short TIFF_PHOTOMETRIC_INTERPRETATION_WHITE_IS_ZERO_default = 0;
    private static final short TIFF_PHOTOMETRIC_INTERPRETATION_BLACK_IS_ZERO = 1;
    private static boolean USE_JAI_IMAGE_LIBRARY = false;
    private static Method jaiCreate = null;
    private static Method ssWrapInputStream = null;
    private static Method roGetAsBufferedImage = null;

    private static Code[][] convertStringArrayToCodeArray2D(String[] strArray) {
        int i;
        int largestLength;
        int len = strArray.length;
        int[] codeLengths = new int[64];
        for (int i2 = 0; i2 < len; ++i2) {
            int entryLength;
            int n = entryLength = strArray[i2].length();
            codeLengths[n] = codeLengths[n] + 1;
        }
        for (largestLength = codeLengths.length - 1; largestLength > 0 && codeLengths[largestLength] == 0; --largestLength) {
        }
        Code[][] codeArray = new Code[largestLength + 1][];
        for (i = 0; i < codeArray.length; ++i) {
            codeArray[i] = new Code[codeLengths[i]];
        }
        block3: for (i = 0; i < len; ++i) {
            int entryLength = strArray[i].length();
            Code[] entries = codeArray[entryLength];
            for (int j = 0; j < entries.length; ++j) {
                if (entries[j] != null) continue;
                entries[j] = new Code(strArray[i], i);
                continue block3;
            }
        }
        return codeArray;
    }

    private static int findPositionInTable(Code lookFor, Code[][] lookIn) {
        int lookForIndex = lookFor.getLength();
        if (lookForIndex >= lookIn.length) {
            return -1;
        }
        Code[] lookInWithSameLength = lookIn[lookForIndex];
        if (lookInWithSameLength == null) {
            return -1;
        }
        for (Code potentialMatch : lookInWithSameLength) {
            if (!lookFor.equals(potentialMatch)) continue;
            return potentialMatch.getTablePosition();
        }
        return -1;
    }

    static int findWhite(BitStream inb, Code code) throws IOException {
        code.reset();
        while (!inb.atEndOfFile()) {
            int i = inb.getBits(1);
            code.append(i != 0);
            int j = CCITTFax.findPositionInTable(code, twcodes);
            if (j >= 0) {
                return j;
            }
            j = CCITTFax.findPositionInTable(code, mwcodes);
            if (j >= 0) {
                return (j + 1) * 64;
            }
            j = CCITTFax.findPositionInTable(code, extmcodes);
            if (j < 0) continue;
            return 1792 + j * 64;
        }
        inb.close();
        return 0;
    }

    static int findBlack(BitStream inb, Code code) throws IOException {
        code.reset();
        while (!inb.atEndOfFile()) {
            int i = inb.getBits(1);
            code.append(i != 0);
            int j = CCITTFax.findPositionInTable(code, tbcodes);
            if (j >= 0) {
                return j;
            }
            j = CCITTFax.findPositionInTable(code, mbcodes);
            if (j >= 0) {
                return (j + 1) * 64;
            }
            j = CCITTFax.findPositionInTable(code, extmcodes);
            if (j < 0) continue;
            return 1792 + j * 64;
        }
        inb.close();
        return 0;
    }

    static void addRun(int x, G4State s, BitStream out) throws IOException {
        s.runLength += x;
        s.cur[s.curIndex++] = s.runLength;
        s.a0 += x;
        if (s.runLength > 0) {
            out.putRunBits(s.white ? white : black, s.runLength);
        }
        out.close();
        s.runLength = 0;
    }

    static int readmode(BitStream inb, Code code) throws IOException {
        code.reset();
        while (!inb.atEndOfFile()) {
            int i = inb.getBits(1);
            code.append(i != 0);
            int j = CCITTFax.findPositionInTable(code, modecodes);
            if (j < 0) continue;
            return j;
        }
        inb.close();
        return -1;
    }

    static void detectB1(G4State s) {
        if (s.curIndex != 0) {
            while (s.b1 <= s.a0 && s.b1 < s.width) {
                int r = s.ref[s.refIndex] + s.ref[s.refIndex + 1];
                if (r == 0) {
                    s.b1 = s.width;
                }
                s.b1 += r;
                if (s.refIndex + 2 >= s.ref.length) continue;
                s.refIndex += 2;
            }
        }
    }

    static void decodePass(G4State s) {
        CCITTFax.detectB1(s);
        s.b1 += s.ref[s.refIndex++];
        s.runLength += s.b1 - s.a0;
        s.a0 = s.b1;
        s.b1 += s.ref[s.refIndex++];
    }

    static void decodeHorizontal(BitStream in, BitStream out, G4State s, Code code) throws IOException {
        int rl = 0;
        do {
            int n = rl = s.white ? CCITTFax.findWhite(in, code) : CCITTFax.findBlack(in, code);
            if (rl >= 0) {
                if (rl < 64) {
                    CCITTFax.addRun(rl + s.longrun, s, out);
                    s.white = !s.white;
                    s.longrun = 0;
                    continue;
                }
                s.longrun += rl;
                continue;
            }
            CCITTFax.addRun(rl, s, out);
        } while (rl >= 64);
        out.close();
    }

    static void resetRuns(BitStream outb, G4State state) throws IOException {
        int i;
        state.white = true;
        CCITTFax.addRun(0, state, outb);
        if (state.a0 != state.width) {
            while (state.a0 > state.width) {
                state.a0 -= state.cur[--state.curIndex];
            }
            if (state.a0 < state.width) {
                if (state.a0 < 0) {
                    state.a0 = 0;
                }
                if ((state.curIndex & 1) != 0) {
                    CCITTFax.addRun(0, state, outb);
                }
                CCITTFax.addRun(state.width - state.a0, state, outb);
            } else if (state.a0 > state.width) {
                CCITTFax.addRun(state.width, state, outb);
                CCITTFax.addRun(0, state, outb);
            }
        }
        int[] tmp = state.ref;
        state.ref = state.cur;
        state.cur = tmp;
        for (i = state.curIndex; i < state.width; ++i) {
            state.ref[i] = 0;
        }
        for (i = 0; i < state.width; ++i) {
            state.cur[i] = 0;
        }
        state.runLength = 0;
        state.a0 = 0;
        state.b1 = state.ref[0];
        state.refIndex = 1;
        state.curIndex = 0;
        outb.close();
    }

    public static void Group4Decode(InputStream in, OutputStream out, int width, boolean blackIs1) {
        BitStream inb = new BitStream(in);
        BitStream outb = new BitStream(out);
        black = 0;
        white = 1;
        if (blackIs1) {
            black = 1;
            white = 0;
        }
        Code code = new Code();
        try {
            G4State graphicState = new G4State(width);
            block14: while (!inb.atEndOfFile()) {
                int mode = CCITTFax.readmode(inb, code);
                switch (mode) {
                    case 0: {
                        CCITTFax.decodePass(graphicState);
                        continue block14;
                    }
                    case 1: {
                        CCITTFax.decodeHorizontal(inb, outb, graphicState, code);
                        CCITTFax.decodeHorizontal(inb, outb, graphicState, code);
                        CCITTFax.detectB1(graphicState);
                        break;
                    }
                    case 2: {
                        CCITTFax.detectB1(graphicState);
                        CCITTFax.addRun(graphicState.b1 - graphicState.a0, graphicState, outb);
                        graphicState.white = !graphicState.white;
                        graphicState.b1 += graphicState.ref[graphicState.refIndex++];
                        break;
                    }
                    case 3: {
                        CCITTFax.detectB1(graphicState);
                        CCITTFax.addRun(graphicState.b1 - graphicState.a0 + 1, graphicState, outb);
                        graphicState.white = !graphicState.white;
                        graphicState.b1 += graphicState.ref[graphicState.refIndex++];
                        break;
                    }
                    case 4: {
                        CCITTFax.detectB1(graphicState);
                        CCITTFax.addRun(graphicState.b1 - graphicState.a0 + 2, graphicState, outb);
                        graphicState.white = !graphicState.white;
                        graphicState.b1 += graphicState.ref[graphicState.refIndex++];
                        break;
                    }
                    case 5: {
                        CCITTFax.detectB1(graphicState);
                        CCITTFax.addRun(graphicState.b1 - graphicState.a0 + 3, graphicState, outb);
                        graphicState.white = !graphicState.white;
                        graphicState.b1 += graphicState.ref[graphicState.refIndex++];
                        break;
                    }
                    case 6: {
                        CCITTFax.detectB1(graphicState);
                        CCITTFax.addRun(graphicState.b1 - graphicState.a0 - 1, graphicState, outb);
                        boolean bl = graphicState.white = !graphicState.white;
                        if (graphicState.refIndex <= 0) break;
                        graphicState.b1 -= graphicState.ref[--graphicState.refIndex];
                        break;
                    }
                    case 7: {
                        CCITTFax.detectB1(graphicState);
                        CCITTFax.addRun(graphicState.b1 - graphicState.a0 - 2, graphicState, outb);
                        boolean bl = graphicState.white = !graphicState.white;
                        if (graphicState.refIndex <= 0) break;
                        graphicState.b1 -= graphicState.ref[--graphicState.refIndex];
                        break;
                    }
                    case 8: {
                        CCITTFax.detectB1(graphicState);
                        CCITTFax.addRun(graphicState.b1 - graphicState.a0 - 3, graphicState, outb);
                        boolean bl = graphicState.white = !graphicState.white;
                        if (graphicState.refIndex <= 0) break;
                        graphicState.b1 -= graphicState.ref[--graphicState.refIndex];
                        break;
                    }
                    case 11: {
                        CCITTFax.resetRuns(outb, graphicState);
                        break;
                    }
                }
                if (graphicState.a0 < graphicState.width) continue;
                CCITTFax.resetRuns(outb, graphicState);
            }
            inb.close();
            outb.close();
            in.close();
            out.close();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error decoding group4 CITTFax", e);
        }
    }

    public static BufferedImage attemptDeriveBufferedImageFromBytes(ImageStream stream, Library library, HashMap streamDictionary, Color fill) {
        boolean hasHeader;
        if (!USE_JAI_IMAGE_LIBRARY) {
            return null;
        }
        boolean imageMask = stream.isImageMask();
        List decodeArray = (List)library.getObject(streamDictionary, ImageStream.DECODE_KEY);
        HashMap decodeParmsDictionary = library.getDictionary(streamDictionary, ImageStream.DECODEPARMS_KEY);
        boolean blackIs1 = stream.getBlackIs1(library, decodeParmsDictionary);
        float k = library.getFloat(decodeParmsDictionary, ImageStream.K_KEY);
        InputStream input = stream.getDecodedByteArrayInputStream();
        if (input == null) {
            return null;
        }
        input = new ZeroPaddedInputStream(input);
        BufferedInputStream bufferedInput = new BufferedInputStream(input, 1024);
        bufferedInput.mark(4);
        try {
            int hb1 = bufferedInput.read();
            int hb2 = bufferedInput.read();
            bufferedInput.reset();
            if (hb1 < 0 || hb2 < 0) {
                input.close();
                return null;
            }
            hasHeader = hb1 == 77 && hb2 == 77 || hb1 == 73 && hb2 == 73;
        }
        catch (IOException e) {
            try {
                input.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return null;
        }
        input = bufferedInput;
        BufferedImage img = null;
        byte[] fakeHeaderBytes = null;
        if (!hasHeader) {
            int columns;
            fakeHeaderBytes = new byte[]{77, 77, 0, 42, 0, 0, 0, 8, 0, 12, 0, -2, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 2, 0, 3, 0, 0, 0, 1, 0, 1, 0, 0, 1, 3, 0, 3, 0, 0, 0, 1, 0, 1, 0, 0, 1, 6, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 17, 0, 4, 0, 0, 0, 1, 0, 0, 0, -82, 1, 22, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 23, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 26, 0, 5, 0, 0, 0, 1, 0, 0, 0, -98, 1, 27, 0, 5, 0, 0, 0, 1, 0, 0, 0, -90, 1, 40, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1};
            boolean pdfStatesBlackAndWhite = false;
            if (blackIs1) {
                pdfStatesBlackAndWhite = true;
            }
            int width = library.getInt(streamDictionary, ImageStream.WIDTH_KEY);
            int height = library.getInt(streamDictionary, ImageStream.HEIGHT_KEY);
            Object columnsObj = library.getObject(decodeParmsDictionary, ImageStream.COLUMNS_KEY);
            if (columnsObj != null && columnsObj instanceof Number && (columns = ((Number)columnsObj).intValue()) > width) {
                width = columns;
            }
            Utils.setIntIntoByteArrayBE(width, fakeHeaderBytes, 30);
            Utils.setIntIntoByteArrayBE(height, fakeHeaderBytes, 42);
            Object bitsPerComponent = library.getObject(streamDictionary, ImageStream.BITSPERCOMPONENT_KEY);
            if (bitsPerComponent != null && bitsPerComponent instanceof Number) {
                Utils.setShortIntoByteArrayBE(((Number)bitsPerComponent).shortValue(), fakeHeaderBytes, 54);
            }
            short compression = 1;
            if (k < 0.0f) {
                compression = 4;
            } else if (k > 0.0f) {
                compression = 3;
            } else if (k == 0.0f) {
                compression = 2;
            }
            Utils.setShortIntoByteArrayBE(compression, fakeHeaderBytes, 66);
            short photometricInterpretation = 0;
            if (pdfStatesBlackAndWhite && !blackIs1) {
                photometricInterpretation = 1;
            }
            Utils.setShortIntoByteArrayBE(photometricInterpretation, fakeHeaderBytes, 78);
            Utils.setIntIntoByteArrayBE(height, fakeHeaderBytes, 102);
            int lengthOfCompressedData = 0x7FFFFFFE;
            Object lengthValue = library.getObject(streamDictionary, Stream.LENGTH_KEY);
            if (lengthValue != null && lengthValue instanceof Number) {
                lengthOfCompressedData = ((Number)lengthValue).intValue();
            } else {
                int approxLen = width * height;
                if (approxLen > 0) {
                    lengthOfCompressedData = approxLen;
                }
            }
            Utils.setIntIntoByteArrayBE(lengthOfCompressedData, fakeHeaderBytes, 114);
            ByteArrayInputStream fakeHeaderBytesIn = new ByteArrayInputStream(fakeHeaderBytes);
            SequenceInputStream sin = new SequenceInputStream(fakeHeaderBytesIn, input);
            img = CCITTFax.deriveBufferedImageFromTIFFBytes(sin, library, lengthOfCompressedData, width, height);
            if (img == null) {
                for (int i = 1; i <= 2; ++i) {
                    if ((compression = (short)((short)(compression + 1))) > 4) {
                        compression = 2;
                    }
                    Utils.setShortIntoByteArrayBE(compression, fakeHeaderBytes, 66);
                    input = stream.getDecodedByteArrayInputStream();
                    if (input == null) {
                        return null;
                    }
                    fakeHeaderBytesIn = new ByteArrayInputStream(fakeHeaderBytes);
                    sin = new SequenceInputStream(fakeHeaderBytesIn, input = new ZeroPaddedInputStream(input));
                    img = CCITTFax.deriveBufferedImageFromTIFFBytes(sin, library, lengthOfCompressedData, width, height);
                    if (img == null) continue;
                    if (Tagger.tagging) {
                        Tagger.tagImage("CCITTFaxDecode_JAI_TIFF_COMPRESSION=" + TIFF_COMPRESSION_NAMES[compression]);
                    }
                    break;
                }
            }
        } else {
            int width = library.getInt(streamDictionary, ImageStream.WIDTH_KEY);
            int height = library.getInt(streamDictionary, ImageStream.HEIGHT_KEY);
            int approxLen = width * height;
            img = CCITTFax.deriveBufferedImageFromTIFFBytes(input, library, approxLen, width, height);
        }
        if (img != null) {
            if (Tagger.tagging) {
                Tagger.tagImage("HandledBy=CCITTFaxDecode_JAI");
                Tagger.tagImage("CCITTFaxDecode_DecodeParms_BlackIs1=" + blackIs1);
                Tagger.tagImage("CCITTFaxDecode_DecodeParms_K=" + k);
                Tagger.tagImage("CCITTFaxDecode_hasHeader=" + hasHeader);
            }
            img = CCITTFax.applyImageMaskAndDecodeArray(img, imageMask, blackIs1, decodeArray, fill);
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage deriveBufferedImageFromTIFFBytes(InputStream in, Library library, int compressedBytes, int width, int height) {
        BufferedImage img = null;
        try {
            Object com_sun_media_jai_codec_SeekableStream_s = ssWrapInputStream.invoke(null, in, Boolean.TRUE);
            ParameterBlock pb = new ParameterBlock();
            pb.add(com_sun_media_jai_codec_SeekableStream_s);
            Object javax_media_jai_RenderedOp_op = jaiCreate.invoke(null, "tiff", pb);
            if (javax_media_jai_RenderedOp_op != null) {
                RenderedImage ri = (RenderedImage)javax_media_jai_RenderedOp_op;
                Raster r = ri.getTile(0, 0);
                if (r instanceof WritableRaster) {
                    ColorModel cm = ri.getColorModel();
                    img = new BufferedImage(cm, (WritableRaster)r, false, null);
                } else {
                    img = (BufferedImage)roGetAsBufferedImage.invoke(javax_media_jai_RenderedOp_op, new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            img = null;
            logger.log(Level.FINE, "Could not derive image from data bytes via JAI.");
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        return img;
    }

    private static BufferedImage applyImageMaskAndDecodeArray(BufferedImage img, boolean imageMask, Boolean blackIs1, List decode, Color fill) {
        ColorModel cm = img.getColorModel();
        if (cm instanceof IndexColorModel && cm.getPixelSize() == 1) {
            boolean flag;
            if (Tagger.tagging) {
                Tagger.tagImage("CCITTFaxDecode_ImageMaskDecode=JAI_MANUAL");
            }
            boolean defaultDecode = decode == null || 0.0f == ((Number)decode.get(0)).floatValue();
            boolean bl = flag = blackIs1 == null && !defaultDecode || blackIs1 != null && blackIs1 != false && decode == null;
            if (imageMask) {
                int a = 0xFFFFFF;
                int[] cmap = new int[]{flag ? fill.getRGB() : a, flag ? a : fill.getRGB()};
                int transparentIndex = flag ? 1 : 0;
                IndexColorModel icm = new IndexColorModel(cm.getPixelSize(), cmap.length, cmap, 0, true, transparentIndex, cm.getTransferType());
                img = new BufferedImage(icm, img.getRaster(), img.isAlphaPremultiplied(), null);
            } else {
                int[] cmap = new int[]{flag ? -16777216 : -1, flag ? -1 : -16777216};
                IndexColorModel icm = new IndexColorModel(cm.getPixelSize(), cmap.length, cmap, 0, false, -1, cm.getTransferType());
                img = new BufferedImage(icm, img.getRaster(), img.isAlphaPremultiplied(), null);
            }
        }
        return img;
    }

    static {
        try {
            Class<?> jaiClass = Class.forName("javax.media.jai.JAI");
            jaiCreate = jaiClass.getMethod("create", String.class, ParameterBlock.class);
            Class<?> ssClass = Class.forName("com.sun.media.jai.codec.SeekableStream");
            ssWrapInputStream = ssClass.getMethod("wrapInputStream", InputStream.class, Boolean.TYPE);
            Class<?> roClass = Class.forName("javax.media.jai.RenderedOp");
            roGetAsBufferedImage = roClass.getMethod("getAsBufferedImage", new Class[0]);
            USE_JAI_IMAGE_LIBRARY = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class Code {
        private long value = 0L;
        private int length = 0;
        private int tablePosition;

        public Code() {
        }

        public Code(String strValue, int tablePosition) {
            this.tablePosition = tablePosition;
            for (int i = 0; i < strValue.length(); ++i) {
                this.append(strValue.charAt(i) == '1');
            }
        }

        public final void append(boolean bit) {
            if (bit && this.length <= 63) {
                long mask = 1L << this.length;
                this.value |= mask;
            }
            ++this.length;
        }

        public final boolean equals(Object ob) {
            if (ob instanceof Code) {
                Code c = (Code)ob;
                return this.value == c.value && this.length == c.length;
            }
            return false;
        }

        public final void reset() {
            this.value = 0L;
            this.length = 0;
        }

        public final int getLength() {
            return this.length;
        }

        public final int getTablePosition() {
            return this.tablePosition;
        }
    }
}

