/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.commands;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.graphics.OptionalContentState;
import org.icepdf.core.pobjects.graphics.PaintTimer;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.commands.AbstractDrawCmd;

public class FormDrawCmd
extends AbstractDrawCmd {
    private Form xForm;

    public FormDrawCmd(Form xForm) {
        this.xForm = xForm;
    }

    public Shape paintOperand(Graphics2D g, Page parentPage, Shape currentShape, Shape clip, AffineTransform base, OptionalContentState optionalContentState, boolean paintAlpha, PaintTimer paintTimer) {
        if (optionalContentState.isVisible()) {
            Rectangle2D bBox = this.xForm.getBBox();
            int width = (int)bBox.getWidth();
            int height = (int)bBox.getHeight();
            if (width == 0) {
                width = 1;
            }
            if (height == 0) {
                height = 1;
            }
            BufferedImage bi = new BufferedImage(width, height, 2);
            Graphics2D canvas = bi.createGraphics();
            canvas.setRenderingHints(g.getRenderingHints());
            Shapes xFormShapes = this.xForm.getShapes();
            if (xFormShapes != null) {
                xFormShapes.setPageParent(parentPage);
                canvas.translate(-((int)bBox.getX()), -((int)bBox.getY()));
                canvas.setClip(bBox);
                xFormShapes.paint(canvas);
                xFormShapes.setPageParent(null);
            }
            g.drawImage(bi, null, (int)bBox.getX(), (int)bBox.getY());
        }
        return currentShape;
    }
}

