/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.commands;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.ImageUtility;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.OptionalContentState;
import org.icepdf.core.pobjects.graphics.PaintTimer;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.SoftMask;
import org.icepdf.core.pobjects.graphics.commands.AbstractDrawCmd;
import org.icepdf.core.util.Defs;

public class FormDrawCmd
extends AbstractDrawCmd {
    private Form xForm;
    private BufferedImage xFormBuffer;
    private int x;
    private int y;
    private static boolean disableXObjectSMask = Defs.sysPropertyBoolean("org.icepdf.core.disableXObjectSMask", true);

    public FormDrawCmd(Form xForm) {
        this.xForm = xForm;
    }

    public Shape paintOperand(Graphics2D g, Page parentPage, Shape currentShape, Shape clip, AffineTransform base, OptionalContentState optionalContentState, boolean paintAlpha, PaintTimer paintTimer) {
        if (optionalContentState.isVisible() && this.xFormBuffer == null) {
            RenderingHints renderingHints = g.getRenderingHints();
            Rectangle2D bBox = this.xForm.getBBox();
            this.x = (int)bBox.getX();
            this.y = (int)bBox.getY();
            GraphicsState graphicsState = this.xForm.getGraphicsState();
            this.xFormBuffer = this.createBufferXObject(parentPage, this.xForm, graphicsState, renderingHints);
            if (!disableXObjectSMask && graphicsState != null && graphicsState.getSoftMask() != null) {
                SoftMask softMask = graphicsState.getSoftMask();
                Form sMaskForm = softMask.getG();
                BufferedImage sMaskBuffer = this.createBufferXObject(parentPage, sMaskForm, graphicsState, renderingHints);
                if (sMaskBuffer.getWidth() > this.xFormBuffer.getWidth()) {
                    this.x = (int)sMaskForm.getBBox().getX();
                    this.y = (int)sMaskForm.getBBox().getY();
                }
                if (!sMaskForm.getResources().isShading()) {
                    this.xFormBuffer = ImageUtility.applyExplicitSMask(this.xFormBuffer, sMaskBuffer);
                    sMaskBuffer.flush();
                }
            }
        }
        g.drawImage(this.xFormBuffer, null, this.x, this.y);
        return currentShape;
    }

    private BufferedImage createBufferXObject(Page parentPage, Form xForm, GraphicsState graphicsState, RenderingHints renderingHints) {
        Rectangle2D bBox = xForm.getBBox();
        int width = (int)bBox.getWidth();
        int height = (int)bBox.getHeight();
        if (width == 0) {
            width = 1;
        } else if (width >= Short.MAX_VALUE) {
            width = this.xFormBuffer.getWidth();
        }
        if (height == 0) {
            height = 1;
        } else if (height >= Short.MAX_VALUE) {
            height = this.xFormBuffer.getHeight();
        }
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D canvas = bi.createGraphics();
        canvas.setRenderingHints(renderingHints);
        Shapes xFormShapes = xForm.getShapes();
        if (xFormShapes != null) {
            xFormShapes.setPageParent(parentPage);
            if (!xForm.getResources().isShading()) {
                canvas.translate(-((int)bBox.getX()), -((int)bBox.getY()));
                canvas.setClip(bBox);
                xFormShapes.paint(canvas);
                xFormShapes.setPageParent(null);
            }
        }
        canvas.dispose();
        return bi;
    }
}

