/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored.configuration;

import org.infinispan.anchored.configuration.AnchoredKeysConfigurationBuilder;
import org.infinispan.anchored.configuration.Attribute;
import org.infinispan.anchored.configuration.Element;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;

@Namespaces(value={@Namespace(root="anchored-keys"), @Namespace(uri="urn:infinispan:config:anchored-keys:*", root="anchored-keys", since="11.0")})
public class AnchoredKeysConfigurationParser
implements ConfigurationParser {
    static final String PREFIX = "anchored-keys";
    static final String NAMESPACE = "urn:infinispan:config:anchored-keys:";

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        if (!holder.inScope((Enum)ParserScope.CACHE) && !holder.inScope((Enum)ParserScope.CACHE_TEMPLATE)) {
            throw new IllegalStateException("WRONG SCOPE");
        }
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case ANCHORED_KEYS: {
                AnchoredKeysConfigurationBuilder anchoredBuilder = (AnchoredKeysConfigurationBuilder)builder.addModule(AnchoredKeysConfigurationBuilder.class);
                anchoredBuilder.enabled(true);
                this.parseAnchoredKeys(reader, anchoredBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    private void parseAnchoredKeys(ConfigurationReader reader, AnchoredKeysConfigurationBuilder builder) {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case ENABLED: {
                    builder.enabled(Boolean.parseBoolean(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

