/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.SegmentColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;

public class SegmentColumnConfigurationBuilder
implements Builder<SegmentColumnConfiguration> {
    private final AttributeSet attributes;
    private final AbstractJdbcStoreConfigurationBuilder abstractJdbcStoreConfigurationBuilder;

    SegmentColumnConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder abstractJdbcStoreConfigurationBuilder) {
        this.abstractJdbcStoreConfigurationBuilder = abstractJdbcStoreConfigurationBuilder;
        this.attributes = SegmentColumnConfiguration.attributeSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public SegmentColumnConfigurationBuilder columnName(String columnName) {
        this.attributes.attribute(SegmentColumnConfiguration.SEGMENT_COLUMN_NAME).set((Object)columnName);
        return this;
    }

    public SegmentColumnConfigurationBuilder columnType(String columnType) {
        this.attributes.attribute(SegmentColumnConfiguration.SEGMENT_COLUMN_TYPE).set((Object)columnType);
        return this;
    }

    public void validate() {
        Boolean segmented = (Boolean)this.abstractJdbcStoreConfigurationBuilder.attributes().attribute(AbstractStoreConfiguration.SEGMENTED).get();
        if (segmented != null && segmented.booleanValue()) {
            TableManipulationConfigurationBuilder.validateIfSet(this.attributes, SegmentColumnConfiguration.SEGMENT_COLUMN_NAME, SegmentColumnConfiguration.SEGMENT_COLUMN_TYPE);
        }
    }

    public SegmentColumnConfiguration create() {
        return new SegmentColumnConfiguration(this.attributes.protect());
    }

    public Builder<?> read(SegmentColumnConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }
}

