/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.Attribute;
import org.infinispan.persistence.jdbc.common.configuration.Element;
import org.infinispan.persistence.jdbc.configuration.DataColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.IdColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.SegmentColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.TimestampColumnConfiguration;

public class TableManipulationConfiguration {
    public static final AttributeDefinition<String> TABLE_NAME_PREFIX = AttributeDefinition.builder((Enum)Attribute.PREFIX, null, String.class).immutable().build();
    public static final AttributeDefinition<Integer> BATCH_SIZE = AttributeDefinition.builder((Enum)Attribute.BATCH_SIZE, (Object)((Integer)AbstractStoreConfiguration.MAX_BATCH_SIZE.getDefaultValue())).immutable().build();
    public static final AttributeDefinition<Integer> FETCH_SIZE = AttributeDefinition.builder((Enum)Attribute.FETCH_SIZE, (Object)100).immutable().build();
    public static final AttributeDefinition<Boolean> CREATE_ON_START = AttributeDefinition.builder((Enum)Attribute.CREATE_ON_START, (Object)true).immutable().build();
    public static final AttributeDefinition<Boolean> DROP_ON_EXIT = AttributeDefinition.builder((Enum)Attribute.DROP_ON_EXIT, (Object)false).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<String> tableNamePrefix;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> batchSize;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> fetchSize;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> createOnStart;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> dropOnExit;
    private final AttributeSet attributes;
    private final IdColumnConfiguration idColumn;
    private final DataColumnConfiguration dataColumn;
    private final TimestampColumnConfiguration timeStamp;
    private final SegmentColumnConfiguration segmentColumn;

    static AttributeSet attributeSet() {
        return new AttributeSet(TableManipulationConfiguration.class, (Enum)Element.TABLE_JDBC_STORE, new AttributeDefinition[]{TABLE_NAME_PREFIX, BATCH_SIZE, FETCH_SIZE, CREATE_ON_START, DROP_ON_EXIT});
    }

    TableManipulationConfiguration(AttributeSet attributes, IdColumnConfiguration idColumn, DataColumnConfiguration dataColumn, TimestampColumnConfiguration timestampColumn, SegmentColumnConfiguration segmentColumn) {
        this.attributes = attributes.checkProtection();
        this.tableNamePrefix = attributes.attribute(TABLE_NAME_PREFIX);
        this.batchSize = attributes.attribute(BATCH_SIZE);
        this.fetchSize = attributes.attribute(FETCH_SIZE);
        this.createOnStart = attributes.attribute(CREATE_ON_START);
        this.dropOnExit = attributes.attribute(DROP_ON_EXIT);
        this.idColumn = idColumn;
        this.dataColumn = dataColumn;
        this.timeStamp = timestampColumn;
        this.segmentColumn = segmentColumn;
    }

    public boolean createOnStart() {
        return (Boolean)this.createOnStart.get();
    }

    public boolean dropOnExit() {
        return (Boolean)this.dropOnExit.get();
    }

    public String idColumnName() {
        return this.idColumn.idColumnName();
    }

    public String idColumnType() {
        return this.idColumn.idColumnType();
    }

    public String tableNamePrefix() {
        return (String)this.tableNamePrefix.get();
    }

    public String dataColumnName() {
        return this.dataColumn.dataColumnName();
    }

    public String dataColumnType() {
        return this.dataColumn.dataColumnType();
    }

    public String timestampColumnName() {
        return this.timeStamp.dataColumnName();
    }

    public String timestampColumnType() {
        return this.timeStamp.dataColumnType();
    }

    public String segmentColumnName() {
        return this.segmentColumn.segmentColumnName();
    }

    public String segmentColumnType() {
        return this.segmentColumn.segmentColumnType();
    }

    public int fetchSize() {
        return (Integer)this.fetchSize.get();
    }

    @Deprecated(forRemoval=true, since="9.1")
    public int batchSize() {
        return (Integer)this.batchSize.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public IdColumnConfiguration idColumnConfiguration() {
        return this.idColumn;
    }

    public DataColumnConfiguration dataColumnConfiguration() {
        return this.dataColumn;
    }

    public TimestampColumnConfiguration timeStampColumnConfiguration() {
        return this.timeStamp;
    }

    public SegmentColumnConfiguration segmentColumnConfiguration() {
        return this.segmentColumn;
    }

    public String toString() {
        return "TableManipulationConfiguration [attributes=" + String.valueOf(this.attributes) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableManipulationConfiguration other = (TableManipulationConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }
}

