/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.impl.table.AbstractTableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.impl.table.MyTableOperations;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.util.logging.LogFactory;

class SqlServerTableManager
extends AbstractTableManager {
    private static final Log log = (Log)LogFactory.getLog(MyTableOperations.class, Log.class);

    SqlServerTableManager(InitializationContext ctx, ConnectionFactory connectionFactory, JdbcStringBasedStoreConfiguration config, DbMetaData metaData, String cacheName) {
        super(ctx, connectionFactory, config, metaData, cacheName, log);
    }

    @Override
    public String initUpsertRowSql() {
        if (this.dbMetadata.isSegmentedDisabled()) {
            return String.format("MERGE %1$s WITH (TABLOCK) USING (VALUES (?, ?, ?)) AS tmp (%2$s, %3$s, %4$s) ON (%1$s.%4$s = tmp.%4$s) WHEN MATCHED THEN UPDATE SET %2$s = tmp.%2$s, %3$s = tmp.%3$s WHEN NOT MATCHED THEN INSERT (%2$s, %3$s, %4$s) VALUES (tmp.%2$s, tmp.%3$s, tmp.%4$s);", this.dataTableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return String.format("MERGE %1$s WITH (TABLOCK) USING (VALUES (?, ?, ?, ?)) AS tmp (%2$s, %3$s, %4$s, %5$s) ON (%1$s.%4$s = tmp.%4$s) WHEN MATCHED THEN UPDATE SET %2$s = tmp.%2$s, %3$s = tmp.%3$s WHEN NOT MATCHED THEN INSERT (%2$s, %3$s, %4$s, %5$s) VALUES (tmp.%2$s, tmp.%3$s, tmp.%4$s, %5$s);", this.dataTableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.segmentColumnName());
    }

    @Override
    protected String initSelectOnlyExpiredRowsSql() {
        return String.format("SELECT %1$s, %2$s, %3$s FROM %4$s WITH (UPDLOCK) WHERE %3$s < ? AND %3$s > 0", this.config.dataColumnName(), this.config.idColumnName(), this.config.timestampColumnName(), this.dataTableName);
    }

    @Override
    public boolean isStringEncodingRequired() {
        return this.dbMetadata.getMajorVersion() <= 13;
    }

    @Override
    public String encodeString(String string) {
        char[] srcChars = string.toCharArray();
        if (srcChars.length > 0 && srcChars[0] == '\ufeff') {
            char[] chars = new char[srcChars.length - 1];
            string.getChars(1, string.toCharArray().length, chars, 0);
            return new String(chars);
        }
        return string;
    }
}

