/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import java.sql.Driver;
import org.infinispan.config.ConfigurationException;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfigurationChildBuilder;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.PooledConnectionFactoryConfiguration;

public class PooledConnectionFactoryConfigurationBuilder<S extends AbstractJdbcCacheStoreConfigurationBuilder<?, S>>
extends AbstractJdbcCacheStoreConfigurationChildBuilder<S>
implements ConnectionFactoryConfigurationBuilder<PooledConnectionFactoryConfiguration> {
    private String connectionUrl;
    private String driverClass;
    private String username;
    private String password;

    protected PooledConnectionFactoryConfigurationBuilder(AbstractJdbcCacheStoreConfigurationBuilder<?, S> builder) {
        super(builder);
    }

    public PooledConnectionFactoryConfigurationBuilder<S> connectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    public PooledConnectionFactoryConfigurationBuilder<S> driverClass(Class<? extends Driver> driverClass) {
        this.driverClass = driverClass.getName();
        return this;
    }

    public PooledConnectionFactoryConfigurationBuilder<S> driverClass(String driverClass) {
        this.driverClass = driverClass;
        return this;
    }

    public PooledConnectionFactoryConfigurationBuilder<S> username(String username) {
        this.username = username;
        return this;
    }

    public PooledConnectionFactoryConfigurationBuilder<S> password(String password) {
        this.password = password;
        return this;
    }

    public void validate() {
        if (this.connectionUrl == null) {
            throw new ConfigurationException("Missing connectionUrl parameter");
        }
    }

    public PooledConnectionFactoryConfiguration create() {
        return new PooledConnectionFactoryConfiguration(this.connectionUrl, this.driverClass, this.username, this.password);
    }

    public PooledConnectionFactoryConfigurationBuilder<S> read(PooledConnectionFactoryConfiguration template) {
        this.connectionUrl = template.connectionUrl();
        this.driverClass = template.driverClass();
        this.username = template.username();
        this.password = template.password();
        return this;
    }
}

