/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.io.IOException;
import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.CdContextCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.resources.CacheResource;
import org.infinispan.cli.resources.ContainerResource;
import org.infinispan.cli.resources.Resource;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;

@GroupCommandDefinition(name="rebalance", description="Manage rebalance behaviour", activator=ConnectionActivator.class, groupCommands={Enable.class, Disable.class})
public class Rebalance
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="disable", description="Disable rebalancing", activator=ConnectionActivator.class)
    public static class Disable
    extends RestCliCommand {
        @Argument(description="The path of the resource", completer=CdContextCompleter.class)
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource activeResource) {
            try {
                Resource resource = activeResource.getResource(this.name);
                if (resource instanceof CacheResource) {
                    return client.cache(resource.getName()).disableRebalancing();
                }
                if (resource instanceof ContainerResource) {
                    return client.cacheManager(resource.getName()).disableRebalancing();
                }
                String name = resource.getName();
                throw Messages.MSG.invalidResource(name.isEmpty() ? "/" : name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @CommandDefinition(name="enable", description="Enable rebalancing", activator=ConnectionActivator.class)
    public static class Enable
    extends RestCliCommand {
        @Argument(description="The path of the resource", completer=CdContextCompleter.class)
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource activeResource) {
            try {
                Resource resource = activeResource.getResource(this.name);
                if (resource instanceof CacheResource) {
                    return client.cache(resource.getName()).enableRebalancing();
                }
                if (resource instanceof ContainerResource) {
                    return client.cacheManager(resource.getName()).enableRebalancing();
                }
                String name = resource.getName();
                throw Messages.MSG.invalidResource(name.isEmpty() ? "/" : name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

