/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.connection.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.resources.ContainerResource;
import org.infinispan.cli.resources.Resource;
import org.infinispan.cli.util.IterableJsonReader;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestTaskClient;
import org.infinispan.client.rest.configuration.AuthenticationConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.configuration.ServerConfiguration;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.Util;

public class RestConnection
implements Connection,
Closeable {
    private static final String PROTOBUF_METADATA_CACHE_NAME = "___protobuf_metadata";
    private final RestClientConfigurationBuilder builder;
    private Resource activeResource;
    private MediaType encoding = MediaType.TEXT_PLAIN;
    private Collection<String> availableConfigurations;
    private Collection<String> availableContainers;
    private Collection<String> availableCaches;
    private Collection<String> clusterMembers;
    private RestClient client;
    private boolean connected;
    private String serverVersion;
    private String serverInfo;
    private List<String> sitesView;
    private String localSite;
    private boolean relayNode;
    private List<String> relayNodes;
    private final Path workingDir;

    public RestConnection(RestClientConfigurationBuilder builder) {
        this.builder = builder;
        this.workingDir = Paths.get(System.getProperty("user.dir", ""), new String[0]);
    }

    @Override
    public String getURI() {
        if (this.client != null) {
            return this.client.getConfiguration().toURI();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        Util.close((AutoCloseable)this.client);
    }

    @Override
    public void connect() throws IOException {
        this.client = RestClient.forConfiguration((RestClientConfiguration)this.builder.build());
        AuthenticationConfiguration authentication = this.client.getConfiguration().security().authentication();
        if (authentication.enabled() && authentication.username() != null && authentication.password() == null && !"Bearer".equals(authentication.mechanism())) {
            throw new AccessDeniedException("");
        }
        this.connectInternal();
    }

    @Override
    public void connect(String username, String password) throws IOException {
        this.builder.security().authentication().enable().username(username).password(password);
        this.client = RestClient.forConfiguration((RestClientConfiguration)this.builder.build());
        this.connectInternal();
    }

    private void connectInternal() throws IOException {
        this.serverVersion = (String)this.parseBody(this.fetch(() -> this.client.server().info()), Map.class).get("version");
        this.connected = true;
        this.availableContainers = this.parseBody(this.fetch(() -> this.client.cacheManagers()), List.class);
        this.activeResource = Resource.getRootResource(this).getChild("containers", this.availableContainers.iterator().next());
        this.refreshServerInfo();
    }

    private RestResponse fetch(Supplier<CompletionStage<RestResponse>> responseFutureSupplier) throws IOException {
        return this.fetch(responseFutureSupplier.get());
    }

    private RestResponse fetch(CompletionStage<RestResponse> responseFuture) throws IOException {
        try {
            return responseFuture.toCompletableFuture().get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw Messages.MSG.connectionFailed(e.getMessage());
        }
        catch (TimeoutException e) {
            throw new IOException(e);
        }
    }

    private Map<String, List<String>> parseHeaders(RestResponse response) throws IOException {
        if ((response = this.handleResponseStatus(response)) != null) {
            return response.headers();
        }
        return Collections.emptyMap();
    }

    private <T> T parseBody(RestResponse response, Class<T> returnClass) throws IOException {
        if ((response = this.handleResponseStatus(response)) != null) {
            if (returnClass == InputStream.class) {
                return (T)response.getBodyAsStream();
            }
            if (returnClass == String.class) {
                if (MediaType.APPLICATION_JSON.equals((Object)response.contentType())) {
                    Json json = Json.read((String)response.getBody());
                    return (T)json.toPrettyString();
                }
                return (T)response.getBody();
            }
            if (returnClass == Map.class) {
                return (T)Json.read((String)response.getBody()).asMap();
            }
            if (returnClass == List.class) {
                return (T)Json.read((String)response.getBody()).asList();
            }
        }
        return null;
    }

    private RestResponse handleResponseStatus(RestResponse response) throws IOException {
        switch (response.getStatus()) {
            case 200: 
            case 201: 
            case 202: {
                return response;
            }
            case 204: {
                return null;
            }
            case 401: {
                throw Messages.MSG.unauthorized(response.getBody());
            }
            case 403: {
                throw Messages.MSG.forbidden(response.getBody());
            }
            case 404: {
                throw Messages.MSG.notFound(response.getBody());
            }
        }
        throw Messages.MSG.error(response.getBody());
    }

    @Override
    public MediaType getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(MediaType encoding) {
        this.encoding = encoding;
    }

    @Override
    public String execute(BiFunction<RestClient, Resource, CompletionStage<RestResponse>> op, Connection.ResponseMode responseMode) throws IOException {
        RestResponse r = this.fetch(op.apply(this.client, this.activeResource));
        return this.executeInternal(responseMode, r);
    }

    /*
     * Unable to fully structure code
     */
    private String executeInternal(Connection.ResponseMode responseMode, RestResponse r) throws IOException {
        sb = new StringBuilder();
        switch (1.$SwitchMap$org$infinispan$cli$connection$Connection$ResponseMode[responseMode.ordinal()]) {
            case 1: {
                body = this.parseBody(r, String.class);
                if (body == null) break;
                sb.append(body);
                break;
            }
            case 2: {
                contentDisposition = this.parseHeaders(r).get("Content-Disposition").get(0);
                filename = Util.unquote((String)contentDisposition.split("filename=")[1]);
                file = this.workingDir.resolve(filename);
                os = Files.newOutputStream(file, new OpenOption[0]);
                try {
                    is = this.parseBody(r, InputStream.class);
                    try {
                        buffer = new byte[8192];
                        while ((bytesRead = is.read(buffer)) != -1) {
                            os.write(buffer, 0, bytesRead);
                        }
                        sb.append(Messages.MSG.downloadedFile(filename));
                        break;
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                finally {
                    if (os == null) ** GOTO lbl32
                    os.close();
                }
            }
lbl32:
            // 2 sources

            case 3: {
                break;
            }
            case 4: {
                sb.append(Json.make(this.parseHeaders(r)).toPrettyString());
                break;
            }
            default: {
                throw new IllegalArgumentException(responseMode.name());
            }
        }
        this.refreshServerInfo();
        return sb.toString();
    }

    @Override
    public Resource getActiveResource() {
        return this.activeResource;
    }

    @Override
    public void setActiveResource(Resource resource) {
        this.activeResource = resource;
    }

    @Override
    public ContainerResource getActiveContainer() {
        return this.activeResource.findAncestor(ContainerResource.class);
    }

    @Override
    public Collection<String> getAvailableCaches(String container) {
        return this.availableCaches;
    }

    @Override
    public Collection<String> getAvailableContainers() {
        return this.availableContainers;
    }

    @Override
    public Collection<String> getAvailableCounters(String container) throws IOException {
        return this.parseBody(this.fetch(() -> this.client.counters()), List.class);
    }

    @Override
    public Collection<String> getAvailableCacheConfigurations(String container) {
        return this.availableConfigurations;
    }

    @Override
    public Collection<String> getAvailableSchemas(String container) throws IOException {
        ArrayList<String> schemas = new ArrayList<String>();
        this.getCacheKeys(container, PROTOBUF_METADATA_CACHE_NAME).forEach(schemas::add);
        return schemas;
    }

    @Override
    public Collection<String> getAvailableServers(String container) throws IOException {
        return (List)this.parseBody(this.fetch(() -> this.client.cacheManager(container).info()), Map.class).get("cluster_members");
    }

    @Override
    public Collection<String> getAvailableTasks(String container) throws IOException {
        List list = this.parseBody(this.fetch(() -> this.client.tasks().list(RestTaskClient.ResultType.ALL)), List.class);
        return list.stream().map(i -> (String)i.get("name")).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAvailableSites(String container, String cache) throws IOException {
        Map sites = this.parseBody(this.fetch(() -> this.client.cache(cache).xsiteBackups()), Map.class);
        return sites == null ? Collections.emptyList() : sites.keySet();
    }

    @Override
    public Iterable<String> getCacheKeys(String container, String cache) throws IOException {
        return new IterableJsonReader(this.parseBody(this.fetch(() -> this.client.cache(cache).keys()), InputStream.class), s -> s == null || "_value".equals(s));
    }

    @Override
    public Iterable<String> getCounterValue(String container, String counter) throws IOException {
        return Collections.singletonList(this.parseBody(this.fetch(() -> this.client.counter(counter).get()), String.class));
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public String describeContainer(String container) throws IOException {
        return this.parseBody(this.fetch(() -> this.client.cacheManager(container).info()), String.class);
    }

    @Override
    public String describeCache(String container, String cache) throws IOException {
        return this.parseBody(this.fetch(() -> this.client.cache(cache).configuration()), String.class);
    }

    @Override
    public String describeKey(String container, String cache, String key) throws IOException {
        Map<String, List<String>> headers = this.parseHeaders(this.fetch(() -> this.client.cache(cache).head(key)));
        return Json.make(headers).toPrettyString();
    }

    @Override
    public String describeConfiguration(String container, String counter) {
        return null;
    }

    @Override
    public String describeCounter(String container, String counter) throws IOException {
        return this.parseBody(this.fetch(() -> this.client.counter(counter).configuration()), String.class);
    }

    @Override
    public String describeTask(String container, String taskName) throws IOException {
        List list = this.parseBody(this.fetch(() -> this.client.tasks().list(RestTaskClient.ResultType.ALL)), List.class);
        Optional<Map> task = list.stream().filter(i -> taskName.equals(i.get("name"))).findFirst();
        return task.map(Object::toString).orElseThrow(() -> Messages.MSG.noSuchResource(taskName));
    }

    @Override
    public Collection<String> getAvailableLogAppenders() throws IOException {
        Map map = this.parseBody(this.fetch(() -> this.client.server().logging().listAppenders()), Map.class);
        return map.keySet();
    }

    @Override
    public Collection<String> getAvailableLoggers() throws IOException {
        List list = this.parseBody(this.fetch(() -> this.client.server().logging().listLoggers()), List.class);
        return list.stream().map(i -> i.get("name").toString()).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getClusterNodes() {
        return this.clusterMembers;
    }

    @Override
    public String getConnectionInfo() {
        return this.serverInfo;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public Collection<String> getBackupNames(String container) throws IOException {
        return this.parseBody(this.fetch(this.client.cacheManager(container).getBackupNames()), List.class);
    }

    @Override
    public Collection<String> getSitesView() {
        return this.sitesView;
    }

    @Override
    public String getLocalSiteName() {
        return this.localSite;
    }

    @Override
    public boolean isRelayNode() {
        return this.relayNode;
    }

    @Override
    public Collection<String> getRelayNodes() {
        return this.relayNodes;
    }

    @Override
    public Collection<String> getConnectorNames() throws IOException {
        return this.parseBody(this.fetch(this.client.server().connectorNames()), List.class);
    }

    @Override
    public Collection<String> getDataSourceNames() throws IOException {
        return this.parseBody(this.fetch(this.client.server().dataSourceNames()), List.class);
    }

    @Override
    public Collection<String> getCacheConfigurationAttributes(String name) {
        try {
            return name == null ? Collections.emptyList() : (Collection)this.parseBody(this.fetch(this.client.cache(name).configurationAttributes()), List.class);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public void refreshServerInfo() throws IOException {
        try {
            ContainerResource container = this.getActiveContainer();
            String containerName = container.getName();
            Map cacheManagerInfo = this.parseBody(this.fetch(() -> this.client.cacheManager(containerName).info()), Map.class);
            List definedCaches = (List)cacheManagerInfo.get("defined_caches");
            this.availableCaches = new ArrayList<String>();
            definedCaches.forEach(m -> this.availableCaches.add((String)m.get("name")));
            this.availableCaches.remove(PROTOBUF_METADATA_CACHE_NAME);
            List configurationList = this.parseBody(this.fetch(() -> this.client.cacheManager(containerName).cacheConfigurations()), List.class);
            this.availableConfigurations = new ArrayList<String>(configurationList.size());
            for (Object item : configurationList) {
                this.availableConfigurations.add((String)((Map)item).get("name"));
            }
            String nodeAddress = (String)cacheManagerInfo.get("node_address");
            String clusterName = (String)cacheManagerInfo.get("cluster_name");
            this.localSite = (String)cacheManagerInfo.get("local_site");
            this.sitesView = new ArrayList<String>((Collection)cacheManagerInfo.get("sites_view"));
            Collections.sort(this.sitesView);
            this.relayNode = cacheManagerInfo.containsKey("relay_node") ? (Boolean)cacheManagerInfo.get("relay_node") : false;
            this.relayNodes = (List)cacheManagerInfo.get("relay_nodes_address");
            this.clusterMembers = (Collection)cacheManagerInfo.get("cluster_members");
            if (nodeAddress != null) {
                this.serverInfo = nodeAddress + "@" + clusterName;
            } else {
                ServerConfiguration serverConfiguration = (ServerConfiguration)this.client.getConfiguration().servers().get(0);
                this.serverInfo = serverConfiguration.host() + ":" + serverConfiguration.port();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public String getUsername() {
        return this.builder.build().security().authentication().username();
    }

    RestClientConfigurationBuilder getBuilder() {
        return this.builder;
    }

    public String toString() {
        return this.serverInfo;
    }
}

