/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.Codec10;
import org.infinispan.client.hotrod.impl.protocol.Codec11;
import org.infinispan.client.hotrod.impl.protocol.Codec12;

public class CodecFactory {
    private static final Map<String, Codec> codecMap;
    private static final Codec CODEC_10;
    private static final Codec CODEC_11;
    private static final Codec CODEC_12;

    public static Codec getCodec(String version) {
        if (codecMap.containsKey(version)) {
            return codecMap.get(version);
        }
        throw new IllegalArgumentException("Invalid Hot Rod protocol version");
    }

    static {
        CODEC_10 = new Codec10();
        CODEC_11 = new Codec11();
        CODEC_12 = new Codec12();
        codecMap = new HashMap<String, Codec>();
        codecMap.put("1.0", CODEC_10);
        codecMap.put("1.1", CODEC_11);
        codecMap.put("1.2", CODEC_12);
    }
}

