/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.util.concurrent.CompletionStage;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestSchemaClient;
import org.infinispan.client.rest.impl.okhttp.RestClientOkHttp;
import org.infinispan.client.rest.impl.okhttp.RestEntityAdaptorOkHttp;

public class RestSchemasClientOkHttp
implements RestSchemaClient {
    private final RestClientOkHttp client;
    private final String baseUrl;

    public RestSchemasClientOkHttp(RestClientOkHttp client) {
        this.client = client;
        this.baseUrl = String.format("%s%s/v2/schemas", client.getBaseURL(), client.getConfiguration().contextPath()).replaceAll("//", "/");
    }

    @Override
    public CompletionStage<RestResponse> names() {
        return this.client.execute(this.baseUrl, new String[0]);
    }

    @Override
    public CompletionStage<RestResponse> types() {
        return this.client.execute(this.baseUrl + "?action=types", new String[0]);
    }

    @Override
    public CompletionStage<RestResponse> post(String schemaName, String schemaContents) {
        Request.Builder builder = new Request.Builder();
        RequestBody body = RequestBody.create((MediaType)RestClientOkHttp.TEXT_PLAIN, (String)schemaContents);
        builder.url(this.schemaUrl(schemaName)).post(body);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> post(String schemaName, RestEntity schemaContents) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.schemaUrl(schemaName)).post(((RestEntityAdaptorOkHttp)((Object)schemaContents)).toRequestBody());
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> put(String schemaName, String schemaContents) {
        Request.Builder builder = new Request.Builder();
        RequestBody body = RequestBody.create((MediaType)RestClientOkHttp.TEXT_PLAIN, (String)schemaContents);
        builder.url(this.schemaUrl(schemaName)).put(body);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> put(String schemaName, RestEntity schemaContents) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.schemaUrl(schemaName)).put(((RestEntityAdaptorOkHttp)((Object)schemaContents)).toRequestBody());
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> delete(String schemaName) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.schemaUrl(schemaName)).delete();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> get(String schemaName) {
        Request.Builder builder = new Request.Builder();
        builder.header("Accept", "text/plain");
        return this.client.execute(this.schemaUrl(schemaName), new String[0]);
    }

    private String schemaUrl(String name) {
        return this.baseUrl + "/" + RestClientOkHttp.sanitize(name);
    }
}

