/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.lock.impl.entries.ClusteredLockState;
import org.infinispan.lock.impl.externalizers.ExternalizerIds;

public class ClusteredLockValue {
    public static final ClusteredLockValue INITIAL_STATE = new ClusteredLockValue();
    public static final AdvancedExternalizer<ClusteredLockValue> EXTERNALIZER = new Externalizer();
    private final String requestId;
    private final Object owner;
    private final ClusteredLockState state;

    public ClusteredLockValue(String requestId, Object owner, ClusteredLockState state) {
        this.requestId = requestId;
        this.owner = owner;
        this.state = state;
    }

    private ClusteredLockValue() {
        this.requestId = null;
        this.owner = null;
        this.state = ClusteredLockState.RELEASED;
    }

    public ClusteredLockState getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredLockValue that = (ClusteredLockValue)o;
        return Objects.equals(this.requestId, that.requestId) && Objects.equals(this.owner, that.owner) && Objects.equals((Object)this.state, (Object)that.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestId, this.owner, this.state});
    }

    public String toString() {
        return "ClusteredLockValue{ requestId=" + this.requestId + " owner=" + String.valueOf(this.owner) + " state=" + String.valueOf((Object)this.state) + "}";
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Object getOwner() {
        return this.owner;
    }

    private static class Externalizer
    implements AdvancedExternalizer<ClusteredLockValue> {
        private Externalizer() {
        }

        public Set<Class<? extends ClusteredLockValue>> getTypeClasses() {
            return Collections.singleton(ClusteredLockValue.class);
        }

        public Integer getId() {
            return ExternalizerIds.CLUSTERED_LOCK_VALUE;
        }

        public void writeObject(ObjectOutput output, ClusteredLockValue object) throws IOException {
            MarshallUtil.marshallString((String)object.requestId, (ObjectOutput)output);
            output.writeObject(object.owner);
            MarshallUtil.marshallEnum((Enum)object.state, (ObjectOutput)output);
        }

        public ClusteredLockValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String requestId = MarshallUtil.unmarshallString((ObjectInput)input);
            Object owner = input.readObject();
            ClusteredLockState state = (ClusteredLockState)MarshallUtil.unmarshallEnum((ObjectInput)input, ClusteredLockState::valueOf);
            return new ClusteredLockValue(requestId, owner, state);
        }
    }
}

