/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public final class ByteQuantity {
    private static final Pattern REGEX_PATTERN = Pattern.compile("^(\\d*\\.?\\d+)\\s*((?:(?:[KMGT]i?)B)|B)?$");
    private static final BigDecimal KILO = new BigDecimal(1000);
    private static final BigDecimal KIBI = new BigDecimal(1024);
    private static final Log log = LogFactory.getLog(ByteQuantity.class);

    public static long parse(String str) throws IllegalArgumentException {
        Matcher matcher = REGEX_PATTERN.matcher(str);
        if (!matcher.find()) {
            throw log.cannotParseQuantity(str);
        }
        try {
            String numberPart = matcher.group(1);
            String unit = matcher.group(2);
            BigDecimal number = new BigDecimal(numberPart);
            if (unit == null) {
                if (numberPart.contains(".")) {
                    throw log.cannotParseQuantity(str);
                }
                return number.longValueExact();
            }
            return Unit.valueOf(unit).toBytes(number);
        }
        catch (ArithmeticException e) {
            throw log.cannotParseQuantity(str);
        }
    }

    private static enum Unit {
        B(KILO, 0),
        KB(KILO, 1),
        MB(KILO, 2),
        GB(KILO, 3),
        TB(KILO, 4),
        KiB(KIBI, 1),
        MiB(KIBI, 2),
        GiB(KIBI, 3),
        TiB(KIBI, 4);

        BigDecimal base;
        int exp;

        private Unit(BigDecimal base, int exp) {
            this.base = base;
            this.exp = exp;
        }

        long toBytes(BigDecimal quantity) {
            return quantity.multiply(this.base.pow(this.exp)).longValueExact();
        }
    }
}

